// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.transform

import aws.sdk.kotlin.services.ecr.model.EcrException
import aws.sdk.kotlin.services.ecr.model.GetDownloadUrlForLayerResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetDownloadUrlForLayerOperationDeserializer: HttpDeserialize<GetDownloadUrlForLayerResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetDownloadUrlForLayerResponse {
        if (!response.status.isSuccess()) {
            throwGetDownloadUrlForLayerError(context, response)
        }
        val builder = GetDownloadUrlForLayerResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDownloadUrlForLayerOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetDownloadUrlForLayerError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw EcrException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "LayerInaccessibleException" -> LayerInaccessibleExceptionDeserializer().deserialize(context, wrappedResponse)
        "LayersNotFoundException" -> LayersNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryNotFoundException" -> RepositoryNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServerException" -> ServerExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> EcrException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDownloadUrlForLayerOperationBody(builder: GetDownloadUrlForLayerResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DOWNLOADURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("downloadUrl"))
    val LAYERDIGEST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("layerDigest"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DOWNLOADURL_DESCRIPTOR)
        field(LAYERDIGEST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DOWNLOADURL_DESCRIPTOR.index -> builder.downloadUrl = deserializeString()
                LAYERDIGEST_DESCRIPTOR.index -> builder.layerDigest = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
