// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.model



public class DescribePullThroughCacheRulesRequest private constructor(builder: Builder) {
    /**
     * The Amazon ECR repository prefixes associated with the pull through cache rules to return. If no repository prefix value is specified, all pull through cache rules are returned.
     */
    public val ecrRepositoryPrefixes: List<String>? = builder.ecrRepositoryPrefixes
    /**
     * The maximum number of pull through cache rules returned by `DescribePullThroughCacheRulesRequest` in paginated output. When this parameter is used, `DescribePullThroughCacheRulesRequest` only returns `maxResults` results in a single page along with a `nextToken` response element. The remaining results of the initial request can be seen by sending another `DescribePullThroughCacheRulesRequest` request with the returned `nextToken` value. This value can be between 1 and 1000. If this parameter is not used, then `DescribePullThroughCacheRulesRequest` returns up to 100 results and a `nextToken` value, if applicable.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The `nextToken` value returned from a previous paginated `DescribePullThroughCacheRulesRequest` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value. This value is null when there are no more results to return.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The Amazon Web Services account ID associated with the registry to return the pull through cache rules for. If you do not specify a registry, the default registry is assumed.
     */
    public val registryId: kotlin.String? = builder.registryId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecr.model.DescribePullThroughCacheRulesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribePullThroughCacheRulesRequest(")
        append("ecrRepositoryPrefixes=$ecrRepositoryPrefixes,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("registryId=$registryId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ecrRepositoryPrefixes?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (registryId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribePullThroughCacheRulesRequest

        if (ecrRepositoryPrefixes != other.ecrRepositoryPrefixes) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (registryId != other.registryId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecr.model.DescribePullThroughCacheRulesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon ECR repository prefixes associated with the pull through cache rules to return. If no repository prefix value is specified, all pull through cache rules are returned.
         */
        public var ecrRepositoryPrefixes: List<String>? = null
        /**
         * The maximum number of pull through cache rules returned by `DescribePullThroughCacheRulesRequest` in paginated output. When this parameter is used, `DescribePullThroughCacheRulesRequest` only returns `maxResults` results in a single page along with a `nextToken` response element. The remaining results of the initial request can be seen by sending another `DescribePullThroughCacheRulesRequest` request with the returned `nextToken` value. This value can be between 1 and 1000. If this parameter is not used, then `DescribePullThroughCacheRulesRequest` returns up to 100 results and a `nextToken` value, if applicable.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The `nextToken` value returned from a previous paginated `DescribePullThroughCacheRulesRequest` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value. This value is null when there are no more results to return.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The Amazon Web Services account ID associated with the registry to return the pull through cache rules for. If you do not specify a registry, the default registry is assumed.
         */
        public var registryId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecr.model.DescribePullThroughCacheRulesRequest) : this() {
            this.ecrRepositoryPrefixes = x.ecrRepositoryPrefixes
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.registryId = x.registryId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecr.model.DescribePullThroughCacheRulesRequest = DescribePullThroughCacheRulesRequest(this)
    }
}
