// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.endpoints.internal

import aws.sdk.kotlin.runtime.endpoint.applyToRequest
import aws.sdk.kotlin.runtime.endpoint.authScheme
import aws.sdk.kotlin.services.ecr.EcrClient
import aws.sdk.kotlin.services.ecr.endpoints.EndpointParameters
import aws.sdk.kotlin.services.ecr.endpoints.EndpointProvider
import aws.smithy.kotlin.runtime.client.ProtocolRequestInterceptorContext
import aws.smithy.kotlin.runtime.client.RequestInterceptorContext
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.http.middleware.setResolvedEndpoint
import aws.smithy.kotlin.runtime.http.operation.SdkHttpRequest
import aws.smithy.kotlin.runtime.http.request.HttpRequest
import aws.smithy.kotlin.runtime.http.request.toBuilder
import aws.smithy.kotlin.runtime.tracing.debug
import kotlin.coroutines.coroutineContext

internal class ResolveEndpoint<I>(
    private val endpointProvider: EndpointProvider,
    private val buildParams: EndpointParameters.Builder.(input: I) -> Unit,
): HttpInterceptor {
    private lateinit var params: EndpointParameters

    override fun readBeforeSerialization(context: RequestInterceptorContext<Any>) {
        @Suppress("UNCHECKED_CAST")
        val input = context.request as I
        params = EndpointParameters { buildParams(input) }
    }

    override suspend fun modifyBeforeRetryLoop(context: ProtocolRequestInterceptorContext<Any, HttpRequest>): HttpRequest {
        val endpoint = endpointProvider.resolveEndpoint(params)
        coroutineContext.debug<ResolveEndpoint<*>>{ "resolved endpoint: $endpoint" }
        val reqBuilder = context.protocolRequest.toBuilder()
        val req = SdkHttpRequest(context.executionContext, reqBuilder)
        setResolvedEndpoint(req, endpoint)
        endpoint.authScheme?.applyToRequest(req)
        return req.subject.build()
    }
}

internal fun EndpointParameters.Builder.bindAwsBuiltins(config: EcrClient.Config) {
    region = config.region
    useDualStack = config.useDualStack
    useFips = config.useFips
    endpoint = config.endpointUrl?.toString()
}
