// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ecr.model.BatchCheckLayerAvailabilityResponse
import aws.sdk.kotlin.services.ecr.model.EcrException
import aws.sdk.kotlin.services.ecr.model.Layer
import aws.sdk.kotlin.services.ecr.model.LayerFailure
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchCheckLayerAvailabilityOperationDeserializer: HttpDeserialize<BatchCheckLayerAvailabilityResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchCheckLayerAvailabilityResponse {
        if (!response.status.isSuccess()) {
            throwBatchCheckLayerAvailabilityError(context, response)
        }
        val builder = BatchCheckLayerAvailabilityResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchCheckLayerAvailabilityOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchCheckLayerAvailabilityError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw EcrException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryNotFoundException" -> RepositoryNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServerException" -> ServerExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> EcrException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchCheckLayerAvailabilityOperationBody(builder: BatchCheckLayerAvailabilityResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FAILURES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failures"))
    val LAYERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("layers"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FAILURES_DESCRIPTOR)
        field(LAYERS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FAILURES_DESCRIPTOR.index -> builder.failures =
                    deserializer.deserializeList(FAILURES_DESCRIPTOR) {
                        val col0 = mutableListOf<LayerFailure>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeLayerFailureDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LAYERS_DESCRIPTOR.index -> builder.layers =
                    deserializer.deserializeList(LAYERS_DESCRIPTOR) {
                        val col0 = mutableListOf<Layer>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeLayerDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
