// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.model



/**
 * Deletes specified images within a specified repository. Images are specified with either the `imageTag` or `imageDigest`.
 */
public class BatchDeleteImageRequest private constructor(builder: Builder) {
    /**
     * A list of image ID references that correspond to images to delete. The format of the `imageIds` reference is `imageTag=tag` or `imageDigest=digest`.
     */
    public val imageIds: List<ImageIdentifier>? = builder.imageIds
    /**
     * The Amazon Web Services account ID associated with the registry that contains the image to delete. If you do not specify a registry, the default registry is assumed.
     */
    public val registryId: kotlin.String? = builder.registryId
    /**
     * The repository that contains the image to delete.
     */
    public val repositoryName: kotlin.String? = builder.repositoryName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecr.model.BatchDeleteImageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchDeleteImageRequest(")
        append("imageIds=$imageIds,")
        append("registryId=$registryId,")
        append("repositoryName=$repositoryName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = imageIds?.hashCode() ?: 0
        result = 31 * result + (registryId?.hashCode() ?: 0)
        result = 31 * result + (repositoryName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchDeleteImageRequest

        if (imageIds != other.imageIds) return false
        if (registryId != other.registryId) return false
        if (repositoryName != other.repositoryName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecr.model.BatchDeleteImageRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of image ID references that correspond to images to delete. The format of the `imageIds` reference is `imageTag=tag` or `imageDigest=digest`.
         */
        public var imageIds: List<ImageIdentifier>? = null
        /**
         * The Amazon Web Services account ID associated with the registry that contains the image to delete. If you do not specify a registry, the default registry is assumed.
         */
        public var registryId: kotlin.String? = null
        /**
         * The repository that contains the image to delete.
         */
        public var repositoryName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecr.model.BatchDeleteImageRequest) : this() {
            this.imageIds = x.imageIds
            this.registryId = x.registryId
            this.repositoryName = x.repositoryName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecr.model.BatchDeleteImageRequest = BatchDeleteImageRequest(this)
    }
}
