// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.endpoints

import aws.sdk.kotlin.services.ecr.endpoints.internal.partition
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.endpoints.Endpoint
import aws.smithy.kotlin.runtime.http.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.http.endpoints.functions.parseUrl

/**
 * The default endpoint provider as specified by the service model.
 */
public class DefaultEndpointProvider: EndpointProvider {
    public override suspend fun resolveEndpoint(params: EndpointParameters): Endpoint {
        run {
            val partitionResult = partition(params.region)
            if (
                partitionResult != null
            ) {
                run {
                    val url = parseUrl(params.endpoint)
                    if (
                        url != null &&
                        params.endpoint != null
                    ) {
                        if (
                            params.useFips == true
                        ) {
                            throw EndpointProviderException("Invalid Configuration: FIPS and custom endpoint are not supported")
                        }
                        if (
                            params.useDualStack == true
                        ) {
                            throw EndpointProviderException("Invalid Configuration: Dualstack and custom endpoint are not supported")
                        }
                        return Endpoint(
                            Url.parse(params.endpoint),
                        )
                    }
                }
                if (
                    params.useFips == true &&
                    params.useDualStack == true
                ) {
                    if (
                        true == partitionResult?.supportsFIPS &&
                        true == partitionResult?.supportsDualStack
                    ) {
                        return Endpoint(
                            Url.parse("https://api.ecr-fips.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                        )
                    }
                    throw EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both")
                }
                if (
                    params.useFips == true
                ) {
                    if (
                        true == partitionResult?.supportsFIPS
                    ) {
                        if (
                            params.region == "dkr-us-east-2"
                        ) {
                            return Endpoint(
                                Url.parse("https://ecr-fips.us-east-2.amazonaws.com"),
                            )
                        }
                        if (
                            params.region == "dkr-us-east-1"
                        ) {
                            return Endpoint(
                                Url.parse("https://ecr-fips.us-east-1.amazonaws.com"),
                            )
                        }
                        if (
                            params.region == "dkr-us-west-2"
                        ) {
                            return Endpoint(
                                Url.parse("https://ecr-fips.us-west-2.amazonaws.com"),
                            )
                        }
                        if (
                            params.region == "dkr-us-west-1"
                        ) {
                            return Endpoint(
                                Url.parse("https://ecr-fips.us-west-1.amazonaws.com"),
                            )
                        }
                        if (
                            "aws" == partitionResult?.name
                        ) {
                            return Endpoint(
                                Url.parse("https://ecr-fips.${params.region}.${partitionResult?.dnsSuffix}"),
                            )
                        }
                        if (
                            params.region == "dkr-us-gov-east-1"
                        ) {
                            return Endpoint(
                                Url.parse("https://ecr-fips.us-gov-east-1.amazonaws.com"),
                            )
                        }
                        if (
                            params.region == "dkr-us-gov-west-1"
                        ) {
                            return Endpoint(
                                Url.parse("https://ecr-fips.us-gov-west-1.amazonaws.com"),
                            )
                        }
                        if (
                            "aws-us-gov" == partitionResult?.name
                        ) {
                            return Endpoint(
                                Url.parse("https://ecr-fips.${params.region}.${partitionResult?.dnsSuffix}"),
                            )
                        }
                        return Endpoint(
                            Url.parse("https://api.ecr-fips.${params.region}.${partitionResult?.dnsSuffix}"),
                        )
                    }
                    throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                }
                if (
                    params.useDualStack == true
                ) {
                    if (
                        true == partitionResult?.supportsDualStack
                    ) {
                        return Endpoint(
                            Url.parse("https://api.ecr.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                        )
                    }
                    throw EndpointProviderException("DualStack is enabled but this partition does not support DualStack")
                }
                return Endpoint(
                    Url.parse("https://api.ecr.${params.region}.${partitionResult?.dnsSuffix}"),
                )
            }
        }

        throw EndpointProviderException("endpoint rules were exhausted without a match")
    }
}
