// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of an enhanced image scan. This is returned when enhanced scanning is enabled for your private registry.
 */
public class EnhancedImageScanFinding private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID associated with the image.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The description of the finding.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Number (ARN) of the finding.
     */
    public val findingArn: kotlin.String? = builder.findingArn
    /**
     * The date and time that the finding was first observed.
     */
    public val firstObservedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.firstObservedAt
    /**
     * The date and time that the finding was last observed.
     */
    public val lastObservedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastObservedAt
    /**
     * An object that contains the details of a package vulnerability finding.
     */
    public val packageVulnerabilityDetails: aws.sdk.kotlin.services.ecr.model.PackageVulnerabilityDetails? = builder.packageVulnerabilityDetails
    /**
     * An object that contains the details about how to remediate a finding.
     */
    public val remediation: aws.sdk.kotlin.services.ecr.model.Remediation? = builder.remediation
    /**
     * Contains information on the resources involved in a finding.
     */
    public val resources: List<Resource>? = builder.resources
    /**
     * The Amazon Inspector score given to the finding.
     */
    public val score: kotlin.Double = builder.score
    /**
     * An object that contains details of the Amazon Inspector score.
     */
    public val scoreDetails: aws.sdk.kotlin.services.ecr.model.ScoreDetails? = builder.scoreDetails
    /**
     * The severity of the finding.
     */
    public val severity: kotlin.String? = builder.severity
    /**
     * The status of the finding.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The title of the finding.
     */
    public val title: kotlin.String? = builder.title
    /**
     * The type of the finding.
     */
    public val type: kotlin.String? = builder.type
    /**
     * The date and time the finding was last updated at.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecr.model.EnhancedImageScanFinding = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EnhancedImageScanFinding(")
        append("awsAccountId=$awsAccountId,")
        append("description=$description,")
        append("findingArn=$findingArn,")
        append("firstObservedAt=$firstObservedAt,")
        append("lastObservedAt=$lastObservedAt,")
        append("packageVulnerabilityDetails=$packageVulnerabilityDetails,")
        append("remediation=$remediation,")
        append("resources=$resources,")
        append("score=$score,")
        append("scoreDetails=$scoreDetails,")
        append("severity=$severity,")
        append("status=$status,")
        append("title=$title,")
        append("type=$type,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (findingArn?.hashCode() ?: 0)
        result = 31 * result + (firstObservedAt?.hashCode() ?: 0)
        result = 31 * result + (lastObservedAt?.hashCode() ?: 0)
        result = 31 * result + (packageVulnerabilityDetails?.hashCode() ?: 0)
        result = 31 * result + (remediation?.hashCode() ?: 0)
        result = 31 * result + (resources?.hashCode() ?: 0)
        result = 31 * result + (score.hashCode())
        result = 31 * result + (scoreDetails?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EnhancedImageScanFinding

        if (awsAccountId != other.awsAccountId) return false
        if (description != other.description) return false
        if (findingArn != other.findingArn) return false
        if (firstObservedAt != other.firstObservedAt) return false
        if (lastObservedAt != other.lastObservedAt) return false
        if (packageVulnerabilityDetails != other.packageVulnerabilityDetails) return false
        if (remediation != other.remediation) return false
        if (resources != other.resources) return false
        if (score != other.score) return false
        if (scoreDetails != other.scoreDetails) return false
        if (severity != other.severity) return false
        if (status != other.status) return false
        if (title != other.title) return false
        if (type != other.type) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecr.model.EnhancedImageScanFinding = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services account ID associated with the image.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The description of the finding.
         */
        public var description: kotlin.String? = null
        /**
         * The Amazon Resource Number (ARN) of the finding.
         */
        public var findingArn: kotlin.String? = null
        /**
         * The date and time that the finding was first observed.
         */
        public var firstObservedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time that the finding was last observed.
         */
        public var lastObservedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An object that contains the details of a package vulnerability finding.
         */
        public var packageVulnerabilityDetails: aws.sdk.kotlin.services.ecr.model.PackageVulnerabilityDetails? = null
        /**
         * An object that contains the details about how to remediate a finding.
         */
        public var remediation: aws.sdk.kotlin.services.ecr.model.Remediation? = null
        /**
         * Contains information on the resources involved in a finding.
         */
        public var resources: List<Resource>? = null
        /**
         * The Amazon Inspector score given to the finding.
         */
        public var score: kotlin.Double = 0.0
        /**
         * An object that contains details of the Amazon Inspector score.
         */
        public var scoreDetails: aws.sdk.kotlin.services.ecr.model.ScoreDetails? = null
        /**
         * The severity of the finding.
         */
        public var severity: kotlin.String? = null
        /**
         * The status of the finding.
         */
        public var status: kotlin.String? = null
        /**
         * The title of the finding.
         */
        public var title: kotlin.String? = null
        /**
         * The type of the finding.
         */
        public var type: kotlin.String? = null
        /**
         * The date and time the finding was last updated at.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecr.model.EnhancedImageScanFinding) : this() {
            this.awsAccountId = x.awsAccountId
            this.description = x.description
            this.findingArn = x.findingArn
            this.firstObservedAt = x.firstObservedAt
            this.lastObservedAt = x.lastObservedAt
            this.packageVulnerabilityDetails = x.packageVulnerabilityDetails
            this.remediation = x.remediation
            this.resources = x.resources
            this.score = x.score
            this.scoreDetails = x.scoreDetails
            this.severity = x.severity
            this.status = x.status
            this.title = x.title
            this.type = x.type
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecr.model.EnhancedImageScanFinding = EnhancedImageScanFinding(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecr.model.PackageVulnerabilityDetails] inside the given [block]
         */
        public fun packageVulnerabilityDetails(block: aws.sdk.kotlin.services.ecr.model.PackageVulnerabilityDetails.Builder.() -> kotlin.Unit) {
            this.packageVulnerabilityDetails = aws.sdk.kotlin.services.ecr.model.PackageVulnerabilityDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecr.model.Remediation] inside the given [block]
         */
        public fun remediation(block: aws.sdk.kotlin.services.ecr.model.Remediation.Builder.() -> kotlin.Unit) {
            this.remediation = aws.sdk.kotlin.services.ecr.model.Remediation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecr.model.ScoreDetails] inside the given [block]
         */
        public fun scoreDetails(block: aws.sdk.kotlin.services.ecr.model.ScoreDetails.Builder.() -> kotlin.Unit) {
            this.scoreDetails = aws.sdk.kotlin.services.ecr.model.ScoreDetails.invoke(block)
        }
    }
}
