// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object that describes an image returned by a DescribeImages operation.
 */
public class ImageDetail private constructor(builder: Builder) {
    /**
     * The artifact media type of the image.
     */
    public val artifactMediaType: kotlin.String? = builder.artifactMediaType
    /**
     * The `sha256` digest of the image manifest.
     */
    public val imageDigest: kotlin.String? = builder.imageDigest
    /**
     * The media type of the image manifest.
     */
    public val imageManifestMediaType: kotlin.String? = builder.imageManifestMediaType
    /**
     * The date and time, expressed in standard JavaScript date format, at which the current image was pushed to the repository.
     */
    public val imagePushedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.imagePushedAt
    /**
     * A summary of the last completed image scan.
     */
    public val imageScanFindingsSummary: aws.sdk.kotlin.services.ecr.model.ImageScanFindingsSummary? = builder.imageScanFindingsSummary
    /**
     * The current state of the scan.
     */
    public val imageScanStatus: aws.sdk.kotlin.services.ecr.model.ImageScanStatus? = builder.imageScanStatus
    /**
     * The size, in bytes, of the image in the repository.
     *
     * If the image is a manifest list, this will be the max size of all manifests in the list.
     *
     * Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker registry. The output of the `docker images` command shows the uncompressed image size, so it may return a larger image size than the image sizes returned by DescribeImages.
     */
    public val imageSizeInBytes: kotlin.Long? = builder.imageSizeInBytes
    /**
     * The list of tags associated with this image.
     */
    public val imageTags: List<String>? = builder.imageTags
    /**
     * The date and time, expressed in standard JavaScript date format, when Amazon ECR recorded the last image pull.
     *
     * Amazon ECR refreshes the last image pull timestamp at least once every 24 hours. For example, if you pull an image once a day then the `lastRecordedPullTime` timestamp will indicate the exact time that the image was last pulled. However, if you pull an image once an hour, because Amazon ECR refreshes the `lastRecordedPullTime` timestamp at least once every 24 hours, the result may not be the exact time that the image was last pulled.
     */
    public val lastRecordedPullTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastRecordedPullTime
    /**
     * The Amazon Web Services account ID associated with the registry to which this image belongs.
     */
    public val registryId: kotlin.String? = builder.registryId
    /**
     * The name of the repository to which this image belongs.
     */
    public val repositoryName: kotlin.String? = builder.repositoryName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecr.model.ImageDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImageDetail(")
        append("artifactMediaType=$artifactMediaType,")
        append("imageDigest=$imageDigest,")
        append("imageManifestMediaType=$imageManifestMediaType,")
        append("imagePushedAt=$imagePushedAt,")
        append("imageScanFindingsSummary=$imageScanFindingsSummary,")
        append("imageScanStatus=$imageScanStatus,")
        append("imageSizeInBytes=$imageSizeInBytes,")
        append("imageTags=$imageTags,")
        append("lastRecordedPullTime=$lastRecordedPullTime,")
        append("registryId=$registryId,")
        append("repositoryName=$repositoryName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = artifactMediaType?.hashCode() ?: 0
        result = 31 * result + (imageDigest?.hashCode() ?: 0)
        result = 31 * result + (imageManifestMediaType?.hashCode() ?: 0)
        result = 31 * result + (imagePushedAt?.hashCode() ?: 0)
        result = 31 * result + (imageScanFindingsSummary?.hashCode() ?: 0)
        result = 31 * result + (imageScanStatus?.hashCode() ?: 0)
        result = 31 * result + (imageSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (imageTags?.hashCode() ?: 0)
        result = 31 * result + (lastRecordedPullTime?.hashCode() ?: 0)
        result = 31 * result + (registryId?.hashCode() ?: 0)
        result = 31 * result + (repositoryName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImageDetail

        if (artifactMediaType != other.artifactMediaType) return false
        if (imageDigest != other.imageDigest) return false
        if (imageManifestMediaType != other.imageManifestMediaType) return false
        if (imagePushedAt != other.imagePushedAt) return false
        if (imageScanFindingsSummary != other.imageScanFindingsSummary) return false
        if (imageScanStatus != other.imageScanStatus) return false
        if (imageSizeInBytes != other.imageSizeInBytes) return false
        if (imageTags != other.imageTags) return false
        if (lastRecordedPullTime != other.lastRecordedPullTime) return false
        if (registryId != other.registryId) return false
        if (repositoryName != other.repositoryName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecr.model.ImageDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The artifact media type of the image.
         */
        public var artifactMediaType: kotlin.String? = null
        /**
         * The `sha256` digest of the image manifest.
         */
        public var imageDigest: kotlin.String? = null
        /**
         * The media type of the image manifest.
         */
        public var imageManifestMediaType: kotlin.String? = null
        /**
         * The date and time, expressed in standard JavaScript date format, at which the current image was pushed to the repository.
         */
        public var imagePushedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A summary of the last completed image scan.
         */
        public var imageScanFindingsSummary: aws.sdk.kotlin.services.ecr.model.ImageScanFindingsSummary? = null
        /**
         * The current state of the scan.
         */
        public var imageScanStatus: aws.sdk.kotlin.services.ecr.model.ImageScanStatus? = null
        /**
         * The size, in bytes, of the image in the repository.
         *
         * If the image is a manifest list, this will be the max size of all manifests in the list.
         *
         * Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker registry. The output of the `docker images` command shows the uncompressed image size, so it may return a larger image size than the image sizes returned by DescribeImages.
         */
        public var imageSizeInBytes: kotlin.Long? = null
        /**
         * The list of tags associated with this image.
         */
        public var imageTags: List<String>? = null
        /**
         * The date and time, expressed in standard JavaScript date format, when Amazon ECR recorded the last image pull.
         *
         * Amazon ECR refreshes the last image pull timestamp at least once every 24 hours. For example, if you pull an image once a day then the `lastRecordedPullTime` timestamp will indicate the exact time that the image was last pulled. However, if you pull an image once an hour, because Amazon ECR refreshes the `lastRecordedPullTime` timestamp at least once every 24 hours, the result may not be the exact time that the image was last pulled.
         */
        public var lastRecordedPullTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Web Services account ID associated with the registry to which this image belongs.
         */
        public var registryId: kotlin.String? = null
        /**
         * The name of the repository to which this image belongs.
         */
        public var repositoryName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecr.model.ImageDetail) : this() {
            this.artifactMediaType = x.artifactMediaType
            this.imageDigest = x.imageDigest
            this.imageManifestMediaType = x.imageManifestMediaType
            this.imagePushedAt = x.imagePushedAt
            this.imageScanFindingsSummary = x.imageScanFindingsSummary
            this.imageScanStatus = x.imageScanStatus
            this.imageSizeInBytes = x.imageSizeInBytes
            this.imageTags = x.imageTags
            this.lastRecordedPullTime = x.lastRecordedPullTime
            this.registryId = x.registryId
            this.repositoryName = x.repositoryName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecr.model.ImageDetail = ImageDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecr.model.ImageScanFindingsSummary] inside the given [block]
         */
        public fun imageScanFindingsSummary(block: aws.sdk.kotlin.services.ecr.model.ImageScanFindingsSummary.Builder.() -> kotlin.Unit) {
            this.imageScanFindingsSummary = aws.sdk.kotlin.services.ecr.model.ImageScanFindingsSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecr.model.ImageScanStatus] inside the given [block]
         */
        public fun imageScanStatus(block: aws.sdk.kotlin.services.ecr.model.ImageScanStatus.Builder.() -> kotlin.Unit) {
            this.imageScanStatus = aws.sdk.kotlin.services.ecr.model.ImageScanStatus.invoke(block)
        }
    }
}
