// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.model



public class DescribeImagesRequest private constructor(builder: Builder) {
    /**
     * The filter key and value with which to filter your `DescribeImages` results.
     */
    public val filter: aws.sdk.kotlin.services.ecr.model.DescribeImagesFilter? = builder.filter
    /**
     * The list of image IDs for the requested repository.
     */
    public val imageIds: List<ImageIdentifier>? = builder.imageIds
    /**
     * The maximum number of repository results returned by `DescribeImages` in paginated output. When this parameter is used, `DescribeImages` only returns `maxResults` results in a single page along with a `nextToken` response element. The remaining results of the initial request can be seen by sending another `DescribeImages` request with the returned `nextToken` value. This value can be between 1 and 1000. If this parameter is not used, then `DescribeImages` returns up to 100 results and a `nextToken` value, if applicable. This option cannot be used when you specify images with `imageIds`.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The `nextToken` value returned from a previous paginated `DescribeImages` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value. This value is `null` when there are no more results to return. This option cannot be used when you specify images with `imageIds`.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The Amazon Web Services account ID associated with the registry that contains the repository in which to describe images. If you do not specify a registry, the default registry is assumed.
     */
    public val registryId: kotlin.String? = builder.registryId
    /**
     * The repository that contains the images to describe.
     */
    public val repositoryName: kotlin.String? = builder.repositoryName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecr.model.DescribeImagesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeImagesRequest(")
        append("filter=$filter,")
        append("imageIds=$imageIds,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("registryId=$registryId,")
        append("repositoryName=$repositoryName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filter?.hashCode() ?: 0
        result = 31 * result + (imageIds?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (registryId?.hashCode() ?: 0)
        result = 31 * result + (repositoryName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeImagesRequest

        if (filter != other.filter) return false
        if (imageIds != other.imageIds) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (registryId != other.registryId) return false
        if (repositoryName != other.repositoryName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecr.model.DescribeImagesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The filter key and value with which to filter your `DescribeImages` results.
         */
        public var filter: aws.sdk.kotlin.services.ecr.model.DescribeImagesFilter? = null
        /**
         * The list of image IDs for the requested repository.
         */
        public var imageIds: List<ImageIdentifier>? = null
        /**
         * The maximum number of repository results returned by `DescribeImages` in paginated output. When this parameter is used, `DescribeImages` only returns `maxResults` results in a single page along with a `nextToken` response element. The remaining results of the initial request can be seen by sending another `DescribeImages` request with the returned `nextToken` value. This value can be between 1 and 1000. If this parameter is not used, then `DescribeImages` returns up to 100 results and a `nextToken` value, if applicable. This option cannot be used when you specify images with `imageIds`.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The `nextToken` value returned from a previous paginated `DescribeImages` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value. This value is `null` when there are no more results to return. This option cannot be used when you specify images with `imageIds`.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The Amazon Web Services account ID associated with the registry that contains the repository in which to describe images. If you do not specify a registry, the default registry is assumed.
         */
        public var registryId: kotlin.String? = null
        /**
         * The repository that contains the images to describe.
         */
        public var repositoryName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecr.model.DescribeImagesRequest) : this() {
            this.filter = x.filter
            this.imageIds = x.imageIds
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.registryId = x.registryId
            this.repositoryName = x.repositoryName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecr.model.DescribeImagesRequest = DescribeImagesRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecr.model.DescribeImagesFilter] inside the given [block]
         */
        public fun filter(block: aws.sdk.kotlin.services.ecr.model.DescribeImagesFilter.Builder.() -> kotlin.Unit) {
            this.filter = aws.sdk.kotlin.services.ecr.model.DescribeImagesFilter.invoke(block)
        }
    }
}
