// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.model



public class CreateRepositoryRequest private constructor(builder: Builder) {
    /**
     * The encryption configuration for the repository. This determines how the contents of your repository are encrypted at rest.
     */
    public val encryptionConfiguration: aws.sdk.kotlin.services.ecr.model.EncryptionConfiguration? = builder.encryptionConfiguration
    /**
     * The image scanning configuration for the repository. This determines whether images are scanned for known vulnerabilities after being pushed to the repository.
     */
    public val imageScanningConfiguration: aws.sdk.kotlin.services.ecr.model.ImageScanningConfiguration? = builder.imageScanningConfiguration
    /**
     * The tag mutability setting for the repository. If this parameter is omitted, the default setting of `MUTABLE` will be used which will allow image tags to be overwritten. If `IMMUTABLE` is specified, all image tags within the repository will be immutable which will prevent them from being overwritten.
     */
    public val imageTagMutability: aws.sdk.kotlin.services.ecr.model.ImageTagMutability? = builder.imageTagMutability
    /**
     * The Amazon Web Services account ID associated with the registry to create the repository. If you do not specify a registry, the default registry is assumed.
     */
    public val registryId: kotlin.String? = builder.registryId
    /**
     * The name to use for the repository. The repository name may be specified on its own (such as `nginx-web-app`) or it can be prepended with a namespace to group the repository into a category (such as `project-a/nginx-web-app`).
     */
    public val repositoryName: kotlin.String? = builder.repositoryName
    /**
     * The metadata that you apply to the repository to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecr.model.CreateRepositoryRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRepositoryRequest(")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("imageScanningConfiguration=$imageScanningConfiguration,")
        append("imageTagMutability=$imageTagMutability,")
        append("registryId=$registryId,")
        append("repositoryName=$repositoryName,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = encryptionConfiguration?.hashCode() ?: 0
        result = 31 * result + (imageScanningConfiguration?.hashCode() ?: 0)
        result = 31 * result + (imageTagMutability?.hashCode() ?: 0)
        result = 31 * result + (registryId?.hashCode() ?: 0)
        result = 31 * result + (repositoryName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRepositoryRequest

        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (imageScanningConfiguration != other.imageScanningConfiguration) return false
        if (imageTagMutability != other.imageTagMutability) return false
        if (registryId != other.registryId) return false
        if (repositoryName != other.repositoryName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecr.model.CreateRepositoryRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The encryption configuration for the repository. This determines how the contents of your repository are encrypted at rest.
         */
        public var encryptionConfiguration: aws.sdk.kotlin.services.ecr.model.EncryptionConfiguration? = null
        /**
         * The image scanning configuration for the repository. This determines whether images are scanned for known vulnerabilities after being pushed to the repository.
         */
        public var imageScanningConfiguration: aws.sdk.kotlin.services.ecr.model.ImageScanningConfiguration? = null
        /**
         * The tag mutability setting for the repository. If this parameter is omitted, the default setting of `MUTABLE` will be used which will allow image tags to be overwritten. If `IMMUTABLE` is specified, all image tags within the repository will be immutable which will prevent them from being overwritten.
         */
        public var imageTagMutability: aws.sdk.kotlin.services.ecr.model.ImageTagMutability? = null
        /**
         * The Amazon Web Services account ID associated with the registry to create the repository. If you do not specify a registry, the default registry is assumed.
         */
        public var registryId: kotlin.String? = null
        /**
         * The name to use for the repository. The repository name may be specified on its own (such as `nginx-web-app`) or it can be prepended with a namespace to group the repository into a category (such as `project-a/nginx-web-app`).
         */
        public var repositoryName: kotlin.String? = null
        /**
         * The metadata that you apply to the repository to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecr.model.CreateRepositoryRequest) : this() {
            this.encryptionConfiguration = x.encryptionConfiguration
            this.imageScanningConfiguration = x.imageScanningConfiguration
            this.imageTagMutability = x.imageTagMutability
            this.registryId = x.registryId
            this.repositoryName = x.repositoryName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecr.model.CreateRepositoryRequest = CreateRepositoryRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecr.model.EncryptionConfiguration] inside the given [block]
         */
        public fun encryptionConfiguration(block: aws.sdk.kotlin.services.ecr.model.EncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.ecr.model.EncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecr.model.ImageScanningConfiguration] inside the given [block]
         */
        public fun imageScanningConfiguration(block: aws.sdk.kotlin.services.ecr.model.ImageScanningConfiguration.Builder.() -> kotlin.Unit) {
            this.imageScanningConfiguration = aws.sdk.kotlin.services.ecr.model.ImageScanningConfiguration.invoke(block)
        }
    }
}
