// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.ecr.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.ecr.model.*
import aws.sdk.kotlin.services.ecr.model.BatchCheckLayerAvailabilityRequest
import aws.sdk.kotlin.services.ecr.model.BatchCheckLayerAvailabilityResponse
import aws.sdk.kotlin.services.ecr.model.BatchDeleteImageRequest
import aws.sdk.kotlin.services.ecr.model.BatchDeleteImageResponse
import aws.sdk.kotlin.services.ecr.model.BatchGetImageRequest
import aws.sdk.kotlin.services.ecr.model.BatchGetImageResponse
import aws.sdk.kotlin.services.ecr.model.BatchGetRepositoryScanningConfigurationRequest
import aws.sdk.kotlin.services.ecr.model.BatchGetRepositoryScanningConfigurationResponse
import aws.sdk.kotlin.services.ecr.model.CompleteLayerUploadRequest
import aws.sdk.kotlin.services.ecr.model.CompleteLayerUploadResponse
import aws.sdk.kotlin.services.ecr.model.CreatePullThroughCacheRuleRequest
import aws.sdk.kotlin.services.ecr.model.CreatePullThroughCacheRuleResponse
import aws.sdk.kotlin.services.ecr.model.CreateRepositoryRequest
import aws.sdk.kotlin.services.ecr.model.CreateRepositoryResponse
import aws.sdk.kotlin.services.ecr.model.DeleteLifecyclePolicyRequest
import aws.sdk.kotlin.services.ecr.model.DeleteLifecyclePolicyResponse
import aws.sdk.kotlin.services.ecr.model.DeletePullThroughCacheRuleRequest
import aws.sdk.kotlin.services.ecr.model.DeletePullThroughCacheRuleResponse
import aws.sdk.kotlin.services.ecr.model.DeleteRegistryPolicyRequest
import aws.sdk.kotlin.services.ecr.model.DeleteRegistryPolicyResponse
import aws.sdk.kotlin.services.ecr.model.DeleteRepositoryPolicyRequest
import aws.sdk.kotlin.services.ecr.model.DeleteRepositoryPolicyResponse
import aws.sdk.kotlin.services.ecr.model.DeleteRepositoryRequest
import aws.sdk.kotlin.services.ecr.model.DeleteRepositoryResponse
import aws.sdk.kotlin.services.ecr.model.DescribeImageReplicationStatusRequest
import aws.sdk.kotlin.services.ecr.model.DescribeImageReplicationStatusResponse
import aws.sdk.kotlin.services.ecr.model.DescribeImageScanFindingsRequest
import aws.sdk.kotlin.services.ecr.model.DescribeImageScanFindingsResponse
import aws.sdk.kotlin.services.ecr.model.DescribeImagesRequest
import aws.sdk.kotlin.services.ecr.model.DescribeImagesResponse
import aws.sdk.kotlin.services.ecr.model.DescribePullThroughCacheRulesRequest
import aws.sdk.kotlin.services.ecr.model.DescribePullThroughCacheRulesResponse
import aws.sdk.kotlin.services.ecr.model.DescribeRegistryRequest
import aws.sdk.kotlin.services.ecr.model.DescribeRegistryResponse
import aws.sdk.kotlin.services.ecr.model.DescribeRepositoriesRequest
import aws.sdk.kotlin.services.ecr.model.DescribeRepositoriesResponse
import aws.sdk.kotlin.services.ecr.model.GetAuthorizationTokenRequest
import aws.sdk.kotlin.services.ecr.model.GetAuthorizationTokenResponse
import aws.sdk.kotlin.services.ecr.model.GetDownloadUrlForLayerRequest
import aws.sdk.kotlin.services.ecr.model.GetDownloadUrlForLayerResponse
import aws.sdk.kotlin.services.ecr.model.GetLifecyclePolicyPreviewRequest
import aws.sdk.kotlin.services.ecr.model.GetLifecyclePolicyPreviewResponse
import aws.sdk.kotlin.services.ecr.model.GetLifecyclePolicyRequest
import aws.sdk.kotlin.services.ecr.model.GetLifecyclePolicyResponse
import aws.sdk.kotlin.services.ecr.model.GetRegistryPolicyRequest
import aws.sdk.kotlin.services.ecr.model.GetRegistryPolicyResponse
import aws.sdk.kotlin.services.ecr.model.GetRegistryScanningConfigurationRequest
import aws.sdk.kotlin.services.ecr.model.GetRegistryScanningConfigurationResponse
import aws.sdk.kotlin.services.ecr.model.GetRepositoryPolicyRequest
import aws.sdk.kotlin.services.ecr.model.GetRepositoryPolicyResponse
import aws.sdk.kotlin.services.ecr.model.InitiateLayerUploadRequest
import aws.sdk.kotlin.services.ecr.model.InitiateLayerUploadResponse
import aws.sdk.kotlin.services.ecr.model.ListImagesRequest
import aws.sdk.kotlin.services.ecr.model.ListImagesResponse
import aws.sdk.kotlin.services.ecr.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.ecr.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.ecr.model.PutImageRequest
import aws.sdk.kotlin.services.ecr.model.PutImageResponse
import aws.sdk.kotlin.services.ecr.model.PutImageScanningConfigurationRequest
import aws.sdk.kotlin.services.ecr.model.PutImageScanningConfigurationResponse
import aws.sdk.kotlin.services.ecr.model.PutImageTagMutabilityRequest
import aws.sdk.kotlin.services.ecr.model.PutImageTagMutabilityResponse
import aws.sdk.kotlin.services.ecr.model.PutLifecyclePolicyRequest
import aws.sdk.kotlin.services.ecr.model.PutLifecyclePolicyResponse
import aws.sdk.kotlin.services.ecr.model.PutRegistryPolicyRequest
import aws.sdk.kotlin.services.ecr.model.PutRegistryPolicyResponse
import aws.sdk.kotlin.services.ecr.model.PutRegistryScanningConfigurationRequest
import aws.sdk.kotlin.services.ecr.model.PutRegistryScanningConfigurationResponse
import aws.sdk.kotlin.services.ecr.model.PutReplicationConfigurationRequest
import aws.sdk.kotlin.services.ecr.model.PutReplicationConfigurationResponse
import aws.sdk.kotlin.services.ecr.model.SetRepositoryPolicyRequest
import aws.sdk.kotlin.services.ecr.model.SetRepositoryPolicyResponse
import aws.sdk.kotlin.services.ecr.model.StartImageScanRequest
import aws.sdk.kotlin.services.ecr.model.StartImageScanResponse
import aws.sdk.kotlin.services.ecr.model.StartLifecyclePolicyPreviewRequest
import aws.sdk.kotlin.services.ecr.model.StartLifecyclePolicyPreviewResponse
import aws.sdk.kotlin.services.ecr.model.TagResourceRequest
import aws.sdk.kotlin.services.ecr.model.TagResourceResponse
import aws.sdk.kotlin.services.ecr.model.UntagResourceRequest
import aws.sdk.kotlin.services.ecr.model.UntagResourceResponse
import aws.sdk.kotlin.services.ecr.model.UploadLayerPartRequest
import aws.sdk.kotlin.services.ecr.model.UploadLayerPartResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # Amazon Elastic Container Registry
 * Amazon Elastic Container Registry (Amazon ECR) is a managed container image registry service. Customers can use the familiar Docker CLI, or their preferred client, to push, pull, and manage images. Amazon ECR provides a secure, scalable, and reliable registry for your Docker or Open Container Initiative (OCI) images. Amazon ECR supports private repositories with resource-based permissions using IAM so that specific users or Amazon EC2 instances can access repositories and images.
 *
 * Amazon ECR has service endpoints in each supported Region. For more information, see [Amazon ECR endpoints](https://docs.aws.amazon.com/general/latest/gr/ecr.html) in the *Amazon Web Services General Reference*.
 */
public interface EcrClient : SdkClient {

    override val serviceName: String
        get() = "ECR"
    /**
     * EcrClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): EcrClient {
            val config = Config.Builder().apply(block).build()
            return DefaultEcrClient(config)
        }

        public operator fun invoke(config: Config): EcrClient = DefaultEcrClient(config)

        /**
         * Construct a [EcrClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): EcrClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultEcrClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Checks the availability of one or more image layers in a repository.
     *
     * When an image is pushed to a repository, each image layer is checked to verify if it has been uploaded before. If it has been uploaded, then the image layer is skipped.
     *
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the `docker` CLI to pull, tag, and push images.
     */
    public suspend fun batchCheckLayerAvailability(input: BatchCheckLayerAvailabilityRequest): BatchCheckLayerAvailabilityResponse

    /**
     * Deletes a list of specified images within a repository. Images are specified with either an `imageTag` or `imageDigest`.
     *
     * You can remove a tag from an image by specifying the image's tag in your request. When you remove the last tag from an image, the image is deleted from your repository.
     *
     * You can completely delete an image (and all of its tags) by specifying the image's digest in your request.
     */
    public suspend fun batchDeleteImage(input: BatchDeleteImageRequest): BatchDeleteImageResponse

    /**
     * Gets detailed information for an image. Images are specified with either an `imageTag` or `imageDigest`.
     *
     * When an image is pulled, the BatchGetImage API is called once to retrieve the image manifest.
     */
    public suspend fun batchGetImage(input: BatchGetImageRequest): BatchGetImageResponse

    /**
     * Gets the scanning configuration for one or more repositories.
     */
    public suspend fun batchGetRepositoryScanningConfiguration(input: BatchGetRepositoryScanningConfigurationRequest): BatchGetRepositoryScanningConfigurationResponse

    /**
     * Informs Amazon ECR that the image layer upload has completed for a specified registry, repository name, and upload ID. You can optionally provide a `sha256` digest of the image layer for data validation purposes.
     *
     * When an image is pushed, the CompleteLayerUpload API is called once per each new image layer to verify that the upload has completed.
     *
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the `docker` CLI to pull, tag, and push images.
     */
    public suspend fun completeLayerUpload(input: CompleteLayerUploadRequest): CompleteLayerUploadResponse

    /**
     * Creates a pull through cache rule. A pull through cache rule provides a way to cache images from an external public registry in your Amazon ECR private registry.
     */
    public suspend fun createPullThroughCacheRule(input: CreatePullThroughCacheRuleRequest): CreatePullThroughCacheRuleResponse

    /**
     * Creates a repository. For more information, see [Amazon ECR repositories](https://docs.aws.amazon.com/AmazonECR/latest/userguide/Repositories.html) in the *Amazon Elastic Container Registry User Guide*.
     */
    public suspend fun createRepository(input: CreateRepositoryRequest): CreateRepositoryResponse

    /**
     * Deletes the lifecycle policy associated with the specified repository.
     */
    public suspend fun deleteLifecyclePolicy(input: DeleteLifecyclePolicyRequest): DeleteLifecyclePolicyResponse

    /**
     * Deletes a pull through cache rule.
     */
    public suspend fun deletePullThroughCacheRule(input: DeletePullThroughCacheRuleRequest): DeletePullThroughCacheRuleResponse

    /**
     * Deletes the registry permissions policy.
     */
    public suspend fun deleteRegistryPolicy(input: DeleteRegistryPolicyRequest = DeleteRegistryPolicyRequest {}): DeleteRegistryPolicyResponse

    /**
     * Deletes a repository. If the repository contains images, you must either delete all images in the repository or use the `force` option to delete the repository.
     */
    public suspend fun deleteRepository(input: DeleteRepositoryRequest): DeleteRepositoryResponse

    /**
     * Deletes the repository policy associated with the specified repository.
     */
    public suspend fun deleteRepositoryPolicy(input: DeleteRepositoryPolicyRequest): DeleteRepositoryPolicyResponse

    /**
     * Returns the replication status for a specified image.
     */
    public suspend fun describeImageReplicationStatus(input: DescribeImageReplicationStatusRequest): DescribeImageReplicationStatusResponse

    /**
     * Returns the scan findings for the specified image.
     */
    public suspend fun describeImageScanFindings(input: DescribeImageScanFindingsRequest): DescribeImageScanFindingsResponse

    /**
     * Returns metadata about the images in a repository.
     *
     * Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker registry. The output of the `docker images` command shows the uncompressed image size, so it may return a larger image size than the image sizes returned by DescribeImages.
     */
    public suspend fun describeImages(input: DescribeImagesRequest): DescribeImagesResponse

    /**
     * Returns the pull through cache rules for a registry.
     */
    public suspend fun describePullThroughCacheRules(input: DescribePullThroughCacheRulesRequest = DescribePullThroughCacheRulesRequest {}): DescribePullThroughCacheRulesResponse

    /**
     * Describes the settings for a registry. The replication configuration for a repository can be created or updated with the PutReplicationConfiguration API action.
     */
    public suspend fun describeRegistry(input: DescribeRegistryRequest = DescribeRegistryRequest {}): DescribeRegistryResponse

    /**
     * Describes image repositories in a registry.
     */
    public suspend fun describeRepositories(input: DescribeRepositoriesRequest = DescribeRepositoriesRequest {}): DescribeRepositoriesResponse

    /**
     * Retrieves an authorization token. An authorization token represents your IAM authentication credentials and can be used to access any Amazon ECR registry that your IAM principal has access to. The authorization token is valid for 12 hours.
     *
     * The `authorizationToken` returned is a base64 encoded string that can be decoded and used in a `docker login` command to authenticate to a registry. The CLI offers an `get-login-password` command that simplifies the login process. For more information, see [Registry authentication](https://docs.aws.amazon.com/AmazonECR/latest/userguide/Registries.html#registry_auth) in the *Amazon Elastic Container Registry User Guide*.
     */
    public suspend fun getAuthorizationToken(input: GetAuthorizationTokenRequest = GetAuthorizationTokenRequest {}): GetAuthorizationTokenResponse

    /**
     * Retrieves the pre-signed Amazon S3 download URL corresponding to an image layer. You can only get URLs for image layers that are referenced in an image.
     *
     * When an image is pulled, the GetDownloadUrlForLayer API is called once per image layer that is not already cached.
     *
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the `docker` CLI to pull, tag, and push images.
     */
    public suspend fun getDownloadUrlForLayer(input: GetDownloadUrlForLayerRequest): GetDownloadUrlForLayerResponse

    /**
     * Retrieves the lifecycle policy for the specified repository.
     */
    public suspend fun getLifecyclePolicy(input: GetLifecyclePolicyRequest): GetLifecyclePolicyResponse

    /**
     * Retrieves the results of the lifecycle policy preview request for the specified repository.
     */
    public suspend fun getLifecyclePolicyPreview(input: GetLifecyclePolicyPreviewRequest): GetLifecyclePolicyPreviewResponse

    /**
     * Retrieves the permissions policy for a registry.
     */
    public suspend fun getRegistryPolicy(input: GetRegistryPolicyRequest = GetRegistryPolicyRequest {}): GetRegistryPolicyResponse

    /**
     * Retrieves the scanning configuration for a registry.
     */
    public suspend fun getRegistryScanningConfiguration(input: GetRegistryScanningConfigurationRequest = GetRegistryScanningConfigurationRequest {}): GetRegistryScanningConfigurationResponse

    /**
     * Retrieves the repository policy for the specified repository.
     */
    public suspend fun getRepositoryPolicy(input: GetRepositoryPolicyRequest): GetRepositoryPolicyResponse

    /**
     * Notifies Amazon ECR that you intend to upload an image layer.
     *
     * When an image is pushed, the InitiateLayerUpload API is called once per image layer that has not already been uploaded. Whether or not an image layer has been uploaded is determined by the BatchCheckLayerAvailability API action.
     *
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the `docker` CLI to pull, tag, and push images.
     */
    public suspend fun initiateLayerUpload(input: InitiateLayerUploadRequest): InitiateLayerUploadResponse

    /**
     * Lists all the image IDs for the specified repository.
     *
     * You can filter images based on whether or not they are tagged by using the `tagStatus` filter and specifying either `TAGGED`, `UNTAGGED` or `ANY`. For example, you can filter your results to return only `UNTAGGED` images and then pipe that result to a BatchDeleteImage operation to delete them. Or, you can filter your results to return only `TAGGED` images to list all of the tags in your repository.
     */
    public suspend fun listImages(input: ListImagesRequest): ListImagesResponse

    /**
     * List the tags for an Amazon ECR resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Creates or updates the image manifest and tags associated with an image.
     *
     * When an image is pushed and all new image layers have been uploaded, the PutImage API is called once to create or update the image manifest and the tags associated with the image.
     *
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the `docker` CLI to pull, tag, and push images.
     */
    public suspend fun putImage(input: PutImageRequest): PutImageResponse

    /**
     * The `PutImageScanningConfiguration` API is being deprecated, in favor of specifying the image scanning configuration at the registry level. For more information, see PutRegistryScanningConfiguration.
     *
     * Updates the image scanning configuration for the specified repository.
     */
    public suspend fun putImageScanningConfiguration(input: PutImageScanningConfigurationRequest): PutImageScanningConfigurationResponse

    /**
     * Updates the image tag mutability settings for the specified repository. For more information, see [Image tag mutability](https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-tag-mutability.html) in the *Amazon Elastic Container Registry User Guide*.
     */
    public suspend fun putImageTagMutability(input: PutImageTagMutabilityRequest): PutImageTagMutabilityResponse

    /**
     * Creates or updates the lifecycle policy for the specified repository. For more information, see [Lifecycle policy template](https://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html).
     */
    public suspend fun putLifecyclePolicy(input: PutLifecyclePolicyRequest): PutLifecyclePolicyResponse

    /**
     * Creates or updates the permissions policy for your registry.
     *
     * A registry policy is used to specify permissions for another Amazon Web Services account and is used when configuring cross-account replication. For more information, see [Registry permissions](https://docs.aws.amazon.com/AmazonECR/latest/userguide/registry-permissions.html) in the *Amazon Elastic Container Registry User Guide*.
     */
    public suspend fun putRegistryPolicy(input: PutRegistryPolicyRequest): PutRegistryPolicyResponse

    /**
     * Creates or updates the scanning configuration for your private registry.
     */
    public suspend fun putRegistryScanningConfiguration(input: PutRegistryScanningConfigurationRequest = PutRegistryScanningConfigurationRequest {}): PutRegistryScanningConfigurationResponse

    /**
     * Creates or updates the replication configuration for a registry. The existing replication configuration for a repository can be retrieved with the DescribeRegistry API action. The first time the PutReplicationConfiguration API is called, a service-linked IAM role is created in your account for the replication process. For more information, see [Using service-linked roles for Amazon ECR](https://docs.aws.amazon.com/AmazonECR/latest/userguide/using-service-linked-roles.html) in the *Amazon Elastic Container Registry User Guide*.
     *
     * When configuring cross-account replication, the destination account must grant the source account permission to replicate. This permission is controlled using a registry permissions policy. For more information, see PutRegistryPolicy.
     */
    public suspend fun putReplicationConfiguration(input: PutReplicationConfigurationRequest): PutReplicationConfigurationResponse

    /**
     * Applies a repository policy to the specified repository to control access permissions. For more information, see [Amazon ECR Repository policies](https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policies.html) in the *Amazon Elastic Container Registry User Guide*.
     */
    public suspend fun setRepositoryPolicy(input: SetRepositoryPolicyRequest): SetRepositoryPolicyResponse

    /**
     * Starts an image vulnerability scan. An image scan can only be started once per 24 hours on an individual image. This limit includes if an image was scanned on initial push. For more information, see [Image scanning](https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-scanning.html) in the *Amazon Elastic Container Registry User Guide*.
     */
    public suspend fun startImageScan(input: StartImageScanRequest): StartImageScanResponse

    /**
     * Starts a preview of a lifecycle policy for the specified repository. This allows you to see the results before associating the lifecycle policy with the repository.
     */
    public suspend fun startLifecyclePolicyPreview(input: StartLifecyclePolicyPreviewRequest): StartLifecyclePolicyPreviewResponse

    /**
     * Adds specified tags to a resource with the specified ARN. Existing tags on a resource are not changed if they are not specified in the request parameters.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Deletes specified tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Uploads an image layer part to Amazon ECR.
     *
     * When an image is pushed, each new image layer is uploaded in parts. The maximum size of each image layer part can be 20971520 bytes (or about 20MB). The UploadLayerPart API is called once per each new image layer part.
     *
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the `docker` CLI to pull, tag, and push images.
     */
    public suspend fun uploadLayerPart(input: UploadLayerPartRequest): UploadLayerPartResponse
}

/**
 * Checks the availability of one or more image layers in a repository.
 *
 * When an image is pushed to a repository, each image layer is checked to verify if it has been uploaded before. If it has been uploaded, then the image layer is skipped.
 *
 * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the `docker` CLI to pull, tag, and push images.
 */
public suspend inline fun EcrClient.batchCheckLayerAvailability(crossinline block: BatchCheckLayerAvailabilityRequest.Builder.() -> Unit): BatchCheckLayerAvailabilityResponse = batchCheckLayerAvailability(BatchCheckLayerAvailabilityRequest.Builder().apply(block).build())

/**
 * Deletes a list of specified images within a repository. Images are specified with either an `imageTag` or `imageDigest`.
 *
 * You can remove a tag from an image by specifying the image's tag in your request. When you remove the last tag from an image, the image is deleted from your repository.
 *
 * You can completely delete an image (and all of its tags) by specifying the image's digest in your request.
 */
public suspend inline fun EcrClient.batchDeleteImage(crossinline block: BatchDeleteImageRequest.Builder.() -> Unit): BatchDeleteImageResponse = batchDeleteImage(BatchDeleteImageRequest.Builder().apply(block).build())

/**
 * Gets detailed information for an image. Images are specified with either an `imageTag` or `imageDigest`.
 *
 * When an image is pulled, the BatchGetImage API is called once to retrieve the image manifest.
 */
public suspend inline fun EcrClient.batchGetImage(crossinline block: BatchGetImageRequest.Builder.() -> Unit): BatchGetImageResponse = batchGetImage(BatchGetImageRequest.Builder().apply(block).build())

/**
 * Gets the scanning configuration for one or more repositories.
 */
public suspend inline fun EcrClient.batchGetRepositoryScanningConfiguration(crossinline block: BatchGetRepositoryScanningConfigurationRequest.Builder.() -> Unit): BatchGetRepositoryScanningConfigurationResponse = batchGetRepositoryScanningConfiguration(BatchGetRepositoryScanningConfigurationRequest.Builder().apply(block).build())

/**
 * Informs Amazon ECR that the image layer upload has completed for a specified registry, repository name, and upload ID. You can optionally provide a `sha256` digest of the image layer for data validation purposes.
 *
 * When an image is pushed, the CompleteLayerUpload API is called once per each new image layer to verify that the upload has completed.
 *
 * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the `docker` CLI to pull, tag, and push images.
 */
public suspend inline fun EcrClient.completeLayerUpload(crossinline block: CompleteLayerUploadRequest.Builder.() -> Unit): CompleteLayerUploadResponse = completeLayerUpload(CompleteLayerUploadRequest.Builder().apply(block).build())

/**
 * Creates a pull through cache rule. A pull through cache rule provides a way to cache images from an external public registry in your Amazon ECR private registry.
 */
public suspend inline fun EcrClient.createPullThroughCacheRule(crossinline block: CreatePullThroughCacheRuleRequest.Builder.() -> Unit): CreatePullThroughCacheRuleResponse = createPullThroughCacheRule(CreatePullThroughCacheRuleRequest.Builder().apply(block).build())

/**
 * Creates a repository. For more information, see [Amazon ECR repositories](https://docs.aws.amazon.com/AmazonECR/latest/userguide/Repositories.html) in the *Amazon Elastic Container Registry User Guide*.
 */
public suspend inline fun EcrClient.createRepository(crossinline block: CreateRepositoryRequest.Builder.() -> Unit): CreateRepositoryResponse = createRepository(CreateRepositoryRequest.Builder().apply(block).build())

/**
 * Deletes the lifecycle policy associated with the specified repository.
 */
public suspend inline fun EcrClient.deleteLifecyclePolicy(crossinline block: DeleteLifecyclePolicyRequest.Builder.() -> Unit): DeleteLifecyclePolicyResponse = deleteLifecyclePolicy(DeleteLifecyclePolicyRequest.Builder().apply(block).build())

/**
 * Deletes a pull through cache rule.
 */
public suspend inline fun EcrClient.deletePullThroughCacheRule(crossinline block: DeletePullThroughCacheRuleRequest.Builder.() -> Unit): DeletePullThroughCacheRuleResponse = deletePullThroughCacheRule(DeletePullThroughCacheRuleRequest.Builder().apply(block).build())

/**
 * Deletes the registry permissions policy.
 */
public suspend inline fun EcrClient.deleteRegistryPolicy(crossinline block: DeleteRegistryPolicyRequest.Builder.() -> Unit): DeleteRegistryPolicyResponse = deleteRegistryPolicy(DeleteRegistryPolicyRequest.Builder().apply(block).build())

/**
 * Deletes a repository. If the repository contains images, you must either delete all images in the repository or use the `force` option to delete the repository.
 */
public suspend inline fun EcrClient.deleteRepository(crossinline block: DeleteRepositoryRequest.Builder.() -> Unit): DeleteRepositoryResponse = deleteRepository(DeleteRepositoryRequest.Builder().apply(block).build())

/**
 * Deletes the repository policy associated with the specified repository.
 */
public suspend inline fun EcrClient.deleteRepositoryPolicy(crossinline block: DeleteRepositoryPolicyRequest.Builder.() -> Unit): DeleteRepositoryPolicyResponse = deleteRepositoryPolicy(DeleteRepositoryPolicyRequest.Builder().apply(block).build())

/**
 * Returns the replication status for a specified image.
 */
public suspend inline fun EcrClient.describeImageReplicationStatus(crossinline block: DescribeImageReplicationStatusRequest.Builder.() -> Unit): DescribeImageReplicationStatusResponse = describeImageReplicationStatus(DescribeImageReplicationStatusRequest.Builder().apply(block).build())

/**
 * Returns the scan findings for the specified image.
 */
public suspend inline fun EcrClient.describeImageScanFindings(crossinline block: DescribeImageScanFindingsRequest.Builder.() -> Unit): DescribeImageScanFindingsResponse = describeImageScanFindings(DescribeImageScanFindingsRequest.Builder().apply(block).build())

/**
 * Returns metadata about the images in a repository.
 *
 * Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker registry. The output of the `docker images` command shows the uncompressed image size, so it may return a larger image size than the image sizes returned by DescribeImages.
 */
public suspend inline fun EcrClient.describeImages(crossinline block: DescribeImagesRequest.Builder.() -> Unit): DescribeImagesResponse = describeImages(DescribeImagesRequest.Builder().apply(block).build())

/**
 * Returns the pull through cache rules for a registry.
 */
public suspend inline fun EcrClient.describePullThroughCacheRules(crossinline block: DescribePullThroughCacheRulesRequest.Builder.() -> Unit): DescribePullThroughCacheRulesResponse = describePullThroughCacheRules(DescribePullThroughCacheRulesRequest.Builder().apply(block).build())

/**
 * Describes the settings for a registry. The replication configuration for a repository can be created or updated with the PutReplicationConfiguration API action.
 */
public suspend inline fun EcrClient.describeRegistry(crossinline block: DescribeRegistryRequest.Builder.() -> Unit): DescribeRegistryResponse = describeRegistry(DescribeRegistryRequest.Builder().apply(block).build())

/**
 * Describes image repositories in a registry.
 */
public suspend inline fun EcrClient.describeRepositories(crossinline block: DescribeRepositoriesRequest.Builder.() -> Unit): DescribeRepositoriesResponse = describeRepositories(DescribeRepositoriesRequest.Builder().apply(block).build())

/**
 * Retrieves an authorization token. An authorization token represents your IAM authentication credentials and can be used to access any Amazon ECR registry that your IAM principal has access to. The authorization token is valid for 12 hours.
 *
 * The `authorizationToken` returned is a base64 encoded string that can be decoded and used in a `docker login` command to authenticate to a registry. The CLI offers an `get-login-password` command that simplifies the login process. For more information, see [Registry authentication](https://docs.aws.amazon.com/AmazonECR/latest/userguide/Registries.html#registry_auth) in the *Amazon Elastic Container Registry User Guide*.
 */
public suspend inline fun EcrClient.getAuthorizationToken(crossinline block: GetAuthorizationTokenRequest.Builder.() -> Unit): GetAuthorizationTokenResponse = getAuthorizationToken(GetAuthorizationTokenRequest.Builder().apply(block).build())

/**
 * Retrieves the pre-signed Amazon S3 download URL corresponding to an image layer. You can only get URLs for image layers that are referenced in an image.
 *
 * When an image is pulled, the GetDownloadUrlForLayer API is called once per image layer that is not already cached.
 *
 * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the `docker` CLI to pull, tag, and push images.
 */
public suspend inline fun EcrClient.getDownloadUrlForLayer(crossinline block: GetDownloadUrlForLayerRequest.Builder.() -> Unit): GetDownloadUrlForLayerResponse = getDownloadUrlForLayer(GetDownloadUrlForLayerRequest.Builder().apply(block).build())

/**
 * Retrieves the lifecycle policy for the specified repository.
 */
public suspend inline fun EcrClient.getLifecyclePolicy(crossinline block: GetLifecyclePolicyRequest.Builder.() -> Unit): GetLifecyclePolicyResponse = getLifecyclePolicy(GetLifecyclePolicyRequest.Builder().apply(block).build())

/**
 * Retrieves the results of the lifecycle policy preview request for the specified repository.
 */
public suspend inline fun EcrClient.getLifecyclePolicyPreview(crossinline block: GetLifecyclePolicyPreviewRequest.Builder.() -> Unit): GetLifecyclePolicyPreviewResponse = getLifecyclePolicyPreview(GetLifecyclePolicyPreviewRequest.Builder().apply(block).build())

/**
 * Retrieves the permissions policy for a registry.
 */
public suspend inline fun EcrClient.getRegistryPolicy(crossinline block: GetRegistryPolicyRequest.Builder.() -> Unit): GetRegistryPolicyResponse = getRegistryPolicy(GetRegistryPolicyRequest.Builder().apply(block).build())

/**
 * Retrieves the scanning configuration for a registry.
 */
public suspend inline fun EcrClient.getRegistryScanningConfiguration(crossinline block: GetRegistryScanningConfigurationRequest.Builder.() -> Unit): GetRegistryScanningConfigurationResponse = getRegistryScanningConfiguration(GetRegistryScanningConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves the repository policy for the specified repository.
 */
public suspend inline fun EcrClient.getRepositoryPolicy(crossinline block: GetRepositoryPolicyRequest.Builder.() -> Unit): GetRepositoryPolicyResponse = getRepositoryPolicy(GetRepositoryPolicyRequest.Builder().apply(block).build())

/**
 * Notifies Amazon ECR that you intend to upload an image layer.
 *
 * When an image is pushed, the InitiateLayerUpload API is called once per image layer that has not already been uploaded. Whether or not an image layer has been uploaded is determined by the BatchCheckLayerAvailability API action.
 *
 * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the `docker` CLI to pull, tag, and push images.
 */
public suspend inline fun EcrClient.initiateLayerUpload(crossinline block: InitiateLayerUploadRequest.Builder.() -> Unit): InitiateLayerUploadResponse = initiateLayerUpload(InitiateLayerUploadRequest.Builder().apply(block).build())

/**
 * Lists all the image IDs for the specified repository.
 *
 * You can filter images based on whether or not they are tagged by using the `tagStatus` filter and specifying either `TAGGED`, `UNTAGGED` or `ANY`. For example, you can filter your results to return only `UNTAGGED` images and then pipe that result to a BatchDeleteImage operation to delete them. Or, you can filter your results to return only `TAGGED` images to list all of the tags in your repository.
 */
public suspend inline fun EcrClient.listImages(crossinline block: ListImagesRequest.Builder.() -> Unit): ListImagesResponse = listImages(ListImagesRequest.Builder().apply(block).build())

/**
 * List the tags for an Amazon ECR resource.
 */
public suspend inline fun EcrClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Creates or updates the image manifest and tags associated with an image.
 *
 * When an image is pushed and all new image layers have been uploaded, the PutImage API is called once to create or update the image manifest and the tags associated with the image.
 *
 * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the `docker` CLI to pull, tag, and push images.
 */
public suspend inline fun EcrClient.putImage(crossinline block: PutImageRequest.Builder.() -> Unit): PutImageResponse = putImage(PutImageRequest.Builder().apply(block).build())

/**
 * The `PutImageScanningConfiguration` API is being deprecated, in favor of specifying the image scanning configuration at the registry level. For more information, see PutRegistryScanningConfiguration.
 *
 * Updates the image scanning configuration for the specified repository.
 */
public suspend inline fun EcrClient.putImageScanningConfiguration(crossinline block: PutImageScanningConfigurationRequest.Builder.() -> Unit): PutImageScanningConfigurationResponse = putImageScanningConfiguration(PutImageScanningConfigurationRequest.Builder().apply(block).build())

/**
 * Updates the image tag mutability settings for the specified repository. For more information, see [Image tag mutability](https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-tag-mutability.html) in the *Amazon Elastic Container Registry User Guide*.
 */
public suspend inline fun EcrClient.putImageTagMutability(crossinline block: PutImageTagMutabilityRequest.Builder.() -> Unit): PutImageTagMutabilityResponse = putImageTagMutability(PutImageTagMutabilityRequest.Builder().apply(block).build())

/**
 * Creates or updates the lifecycle policy for the specified repository. For more information, see [Lifecycle policy template](https://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html).
 */
public suspend inline fun EcrClient.putLifecyclePolicy(crossinline block: PutLifecyclePolicyRequest.Builder.() -> Unit): PutLifecyclePolicyResponse = putLifecyclePolicy(PutLifecyclePolicyRequest.Builder().apply(block).build())

/**
 * Creates or updates the permissions policy for your registry.
 *
 * A registry policy is used to specify permissions for another Amazon Web Services account and is used when configuring cross-account replication. For more information, see [Registry permissions](https://docs.aws.amazon.com/AmazonECR/latest/userguide/registry-permissions.html) in the *Amazon Elastic Container Registry User Guide*.
 */
public suspend inline fun EcrClient.putRegistryPolicy(crossinline block: PutRegistryPolicyRequest.Builder.() -> Unit): PutRegistryPolicyResponse = putRegistryPolicy(PutRegistryPolicyRequest.Builder().apply(block).build())

/**
 * Creates or updates the scanning configuration for your private registry.
 */
public suspend inline fun EcrClient.putRegistryScanningConfiguration(crossinline block: PutRegistryScanningConfigurationRequest.Builder.() -> Unit): PutRegistryScanningConfigurationResponse = putRegistryScanningConfiguration(PutRegistryScanningConfigurationRequest.Builder().apply(block).build())

/**
 * Creates or updates the replication configuration for a registry. The existing replication configuration for a repository can be retrieved with the DescribeRegistry API action. The first time the PutReplicationConfiguration API is called, a service-linked IAM role is created in your account for the replication process. For more information, see [Using service-linked roles for Amazon ECR](https://docs.aws.amazon.com/AmazonECR/latest/userguide/using-service-linked-roles.html) in the *Amazon Elastic Container Registry User Guide*.
 *
 * When configuring cross-account replication, the destination account must grant the source account permission to replicate. This permission is controlled using a registry permissions policy. For more information, see PutRegistryPolicy.
 */
public suspend inline fun EcrClient.putReplicationConfiguration(crossinline block: PutReplicationConfigurationRequest.Builder.() -> Unit): PutReplicationConfigurationResponse = putReplicationConfiguration(PutReplicationConfigurationRequest.Builder().apply(block).build())

/**
 * Applies a repository policy to the specified repository to control access permissions. For more information, see [Amazon ECR Repository policies](https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policies.html) in the *Amazon Elastic Container Registry User Guide*.
 */
public suspend inline fun EcrClient.setRepositoryPolicy(crossinline block: SetRepositoryPolicyRequest.Builder.() -> Unit): SetRepositoryPolicyResponse = setRepositoryPolicy(SetRepositoryPolicyRequest.Builder().apply(block).build())

/**
 * Starts an image vulnerability scan. An image scan can only be started once per 24 hours on an individual image. This limit includes if an image was scanned on initial push. For more information, see [Image scanning](https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-scanning.html) in the *Amazon Elastic Container Registry User Guide*.
 */
public suspend inline fun EcrClient.startImageScan(crossinline block: StartImageScanRequest.Builder.() -> Unit): StartImageScanResponse = startImageScan(StartImageScanRequest.Builder().apply(block).build())

/**
 * Starts a preview of a lifecycle policy for the specified repository. This allows you to see the results before associating the lifecycle policy with the repository.
 */
public suspend inline fun EcrClient.startLifecyclePolicyPreview(crossinline block: StartLifecyclePolicyPreviewRequest.Builder.() -> Unit): StartLifecyclePolicyPreviewResponse = startLifecyclePolicyPreview(StartLifecyclePolicyPreviewRequest.Builder().apply(block).build())

/**
 * Adds specified tags to a resource with the specified ARN. Existing tags on a resource are not changed if they are not specified in the request parameters.
 */
public suspend inline fun EcrClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Deletes specified tags from a resource.
 */
public suspend inline fun EcrClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Uploads an image layer part to Amazon ECR.
 *
 * When an image is pushed, each new image layer is uploaded in parts. The maximum size of each image layer part can be 20971520 bytes (or about 20MB). The UploadLayerPart API is called once per each new image layer part.
 *
 * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the `docker` CLI to pull, tag, and push images.
 */
public suspend inline fun EcrClient.uploadLayerPart(crossinline block: UploadLayerPartRequest.Builder.() -> Unit): UploadLayerPartResponse = uploadLayerPart(UploadLayerPartRequest.Builder().apply(block).build())
