// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.paginators

import aws.sdk.kotlin.services.ecr.EcrClient
import aws.sdk.kotlin.services.ecr.model.DescribeImageScanFindingsRequest
import aws.sdk.kotlin.services.ecr.model.DescribeImageScanFindingsResponse
import aws.sdk.kotlin.services.ecr.model.DescribeImagesRequest
import aws.sdk.kotlin.services.ecr.model.DescribeImagesResponse
import aws.sdk.kotlin.services.ecr.model.DescribePullThroughCacheRulesRequest
import aws.sdk.kotlin.services.ecr.model.DescribePullThroughCacheRulesResponse
import aws.sdk.kotlin.services.ecr.model.DescribeRepositoriesRequest
import aws.sdk.kotlin.services.ecr.model.DescribeRepositoriesResponse
import aws.sdk.kotlin.services.ecr.model.GetLifecyclePolicyPreviewRequest
import aws.sdk.kotlin.services.ecr.model.GetLifecyclePolicyPreviewResponse
import aws.sdk.kotlin.services.ecr.model.ImageDetail
import aws.sdk.kotlin.services.ecr.model.ImageIdentifier
import aws.sdk.kotlin.services.ecr.model.LifecyclePolicyPreviewResult
import aws.sdk.kotlin.services.ecr.model.ListImagesRequest
import aws.sdk.kotlin.services.ecr.model.ListImagesResponse
import aws.sdk.kotlin.services.ecr.model.Repository
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeImagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeImagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeImagesResponse]
 */
public fun EcrClient.describeImagesPaginated(initialRequest: DescribeImagesRequest): Flow<DescribeImagesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeImagesPaginated.describeImages(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeImagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeImagesResponse]
 */
public fun EcrClient.describeImagesPaginated(block: DescribeImagesRequest.Builder.() -> Unit): Flow<DescribeImagesResponse> =
    describeImagesPaginated(DescribeImagesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeImagesPaginated]
 * to access the nested member [ImageDetail]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ImageDetail]
 */
@JvmName("describeImagesResponseImageDetail")
public fun Flow<DescribeImagesResponse>.imageDetails(): Flow<ImageDetail> =
    transform() { response ->
        response.imageDetails?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeImageScanFindingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeImageScanFindingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeImageScanFindingsResponse]
 */
public fun EcrClient.describeImageScanFindingsPaginated(initialRequest: DescribeImageScanFindingsRequest): Flow<DescribeImageScanFindingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeImageScanFindingsPaginated.describeImageScanFindings(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeImageScanFindingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeImageScanFindingsResponse]
 */
public fun EcrClient.describeImageScanFindingsPaginated(block: DescribeImageScanFindingsRequest.Builder.() -> Unit): Flow<DescribeImageScanFindingsResponse> =
    describeImageScanFindingsPaginated(DescribeImageScanFindingsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribePullThroughCacheRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribePullThroughCacheRulesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePullThroughCacheRulesResponse]
 */
public fun EcrClient.describePullThroughCacheRulesPaginated(initialRequest: DescribePullThroughCacheRulesRequest): Flow<DescribePullThroughCacheRulesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describePullThroughCacheRulesPaginated.describePullThroughCacheRules(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribePullThroughCacheRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePullThroughCacheRulesResponse]
 */
public fun EcrClient.describePullThroughCacheRulesPaginated(block: DescribePullThroughCacheRulesRequest.Builder.() -> Unit): Flow<DescribePullThroughCacheRulesResponse> =
    describePullThroughCacheRulesPaginated(DescribePullThroughCacheRulesRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeRepositoriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeRepositoriesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeRepositoriesResponse]
 */
public fun EcrClient.describeRepositoriesPaginated(initialRequest: DescribeRepositoriesRequest): Flow<DescribeRepositoriesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeRepositoriesPaginated.describeRepositories(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeRepositoriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeRepositoriesResponse]
 */
public fun EcrClient.describeRepositoriesPaginated(block: DescribeRepositoriesRequest.Builder.() -> Unit): Flow<DescribeRepositoriesResponse> =
    describeRepositoriesPaginated(DescribeRepositoriesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeRepositoriesPaginated]
 * to access the nested member [Repository]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Repository]
 */
@JvmName("describeRepositoriesResponseRepository")
public fun Flow<DescribeRepositoriesResponse>.repositories(): Flow<Repository> =
    transform() { response ->
        response.repositories?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetLifecyclePolicyPreviewResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetLifecyclePolicyPreviewRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetLifecyclePolicyPreviewResponse]
 */
public fun EcrClient.getLifecyclePolicyPreviewPaginated(initialRequest: GetLifecyclePolicyPreviewRequest): Flow<GetLifecyclePolicyPreviewResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getLifecyclePolicyPreviewPaginated.getLifecyclePolicyPreview(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetLifecyclePolicyPreviewResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetLifecyclePolicyPreviewResponse]
 */
public fun EcrClient.getLifecyclePolicyPreviewPaginated(block: GetLifecyclePolicyPreviewRequest.Builder.() -> Unit): Flow<GetLifecyclePolicyPreviewResponse> =
    getLifecyclePolicyPreviewPaginated(GetLifecyclePolicyPreviewRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getLifecyclePolicyPreviewPaginated]
 * to access the nested member [LifecyclePolicyPreviewResult]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LifecyclePolicyPreviewResult]
 */
@JvmName("getLifecyclePolicyPreviewResponseLifecyclePolicyPreviewResult")
public fun Flow<GetLifecyclePolicyPreviewResponse>.previewResults(): Flow<LifecyclePolicyPreviewResult> =
    transform() { response ->
        response.previewResults?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListImagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListImagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImagesResponse]
 */
public fun EcrClient.listImagesPaginated(initialRequest: ListImagesRequest): Flow<ListImagesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listImagesPaginated.listImages(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListImagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImagesResponse]
 */
public fun EcrClient.listImagesPaginated(block: ListImagesRequest.Builder.() -> Unit): Flow<ListImagesResponse> =
    listImagesPaginated(ListImagesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listImagesPaginated]
 * to access the nested member [ImageIdentifier]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ImageIdentifier]
 */
@JvmName("listImagesResponseImageIdentifier")
public fun Flow<ListImagesResponse>.imageIds(): Flow<ImageIdentifier> =
    transform() { response ->
        response.imageIds?.forEach {
            emit(it)
        }
    }
