// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.internal

import aws.sdk.kotlin.runtime.ClientException
import aws.sdk.kotlin.runtime.endpoint.AwsEndpoint
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.endpoint.CredentialScope
import aws.sdk.kotlin.runtime.endpoint.internal.EndpointDefinition
import aws.sdk.kotlin.runtime.endpoint.internal.Partition
import aws.sdk.kotlin.runtime.endpoint.internal.resolveEndpoint

internal class DefaultEndpointResolver : AwsEndpointResolver {
    override suspend fun resolve(service: String, region: String): AwsEndpoint {
        return resolveEndpoint(servicePartitions, region) ?: throw ClientException("unable to resolve endpoint for region: $region")
    }
}

private val servicePartitions = listOf(
    Partition(
        id = "aws",
        regionRegex = Regex("^(us|eu|ap|sa|ca|me|af)\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "api.ecr.{region}.amazonaws.com",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
            "af-south-1" to EndpointDefinition(
                hostname = "api.ecr.af-south-1.amazonaws.com",
                credentialScope = CredentialScope(region = "af-south-1",),
            ),
            "ap-east-1" to EndpointDefinition(
                hostname = "api.ecr.ap-east-1.amazonaws.com",
                credentialScope = CredentialScope(region = "ap-east-1",),
            ),
            "ap-northeast-1" to EndpointDefinition(
                hostname = "api.ecr.ap-northeast-1.amazonaws.com",
                credentialScope = CredentialScope(region = "ap-northeast-1",),
            ),
            "ap-northeast-2" to EndpointDefinition(
                hostname = "api.ecr.ap-northeast-2.amazonaws.com",
                credentialScope = CredentialScope(region = "ap-northeast-2",),
            ),
            "ap-northeast-3" to EndpointDefinition(
                hostname = "api.ecr.ap-northeast-3.amazonaws.com",
                credentialScope = CredentialScope(region = "ap-northeast-3",),
            ),
            "ap-south-1" to EndpointDefinition(
                hostname = "api.ecr.ap-south-1.amazonaws.com",
                credentialScope = CredentialScope(region = "ap-south-1",),
            ),
            "ap-southeast-1" to EndpointDefinition(
                hostname = "api.ecr.ap-southeast-1.amazonaws.com",
                credentialScope = CredentialScope(region = "ap-southeast-1",),
            ),
            "ap-southeast-2" to EndpointDefinition(
                hostname = "api.ecr.ap-southeast-2.amazonaws.com",
                credentialScope = CredentialScope(region = "ap-southeast-2",),
            ),
            "ca-central-1" to EndpointDefinition(
                hostname = "api.ecr.ca-central-1.amazonaws.com",
                credentialScope = CredentialScope(region = "ca-central-1",),
            ),
            "eu-central-1" to EndpointDefinition(
                hostname = "api.ecr.eu-central-1.amazonaws.com",
                credentialScope = CredentialScope(region = "eu-central-1",),
            ),
            "eu-north-1" to EndpointDefinition(
                hostname = "api.ecr.eu-north-1.amazonaws.com",
                credentialScope = CredentialScope(region = "eu-north-1",),
            ),
            "eu-south-1" to EndpointDefinition(
                hostname = "api.ecr.eu-south-1.amazonaws.com",
                credentialScope = CredentialScope(region = "eu-south-1",),
            ),
            "eu-west-1" to EndpointDefinition(
                hostname = "api.ecr.eu-west-1.amazonaws.com",
                credentialScope = CredentialScope(region = "eu-west-1",),
            ),
            "eu-west-2" to EndpointDefinition(
                hostname = "api.ecr.eu-west-2.amazonaws.com",
                credentialScope = CredentialScope(region = "eu-west-2",),
            ),
            "eu-west-3" to EndpointDefinition(
                hostname = "api.ecr.eu-west-3.amazonaws.com",
                credentialScope = CredentialScope(region = "eu-west-3",),
            ),
            "fips-dkr-us-east-1" to EndpointDefinition(
                hostname = "ecr-fips.us-east-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-east-1",),
            ),
            "fips-dkr-us-east-2" to EndpointDefinition(
                hostname = "ecr-fips.us-east-2.amazonaws.com",
                credentialScope = CredentialScope(region = "us-east-2",),
            ),
            "fips-dkr-us-west-1" to EndpointDefinition(
                hostname = "ecr-fips.us-west-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-west-1",),
            ),
            "fips-dkr-us-west-2" to EndpointDefinition(
                hostname = "ecr-fips.us-west-2.amazonaws.com",
                credentialScope = CredentialScope(region = "us-west-2",),
            ),
            "fips-us-east-1" to EndpointDefinition(
                hostname = "ecr-fips.us-east-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-east-1",),
            ),
            "fips-us-east-2" to EndpointDefinition(
                hostname = "ecr-fips.us-east-2.amazonaws.com",
                credentialScope = CredentialScope(region = "us-east-2",),
            ),
            "fips-us-west-1" to EndpointDefinition(
                hostname = "ecr-fips.us-west-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-west-1",),
            ),
            "fips-us-west-2" to EndpointDefinition(
                hostname = "ecr-fips.us-west-2.amazonaws.com",
                credentialScope = CredentialScope(region = "us-west-2",),
            ),
            "me-south-1" to EndpointDefinition(
                hostname = "api.ecr.me-south-1.amazonaws.com",
                credentialScope = CredentialScope(region = "me-south-1",),
            ),
            "sa-east-1" to EndpointDefinition(
                hostname = "api.ecr.sa-east-1.amazonaws.com",
                credentialScope = CredentialScope(region = "sa-east-1",),
            ),
            "us-east-1" to EndpointDefinition(
                hostname = "api.ecr.us-east-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-east-1",),
            ),
            "us-east-2" to EndpointDefinition(
                hostname = "api.ecr.us-east-2.amazonaws.com",
                credentialScope = CredentialScope(region = "us-east-2",),
            ),
            "us-west-1" to EndpointDefinition(
                hostname = "api.ecr.us-west-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-west-1",),
            ),
            "us-west-2" to EndpointDefinition(
                hostname = "api.ecr.us-west-2.amazonaws.com",
                credentialScope = CredentialScope(region = "us-west-2",),
            ),
        )
    ),
    Partition(
        id = "aws-cn",
        regionRegex = Regex("^cn\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "api.ecr.{region}.amazonaws.com.cn",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
            "cn-north-1" to EndpointDefinition(
                hostname = "api.ecr.cn-north-1.amazonaws.com.cn",
                credentialScope = CredentialScope(region = "cn-north-1",),
            ),
            "cn-northwest-1" to EndpointDefinition(
                hostname = "api.ecr.cn-northwest-1.amazonaws.com.cn",
                credentialScope = CredentialScope(region = "cn-northwest-1",),
            ),
        )
    ),
    Partition(
        id = "aws-iso",
        regionRegex = Regex("^us\\-iso\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "api.ecr.{region}.c2s.ic.gov",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
            "us-iso-east-1" to EndpointDefinition(
                hostname = "api.ecr.us-iso-east-1.c2s.ic.gov",
                credentialScope = CredentialScope(region = "us-iso-east-1",),
            ),
        )
    ),
    Partition(
        id = "aws-iso-b",
        regionRegex = Regex("^us\\-isob\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "api.ecr.{region}.sc2s.sgov.gov",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
            "us-isob-east-1" to EndpointDefinition(
                hostname = "api.ecr.us-isob-east-1.sc2s.sgov.gov",
                credentialScope = CredentialScope(region = "us-isob-east-1",),
            ),
        )
    ),
    Partition(
        id = "aws-us-gov",
        regionRegex = Regex("^us\\-gov\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "api.ecr.{region}.amazonaws.com",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
            "fips-dkr-us-gov-east-1" to EndpointDefinition(
                hostname = "ecr-fips.us-gov-east-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-gov-east-1",),
            ),
            "fips-dkr-us-gov-west-1" to EndpointDefinition(
                hostname = "ecr-fips.us-gov-west-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-gov-west-1",),
            ),
            "fips-us-gov-east-1" to EndpointDefinition(
                hostname = "ecr-fips.us-gov-east-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-gov-east-1",),
            ),
            "fips-us-gov-west-1" to EndpointDefinition(
                hostname = "ecr-fips.us-gov-west-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-gov-west-1",),
            ),
            "us-gov-east-1" to EndpointDefinition(
                hostname = "api.ecr.us-gov-east-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-gov-east-1",),
            ),
            "us-gov-west-1" to EndpointDefinition(
                hostname = "api.ecr.us-gov-west-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-gov-west-1",),
            ),
        )
    ),
)
