// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.waiters

import aws.sdk.kotlin.services.ec2.Ec2Client
import aws.sdk.kotlin.services.ec2.model.DescribeBundleTasksRequest
import aws.sdk.kotlin.services.ec2.model.DescribeBundleTasksResponse
import aws.sdk.kotlin.services.ec2.model.DescribeConversionTasksRequest
import aws.sdk.kotlin.services.ec2.model.DescribeConversionTasksResponse
import aws.sdk.kotlin.services.ec2.model.DescribeCustomerGatewaysRequest
import aws.sdk.kotlin.services.ec2.model.DescribeCustomerGatewaysResponse
import aws.sdk.kotlin.services.ec2.model.DescribeExportTasksRequest
import aws.sdk.kotlin.services.ec2.model.DescribeExportTasksResponse
import aws.sdk.kotlin.services.ec2.model.DescribeImagesRequest
import aws.sdk.kotlin.services.ec2.model.DescribeImagesResponse
import aws.sdk.kotlin.services.ec2.model.DescribeInstanceStatusRequest
import aws.sdk.kotlin.services.ec2.model.DescribeInstanceStatusResponse
import aws.sdk.kotlin.services.ec2.model.DescribeInstancesRequest
import aws.sdk.kotlin.services.ec2.model.DescribeInstancesResponse
import aws.sdk.kotlin.services.ec2.model.DescribeInternetGatewaysRequest
import aws.sdk.kotlin.services.ec2.model.DescribeInternetGatewaysResponse
import aws.sdk.kotlin.services.ec2.model.DescribeKeyPairsRequest
import aws.sdk.kotlin.services.ec2.model.DescribeKeyPairsResponse
import aws.sdk.kotlin.services.ec2.model.DescribeNatGatewaysRequest
import aws.sdk.kotlin.services.ec2.model.DescribeNatGatewaysResponse
import aws.sdk.kotlin.services.ec2.model.DescribeNetworkInterfacesRequest
import aws.sdk.kotlin.services.ec2.model.DescribeNetworkInterfacesResponse
import aws.sdk.kotlin.services.ec2.model.DescribeSecurityGroupsRequest
import aws.sdk.kotlin.services.ec2.model.DescribeSecurityGroupsResponse
import aws.sdk.kotlin.services.ec2.model.DescribeSnapshotsRequest
import aws.sdk.kotlin.services.ec2.model.DescribeSnapshotsResponse
import aws.sdk.kotlin.services.ec2.model.DescribeSpotInstanceRequestsRequest
import aws.sdk.kotlin.services.ec2.model.DescribeSpotInstanceRequestsResponse
import aws.sdk.kotlin.services.ec2.model.DescribeSubnetsRequest
import aws.sdk.kotlin.services.ec2.model.DescribeSubnetsResponse
import aws.sdk.kotlin.services.ec2.model.DescribeVolumesRequest
import aws.sdk.kotlin.services.ec2.model.DescribeVolumesResponse
import aws.sdk.kotlin.services.ec2.model.DescribeVpcPeeringConnectionsRequest
import aws.sdk.kotlin.services.ec2.model.DescribeVpcPeeringConnectionsResponse
import aws.sdk.kotlin.services.ec2.model.DescribeVpcsRequest
import aws.sdk.kotlin.services.ec2.model.DescribeVpcsResponse
import aws.sdk.kotlin.services.ec2.model.DescribeVpnConnectionsRequest
import aws.sdk.kotlin.services.ec2.model.DescribeVpnConnectionsResponse
import aws.sdk.kotlin.services.ec2.model.GetPasswordDataRequest
import aws.sdk.kotlin.services.ec2.model.GetPasswordDataResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType
import aws.smithy.kotlin.runtime.retries.policy.SuccessAcceptor
import aws.smithy.kotlin.runtime.util.flattenIfPossible
import aws.smithy.kotlin.runtime.util.length
import kotlin.time.Duration.Companion.milliseconds


public suspend fun Ec2Client.waitUntilBundleTaskComplete(request: DescribeBundleTasksRequest): Outcome<DescribeBundleTasksResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeBundleTasksRequest, DescribeBundleTasksResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val bundleTasks = it?.bundleTasks
            val bundleTasksOrEmpty = bundleTasks?.flattenIfPossible() ?: listOf()
            val projection = bundleTasksOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "complete" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val bundleTasks = it?.bundleTasks
            val bundleTasksOrEmpty = bundleTasks?.flattenIfPossible() ?: listOf()
            val projection = bundleTasksOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection?.any { it?.toString() == "failed" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeBundleTasks(request) }
}

public suspend fun Ec2Client.waitUntilBundleTaskComplete(block: DescribeBundleTasksRequest.Builder.() -> Unit): Outcome<DescribeBundleTasksResponse> =
    waitUntilBundleTaskComplete(DescribeBundleTasksRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilConversionTaskCancelled(request: DescribeConversionTasksRequest): Outcome<DescribeConversionTasksResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeConversionTasksRequest, DescribeConversionTasksResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val conversionTasks = it?.conversionTasks
            val conversionTasksOrEmpty = conversionTasks?.flattenIfPossible() ?: listOf()
            val projection = conversionTasksOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "cancelled" }
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeConversionTasks(request) }
}

public suspend fun Ec2Client.waitUntilConversionTaskCancelled(block: DescribeConversionTasksRequest.Builder.() -> Unit): Outcome<DescribeConversionTasksResponse> =
    waitUntilConversionTaskCancelled(DescribeConversionTasksRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilConversionTaskCompleted(request: DescribeConversionTasksRequest): Outcome<DescribeConversionTasksResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeConversionTasksRequest, DescribeConversionTasksResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val conversionTasks = it?.conversionTasks
            val conversionTasksOrEmpty = conversionTasks?.flattenIfPossible() ?: listOf()
            val projection = conversionTasksOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "completed" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val conversionTasks = it?.conversionTasks
            val conversionTasksOrEmpty = conversionTasks?.flattenIfPossible() ?: listOf()
            val projection = conversionTasksOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection?.any { it?.toString() == "cancelled" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val conversionTasks = it?.conversionTasks
            val conversionTasksOrEmpty = conversionTasks?.flattenIfPossible() ?: listOf()
            val projection = conversionTasksOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection?.any { it?.toString() == "cancelling" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeConversionTasks(request) }
}

public suspend fun Ec2Client.waitUntilConversionTaskCompleted(block: DescribeConversionTasksRequest.Builder.() -> Unit): Outcome<DescribeConversionTasksResponse> =
    waitUntilConversionTaskCompleted(DescribeConversionTasksRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilConversionTaskDeleted(request: DescribeConversionTasksRequest): Outcome<DescribeConversionTasksResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeConversionTasksRequest, DescribeConversionTasksResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val conversionTasks = it?.conversionTasks
            val conversionTasksOrEmpty = conversionTasks?.flattenIfPossible() ?: listOf()
            val projection = conversionTasksOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "deleted" }
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeConversionTasks(request) }
}

public suspend fun Ec2Client.waitUntilConversionTaskDeleted(block: DescribeConversionTasksRequest.Builder.() -> Unit): Outcome<DescribeConversionTasksResponse> =
    waitUntilConversionTaskDeleted(DescribeConversionTasksRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilCustomerGatewayAvailable(request: DescribeCustomerGatewaysRequest): Outcome<DescribeCustomerGatewaysResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeCustomerGatewaysRequest, DescribeCustomerGatewaysResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val customerGateways = it?.customerGateways
            val customerGatewaysOrEmpty = customerGateways?.flattenIfPossible() ?: listOf()
            val projection = customerGatewaysOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "available" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val customerGateways = it?.customerGateways
            val customerGatewaysOrEmpty = customerGateways?.flattenIfPossible() ?: listOf()
            val projection = customerGatewaysOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection?.any { it?.toString() == "deleted" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val customerGateways = it?.customerGateways
            val customerGatewaysOrEmpty = customerGateways?.flattenIfPossible() ?: listOf()
            val projection = customerGatewaysOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection?.any { it?.toString() == "deleting" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeCustomerGateways(request) }
}

public suspend fun Ec2Client.waitUntilCustomerGatewayAvailable(block: DescribeCustomerGatewaysRequest.Builder.() -> Unit): Outcome<DescribeCustomerGatewaysResponse> =
    waitUntilCustomerGatewayAvailable(DescribeCustomerGatewaysRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilExportTaskCancelled(request: DescribeExportTasksRequest): Outcome<DescribeExportTasksResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeExportTasksRequest, DescribeExportTasksResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val exportTasks = it?.exportTasks
            val exportTasksOrEmpty = exportTasks?.flattenIfPossible() ?: listOf()
            val projection = exportTasksOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "cancelled" }
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeExportTasks(request) }
}

public suspend fun Ec2Client.waitUntilExportTaskCancelled(block: DescribeExportTasksRequest.Builder.() -> Unit): Outcome<DescribeExportTasksResponse> =
    waitUntilExportTaskCancelled(DescribeExportTasksRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilExportTaskCompleted(request: DescribeExportTasksRequest): Outcome<DescribeExportTasksResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeExportTasksRequest, DescribeExportTasksResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val exportTasks = it?.exportTasks
            val exportTasksOrEmpty = exportTasks?.flattenIfPossible() ?: listOf()
            val projection = exportTasksOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "completed" }
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeExportTasks(request) }
}

public suspend fun Ec2Client.waitUntilExportTaskCompleted(block: DescribeExportTasksRequest.Builder.() -> Unit): Outcome<DescribeExportTasksResponse> =
    waitUntilExportTaskCompleted(DescribeExportTasksRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilImageAvailable(request: DescribeImagesRequest): Outcome<DescribeImagesResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeImagesRequest, DescribeImagesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val images = it?.images
            val imagesOrEmpty = images?.flattenIfPossible() ?: listOf()
            val projection = imagesOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "available" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val images = it?.images
            val imagesOrEmpty = images?.flattenIfPossible() ?: listOf()
            val projection = imagesOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection?.any { it?.toString() == "failed" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeImages(request) }
}

public suspend fun Ec2Client.waitUntilImageAvailable(block: DescribeImagesRequest.Builder.() -> Unit): Outcome<DescribeImagesResponse> =
    waitUntilImageAvailable(DescribeImagesRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilImageExists(request: DescribeImagesRequest): Outcome<DescribeImagesResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeImagesRequest, DescribeImagesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val images = it?.images
            val imagesOrEmpty = images?.flattenIfPossible() ?: listOf()
            val length = imagesOrEmpty?.length ?: 0
            val number = 0.0
            val comparison = if (length == null || number == null) null else length.compareTo(number) > 0
            comparison == true
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InvalidAMIID.NotFound"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeImages(request) }
}

public suspend fun Ec2Client.waitUntilImageExists(block: DescribeImagesRequest.Builder.() -> Unit): Outcome<DescribeImagesResponse> =
    waitUntilImageExists(DescribeImagesRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilInstanceExists(request: DescribeInstancesRequest): Outcome<DescribeInstancesResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 5_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeInstancesRequest, DescribeInstancesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val reservations = it?.reservations
            val reservationsOrEmpty = reservations?.flattenIfPossible() ?: listOf()
            val length = reservationsOrEmpty?.length ?: 0
            val number = 0.0
            val comparison = if (length == null || number == null) null else length.compareTo(number) > 0
            comparison == true
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InvalidInstanceID.NotFound"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeInstances(request) }
}

public suspend fun Ec2Client.waitUntilInstanceExists(block: DescribeInstancesRequest.Builder.() -> Unit): Outcome<DescribeInstancesResponse> =
    waitUntilInstanceExists(DescribeInstancesRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilInstanceRunning(request: DescribeInstancesRequest): Outcome<DescribeInstancesResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeInstancesRequest, DescribeInstancesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val reservations = it?.reservations
            val reservationsOrEmpty = reservations?.flattenIfPossible() ?: listOf()
            val projection = reservationsOrEmpty.flatMap {
                val instances = it?.instances
                listOfNotNull(instances)
            }
            val projectionOrEmpty = projection?.flattenIfPossible() ?: listOf()
            val projection2 = projectionOrEmpty.flatMap {
                val state = it?.state
                val name = state?.name
                listOfNotNull(name)
            }
            projection2 != null && projection2.size > 0 && projection2.all { it?.toString() == "running" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val reservations = it?.reservations
            val reservationsOrEmpty = reservations?.flattenIfPossible() ?: listOf()
            val projection = reservationsOrEmpty.flatMap {
                val instances = it?.instances
                listOfNotNull(instances)
            }
            val projectionOrEmpty = projection?.flattenIfPossible() ?: listOf()
            val projection2 = projectionOrEmpty.flatMap {
                val state = it?.state
                val name = state?.name
                listOfNotNull(name)
            }
            projection2?.any { it?.toString() == "shutting-down" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val reservations = it?.reservations
            val reservationsOrEmpty = reservations?.flattenIfPossible() ?: listOf()
            val projection = reservationsOrEmpty.flatMap {
                val instances = it?.instances
                listOfNotNull(instances)
            }
            val projectionOrEmpty = projection?.flattenIfPossible() ?: listOf()
            val projection2 = projectionOrEmpty.flatMap {
                val state = it?.state
                val name = state?.name
                listOfNotNull(name)
            }
            projection2?.any { it?.toString() == "terminated" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val reservations = it?.reservations
            val reservationsOrEmpty = reservations?.flattenIfPossible() ?: listOf()
            val projection = reservationsOrEmpty.flatMap {
                val instances = it?.instances
                listOfNotNull(instances)
            }
            val projectionOrEmpty = projection?.flattenIfPossible() ?: listOf()
            val projection2 = projectionOrEmpty.flatMap {
                val state = it?.state
                val name = state?.name
                listOfNotNull(name)
            }
            projection2?.any { it?.toString() == "stopping" } ?: false
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InvalidInstanceID.NotFound"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeInstances(request) }
}

public suspend fun Ec2Client.waitUntilInstanceRunning(block: DescribeInstancesRequest.Builder.() -> Unit): Outcome<DescribeInstancesResponse> =
    waitUntilInstanceRunning(DescribeInstancesRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilInstanceStopped(request: DescribeInstancesRequest): Outcome<DescribeInstancesResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeInstancesRequest, DescribeInstancesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val reservations = it?.reservations
            val reservationsOrEmpty = reservations?.flattenIfPossible() ?: listOf()
            val projection = reservationsOrEmpty.flatMap {
                val instances = it?.instances
                listOfNotNull(instances)
            }
            val projectionOrEmpty = projection?.flattenIfPossible() ?: listOf()
            val projection2 = projectionOrEmpty.flatMap {
                val state = it?.state
                val name = state?.name
                listOfNotNull(name)
            }
            projection2 != null && projection2.size > 0 && projection2.all { it?.toString() == "stopped" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val reservations = it?.reservations
            val reservationsOrEmpty = reservations?.flattenIfPossible() ?: listOf()
            val projection = reservationsOrEmpty.flatMap {
                val instances = it?.instances
                listOfNotNull(instances)
            }
            val projectionOrEmpty = projection?.flattenIfPossible() ?: listOf()
            val projection2 = projectionOrEmpty.flatMap {
                val state = it?.state
                val name = state?.name
                listOfNotNull(name)
            }
            projection2?.any { it?.toString() == "pending" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val reservations = it?.reservations
            val reservationsOrEmpty = reservations?.flattenIfPossible() ?: listOf()
            val projection = reservationsOrEmpty.flatMap {
                val instances = it?.instances
                listOfNotNull(instances)
            }
            val projectionOrEmpty = projection?.flattenIfPossible() ?: listOf()
            val projection2 = projectionOrEmpty.flatMap {
                val state = it?.state
                val name = state?.name
                listOfNotNull(name)
            }
            projection2?.any { it?.toString() == "terminated" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeInstances(request) }
}

public suspend fun Ec2Client.waitUntilInstanceStopped(block: DescribeInstancesRequest.Builder.() -> Unit): Outcome<DescribeInstancesResponse> =
    waitUntilInstanceStopped(DescribeInstancesRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilInstanceTerminated(request: DescribeInstancesRequest): Outcome<DescribeInstancesResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeInstancesRequest, DescribeInstancesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val reservations = it?.reservations
            val reservationsOrEmpty = reservations?.flattenIfPossible() ?: listOf()
            val projection = reservationsOrEmpty.flatMap {
                val instances = it?.instances
                listOfNotNull(instances)
            }
            val projectionOrEmpty = projection?.flattenIfPossible() ?: listOf()
            val projection2 = projectionOrEmpty.flatMap {
                val state = it?.state
                val name = state?.name
                listOfNotNull(name)
            }
            projection2 != null && projection2.size > 0 && projection2.all { it?.toString() == "terminated" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val reservations = it?.reservations
            val reservationsOrEmpty = reservations?.flattenIfPossible() ?: listOf()
            val projection = reservationsOrEmpty.flatMap {
                val instances = it?.instances
                listOfNotNull(instances)
            }
            val projectionOrEmpty = projection?.flattenIfPossible() ?: listOf()
            val projection2 = projectionOrEmpty.flatMap {
                val state = it?.state
                val name = state?.name
                listOfNotNull(name)
            }
            projection2?.any { it?.toString() == "pending" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val reservations = it?.reservations
            val reservationsOrEmpty = reservations?.flattenIfPossible() ?: listOf()
            val projection = reservationsOrEmpty.flatMap {
                val instances = it?.instances
                listOfNotNull(instances)
            }
            val projectionOrEmpty = projection?.flattenIfPossible() ?: listOf()
            val projection2 = projectionOrEmpty.flatMap {
                val state = it?.state
                val name = state?.name
                listOfNotNull(name)
            }
            projection2?.any { it?.toString() == "stopping" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeInstances(request) }
}

public suspend fun Ec2Client.waitUntilInstanceTerminated(block: DescribeInstancesRequest.Builder.() -> Unit): Outcome<DescribeInstancesResponse> =
    waitUntilInstanceTerminated(DescribeInstancesRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilInstanceStatusOk(request: DescribeInstanceStatusRequest): Outcome<DescribeInstanceStatusResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeInstanceStatusRequest, DescribeInstanceStatusResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val instanceStatuses = it?.instanceStatuses
            val instanceStatusesOrEmpty = instanceStatuses?.flattenIfPossible() ?: listOf()
            val projection = instanceStatusesOrEmpty.flatMap {
                val instanceStatus = it?.instanceStatus
                val status = instanceStatus?.status
                listOfNotNull(status)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "ok" }
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InvalidInstanceID.NotFound"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeInstanceStatus(request) }
}

public suspend fun Ec2Client.waitUntilInstanceStatusOk(block: DescribeInstanceStatusRequest.Builder.() -> Unit): Outcome<DescribeInstanceStatusResponse> =
    waitUntilInstanceStatusOk(DescribeInstanceStatusRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilSystemStatusOk(request: DescribeInstanceStatusRequest): Outcome<DescribeInstanceStatusResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeInstanceStatusRequest, DescribeInstanceStatusResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val instanceStatuses = it?.instanceStatuses
            val instanceStatusesOrEmpty = instanceStatuses?.flattenIfPossible() ?: listOf()
            val projection = instanceStatusesOrEmpty.flatMap {
                val systemStatus = it?.systemStatus
                val status = systemStatus?.status
                listOfNotNull(status)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "ok" }
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeInstanceStatus(request) }
}

public suspend fun Ec2Client.waitUntilSystemStatusOk(block: DescribeInstanceStatusRequest.Builder.() -> Unit): Outcome<DescribeInstanceStatusResponse> =
    waitUntilSystemStatusOk(DescribeInstanceStatusRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilInternetGatewayExists(request: DescribeInternetGatewaysRequest): Outcome<DescribeInternetGatewaysResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 5_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeInternetGatewaysRequest, DescribeInternetGatewaysResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val internetGateways = it?.internetGateways
            val internetGatewaysOrEmpty = internetGateways?.flattenIfPossible() ?: listOf()
            val projection = internetGatewaysOrEmpty.flatMap {
                val internetGatewayId = it?.internetGatewayId
                listOfNotNull(internetGatewayId)
            }
            val length = projection?.length ?: 0
            val number = 0.0
            val comparison = if (length == null || number == null) null else length.compareTo(number) > 0
            comparison == true
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InvalidInternetGateway.NotFound"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeInternetGateways(request) }
}

public suspend fun Ec2Client.waitUntilInternetGatewayExists(block: DescribeInternetGatewaysRequest.Builder.() -> Unit): Outcome<DescribeInternetGatewaysResponse> =
    waitUntilInternetGatewayExists(DescribeInternetGatewaysRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilKeyPairExists(request: DescribeKeyPairsRequest): Outcome<DescribeKeyPairsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 5_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeKeyPairsRequest, DescribeKeyPairsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val keyPairs = it?.keyPairs
            val keyPairsOrEmpty = keyPairs?.flattenIfPossible() ?: listOf()
            val projection = keyPairsOrEmpty.flatMap {
                val keyName = it?.keyName
                listOfNotNull(keyName)
            }
            val length = projection?.length ?: 0
            val number = 0.0
            val comparison = if (length == null || number == null) null else length.compareTo(number) > 0
            comparison == true
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InvalidKeyPair.NotFound"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeKeyPairs(request) }
}

public suspend fun Ec2Client.waitUntilKeyPairExists(block: DescribeKeyPairsRequest.Builder.() -> Unit): Outcome<DescribeKeyPairsResponse> =
    waitUntilKeyPairExists(DescribeKeyPairsRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilNatGatewayAvailable(request: DescribeNatGatewaysRequest): Outcome<DescribeNatGatewaysResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeNatGatewaysRequest, DescribeNatGatewaysResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val natGateways = it?.natGateways
            val natGatewaysOrEmpty = natGateways?.flattenIfPossible() ?: listOf()
            val projection = natGatewaysOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "available" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val natGateways = it?.natGateways
            val natGatewaysOrEmpty = natGateways?.flattenIfPossible() ?: listOf()
            val projection = natGatewaysOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection?.any { it?.toString() == "failed" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val natGateways = it?.natGateways
            val natGatewaysOrEmpty = natGateways?.flattenIfPossible() ?: listOf()
            val projection = natGatewaysOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection?.any { it?.toString() == "deleting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val natGateways = it?.natGateways
            val natGatewaysOrEmpty = natGateways?.flattenIfPossible() ?: listOf()
            val projection = natGatewaysOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection?.any { it?.toString() == "deleted" } ?: false
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "NatGatewayNotFound"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeNatGateways(request) }
}

public suspend fun Ec2Client.waitUntilNatGatewayAvailable(block: DescribeNatGatewaysRequest.Builder.() -> Unit): Outcome<DescribeNatGatewaysResponse> =
    waitUntilNatGatewayAvailable(DescribeNatGatewaysRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilNatGatewayDeleted(request: DescribeNatGatewaysRequest): Outcome<DescribeNatGatewaysResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeNatGatewaysRequest, DescribeNatGatewaysResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val natGateways = it?.natGateways
            val natGatewaysOrEmpty = natGateways?.flattenIfPossible() ?: listOf()
            val projection = natGatewaysOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "deleted" }
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "NatGatewayNotFound"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeNatGateways(request) }
}

public suspend fun Ec2Client.waitUntilNatGatewayDeleted(block: DescribeNatGatewaysRequest.Builder.() -> Unit): Outcome<DescribeNatGatewaysResponse> =
    waitUntilNatGatewayDeleted(DescribeNatGatewaysRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilNetworkInterfaceAvailable(request: DescribeNetworkInterfacesRequest): Outcome<DescribeNetworkInterfacesResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 20_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeNetworkInterfacesRequest, DescribeNetworkInterfacesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val networkInterfaces = it?.networkInterfaces
            val networkInterfacesOrEmpty = networkInterfaces?.flattenIfPossible() ?: listOf()
            val projection = networkInterfacesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "available" }
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "InvalidNetworkInterfaceID.NotFound"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeNetworkInterfaces(request) }
}

public suspend fun Ec2Client.waitUntilNetworkInterfaceAvailable(block: DescribeNetworkInterfacesRequest.Builder.() -> Unit): Outcome<DescribeNetworkInterfacesResponse> =
    waitUntilNetworkInterfaceAvailable(DescribeNetworkInterfacesRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilSecurityGroupExists(request: DescribeSecurityGroupsRequest): Outcome<DescribeSecurityGroupsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 5_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeSecurityGroupsRequest, DescribeSecurityGroupsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val securityGroups = it?.securityGroups
            val securityGroupsOrEmpty = securityGroups?.flattenIfPossible() ?: listOf()
            val projection = securityGroupsOrEmpty.flatMap {
                val groupId = it?.groupId
                listOfNotNull(groupId)
            }
            val length = projection?.length ?: 0
            val number = 0.0
            val comparison = if (length == null || number == null) null else length.compareTo(number) > 0
            comparison == true
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InvalidGroup.NotFound"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeSecurityGroups(request) }
}

public suspend fun Ec2Client.waitUntilSecurityGroupExists(block: DescribeSecurityGroupsRequest.Builder.() -> Unit): Outcome<DescribeSecurityGroupsResponse> =
    waitUntilSecurityGroupExists(DescribeSecurityGroupsRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilSnapshotCompleted(request: DescribeSnapshotsRequest): Outcome<DescribeSnapshotsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeSnapshotsRequest, DescribeSnapshotsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val snapshots = it?.snapshots
            val snapshotsOrEmpty = snapshots?.flattenIfPossible() ?: listOf()
            val projection = snapshotsOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "completed" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val snapshots = it?.snapshots
            val snapshotsOrEmpty = snapshots?.flattenIfPossible() ?: listOf()
            val projection = snapshotsOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection?.any { it?.toString() == "error" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeSnapshots(request) }
}

public suspend fun Ec2Client.waitUntilSnapshotCompleted(block: DescribeSnapshotsRequest.Builder.() -> Unit): Outcome<DescribeSnapshotsResponse> =
    waitUntilSnapshotCompleted(DescribeSnapshotsRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilSpotInstanceRequestFulfilled(request: DescribeSpotInstanceRequestsRequest): Outcome<DescribeSpotInstanceRequestsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeSpotInstanceRequestsRequest, DescribeSpotInstanceRequestsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val spotInstanceRequests = it?.spotInstanceRequests
            val spotInstanceRequestsOrEmpty = spotInstanceRequests?.flattenIfPossible() ?: listOf()
            val projection = spotInstanceRequestsOrEmpty.flatMap {
                val status = it?.status
                val code = status?.code
                listOfNotNull(code)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "fulfilled" }
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val spotInstanceRequests = it?.spotInstanceRequests
            val spotInstanceRequestsOrEmpty = spotInstanceRequests?.flattenIfPossible() ?: listOf()
            val projection = spotInstanceRequestsOrEmpty.flatMap {
                val status = it?.status
                val code = status?.code
                listOfNotNull(code)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "request-canceled-and-instance-running" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val spotInstanceRequests = it?.spotInstanceRequests
            val spotInstanceRequestsOrEmpty = spotInstanceRequests?.flattenIfPossible() ?: listOf()
            val projection = spotInstanceRequestsOrEmpty.flatMap {
                val status = it?.status
                val code = status?.code
                listOfNotNull(code)
            }
            projection?.any { it?.toString() == "schedule-expired" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val spotInstanceRequests = it?.spotInstanceRequests
            val spotInstanceRequestsOrEmpty = spotInstanceRequests?.flattenIfPossible() ?: listOf()
            val projection = spotInstanceRequestsOrEmpty.flatMap {
                val status = it?.status
                val code = status?.code
                listOfNotNull(code)
            }
            projection?.any { it?.toString() == "canceled-before-fulfillment" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val spotInstanceRequests = it?.spotInstanceRequests
            val spotInstanceRequestsOrEmpty = spotInstanceRequests?.flattenIfPossible() ?: listOf()
            val projection = spotInstanceRequestsOrEmpty.flatMap {
                val status = it?.status
                val code = status?.code
                listOfNotNull(code)
            }
            projection?.any { it?.toString() == "bad-parameters" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val spotInstanceRequests = it?.spotInstanceRequests
            val spotInstanceRequestsOrEmpty = spotInstanceRequests?.flattenIfPossible() ?: listOf()
            val projection = spotInstanceRequestsOrEmpty.flatMap {
                val status = it?.status
                val code = status?.code
                listOfNotNull(code)
            }
            projection?.any { it?.toString() == "system-error" } ?: false
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InvalidSpotInstanceRequestID.NotFound"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeSpotInstanceRequests(request) }
}

public suspend fun Ec2Client.waitUntilSpotInstanceRequestFulfilled(block: DescribeSpotInstanceRequestsRequest.Builder.() -> Unit): Outcome<DescribeSpotInstanceRequestsResponse> =
    waitUntilSpotInstanceRequestFulfilled(DescribeSpotInstanceRequestsRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilSubnetAvailable(request: DescribeSubnetsRequest): Outcome<DescribeSubnetsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeSubnetsRequest, DescribeSubnetsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val subnets = it?.subnets
            val subnetsOrEmpty = subnets?.flattenIfPossible() ?: listOf()
            val projection = subnetsOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "available" }
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeSubnets(request) }
}

public suspend fun Ec2Client.waitUntilSubnetAvailable(block: DescribeSubnetsRequest.Builder.() -> Unit): Outcome<DescribeSubnetsResponse> =
    waitUntilSubnetAvailable(DescribeSubnetsRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilVolumeAvailable(request: DescribeVolumesRequest): Outcome<DescribeVolumesResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeVolumesRequest, DescribeVolumesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val volumes = it?.volumes
            val volumesOrEmpty = volumes?.flattenIfPossible() ?: listOf()
            val projection = volumesOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "available" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val volumes = it?.volumes
            val volumesOrEmpty = volumes?.flattenIfPossible() ?: listOf()
            val projection = volumesOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection?.any { it?.toString() == "deleted" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeVolumes(request) }
}

public suspend fun Ec2Client.waitUntilVolumeAvailable(block: DescribeVolumesRequest.Builder.() -> Unit): Outcome<DescribeVolumesResponse> =
    waitUntilVolumeAvailable(DescribeVolumesRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilVolumeDeleted(request: DescribeVolumesRequest): Outcome<DescribeVolumesResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeVolumesRequest, DescribeVolumesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val volumes = it?.volumes
            val volumesOrEmpty = volumes?.flattenIfPossible() ?: listOf()
            val projection = volumesOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "deleted" }
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "InvalidVolume.NotFound"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeVolumes(request) }
}

public suspend fun Ec2Client.waitUntilVolumeDeleted(block: DescribeVolumesRequest.Builder.() -> Unit): Outcome<DescribeVolumesResponse> =
    waitUntilVolumeDeleted(DescribeVolumesRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilVolumeInUse(request: DescribeVolumesRequest): Outcome<DescribeVolumesResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeVolumesRequest, DescribeVolumesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val volumes = it?.volumes
            val volumesOrEmpty = volumes?.flattenIfPossible() ?: listOf()
            val projection = volumesOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "in-use" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val volumes = it?.volumes
            val volumesOrEmpty = volumes?.flattenIfPossible() ?: listOf()
            val projection = volumesOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection?.any { it?.toString() == "deleted" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeVolumes(request) }
}

public suspend fun Ec2Client.waitUntilVolumeInUse(block: DescribeVolumesRequest.Builder.() -> Unit): Outcome<DescribeVolumesResponse> =
    waitUntilVolumeInUse(DescribeVolumesRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilVpcPeeringConnectionDeleted(request: DescribeVpcPeeringConnectionsRequest): Outcome<DescribeVpcPeeringConnectionsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeVpcPeeringConnectionsRequest, DescribeVpcPeeringConnectionsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val vpcPeeringConnections = it?.vpcPeeringConnections
            val vpcPeeringConnectionsOrEmpty = vpcPeeringConnections?.flattenIfPossible() ?: listOf()
            val projection = vpcPeeringConnectionsOrEmpty.flatMap {
                val status = it?.status
                val code = status?.code
                listOfNotNull(code)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "deleted" }
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "InvalidVpcPeeringConnectionID.NotFound"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeVpcPeeringConnections(request) }
}

public suspend fun Ec2Client.waitUntilVpcPeeringConnectionDeleted(block: DescribeVpcPeeringConnectionsRequest.Builder.() -> Unit): Outcome<DescribeVpcPeeringConnectionsResponse> =
    waitUntilVpcPeeringConnectionDeleted(DescribeVpcPeeringConnectionsRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilVpcPeeringConnectionExists(request: DescribeVpcPeeringConnectionsRequest): Outcome<DescribeVpcPeeringConnectionsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeVpcPeeringConnectionsRequest, DescribeVpcPeeringConnectionsResponse>>(
        SuccessAcceptor(RetryDirective.TerminateAndSucceed, true),
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InvalidVpcPeeringConnectionID.NotFound"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeVpcPeeringConnections(request) }
}

public suspend fun Ec2Client.waitUntilVpcPeeringConnectionExists(block: DescribeVpcPeeringConnectionsRequest.Builder.() -> Unit): Outcome<DescribeVpcPeeringConnectionsResponse> =
    waitUntilVpcPeeringConnectionExists(DescribeVpcPeeringConnectionsRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilVpcAvailable(request: DescribeVpcsRequest): Outcome<DescribeVpcsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeVpcsRequest, DescribeVpcsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val vpcs = it?.vpcs
            val vpcsOrEmpty = vpcs?.flattenIfPossible() ?: listOf()
            val projection = vpcsOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "available" }
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeVpcs(request) }
}

public suspend fun Ec2Client.waitUntilVpcAvailable(block: DescribeVpcsRequest.Builder.() -> Unit): Outcome<DescribeVpcsResponse> =
    waitUntilVpcAvailable(DescribeVpcsRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilVpcExists(request: DescribeVpcsRequest): Outcome<DescribeVpcsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 1_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeVpcsRequest, DescribeVpcsResponse>>(
        SuccessAcceptor(RetryDirective.TerminateAndSucceed, true),
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InvalidVpcID.NotFound"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeVpcs(request) }
}

public suspend fun Ec2Client.waitUntilVpcExists(block: DescribeVpcsRequest.Builder.() -> Unit): Outcome<DescribeVpcsResponse> =
    waitUntilVpcExists(DescribeVpcsRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilVpnConnectionAvailable(request: DescribeVpnConnectionsRequest): Outcome<DescribeVpnConnectionsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeVpnConnectionsRequest, DescribeVpnConnectionsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val vpnConnections = it?.vpnConnections
            val vpnConnectionsOrEmpty = vpnConnections?.flattenIfPossible() ?: listOf()
            val projection = vpnConnectionsOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "available" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val vpnConnections = it?.vpnConnections
            val vpnConnectionsOrEmpty = vpnConnections?.flattenIfPossible() ?: listOf()
            val projection = vpnConnectionsOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection?.any { it?.toString() == "deleting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val vpnConnections = it?.vpnConnections
            val vpnConnectionsOrEmpty = vpnConnections?.flattenIfPossible() ?: listOf()
            val projection = vpnConnectionsOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection?.any { it?.toString() == "deleted" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeVpnConnections(request) }
}

public suspend fun Ec2Client.waitUntilVpnConnectionAvailable(block: DescribeVpnConnectionsRequest.Builder.() -> Unit): Outcome<DescribeVpnConnectionsResponse> =
    waitUntilVpnConnectionAvailable(DescribeVpnConnectionsRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilVpnConnectionDeleted(request: DescribeVpnConnectionsRequest): Outcome<DescribeVpnConnectionsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeVpnConnectionsRequest, DescribeVpnConnectionsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val vpnConnections = it?.vpnConnections
            val vpnConnectionsOrEmpty = vpnConnections?.flattenIfPossible() ?: listOf()
            val projection = vpnConnectionsOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "deleted" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val vpnConnections = it?.vpnConnections
            val vpnConnectionsOrEmpty = vpnConnections?.flattenIfPossible() ?: listOf()
            val projection = vpnConnectionsOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection?.any { it?.toString() == "pending" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeVpnConnections(request) }
}

public suspend fun Ec2Client.waitUntilVpnConnectionDeleted(block: DescribeVpnConnectionsRequest.Builder.() -> Unit): Outcome<DescribeVpnConnectionsResponse> =
    waitUntilVpnConnectionDeleted(DescribeVpnConnectionsRequest.Builder().apply(block).build())

public suspend fun Ec2Client.waitUntilPasswordDataAvailable(request: GetPasswordDataRequest): Outcome<GetPasswordDataResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<GetPasswordDataRequest, GetPasswordDataResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val passwordData = it?.passwordData
            val length = passwordData?.length ?: 0
            val number = 0.0
            val comparison = if (length == null || number == null) null else length.compareTo(number) > 0
            comparison == true
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getPasswordData(request) }
}

public suspend fun Ec2Client.waitUntilPasswordDataAvailable(block: GetPasswordDataRequest.Builder.() -> Unit): Outcome<GetPasswordDataResponse> =
    waitUntilPasswordDataAvailable(GetPasswordDataRequest.Builder().apply(block).build())
