// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseEc2QueryErrorResponse
import aws.sdk.kotlin.services.ec2.model.Ec2Exception
import aws.sdk.kotlin.services.ec2.model.GetReservedInstancesExchangeQuoteResponse
import aws.sdk.kotlin.services.ec2.model.ReservationValue
import aws.sdk.kotlin.services.ec2.model.ReservedInstanceReservationValue
import aws.sdk.kotlin.services.ec2.model.TargetReservationValue
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant


internal class GetReservedInstancesExchangeQuoteOperationDeserializer: HttpDeserialize<GetReservedInstancesExchangeQuoteResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetReservedInstancesExchangeQuoteResponse {
        if (!response.status.isSuccess()) {
            throwGetReservedInstancesExchangeQuoteError(context, response)
        }
        val builder = GetReservedInstancesExchangeQuoteResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetReservedInstancesExchangeQuoteOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetReservedInstancesExchangeQuoteError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseEc2QueryErrorResponse(payload)
    } catch (ex: Exception) {
        throw Ec2Exception("Failed to parse response as 'ec2Query' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> Ec2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetReservedInstancesExchangeQuoteOperationBody(builder: GetReservedInstancesExchangeQuoteResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val CURRENCYCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("currencyCode"))
    val ISVALIDEXCHANGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("isValidExchange"))
    val OUTPUTRESERVEDINSTANCESWILLEXPIREAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("outputReservedInstancesWillExpireAt"))
    val PAYMENTDUE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("paymentDue"))
    val RESERVEDINSTANCEVALUEROLLUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("reservedInstanceValueRollup"))
    val RESERVEDINSTANCEVALUESET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("reservedInstanceValueSet"), XmlCollectionName("item"))
    val TARGETCONFIGURATIONVALUEROLLUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("targetConfigurationValueRollup"))
    val TARGETCONFIGURATIONVALUESET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("targetConfigurationValueSet"), XmlCollectionName("item"))
    val VALIDATIONFAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("validationFailureReason"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://ec2.amazonaws.com/doc/2016-11-15"))
        trait(XmlSerialName("GetReservedInstancesExchangeQuoteResult"))
        field(CURRENCYCODE_DESCRIPTOR)
        field(ISVALIDEXCHANGE_DESCRIPTOR)
        field(OUTPUTRESERVEDINSTANCESWILLEXPIREAT_DESCRIPTOR)
        field(PAYMENTDUE_DESCRIPTOR)
        field(RESERVEDINSTANCEVALUEROLLUP_DESCRIPTOR)
        field(RESERVEDINSTANCEVALUESET_DESCRIPTOR)
        field(TARGETCONFIGURATIONVALUEROLLUP_DESCRIPTOR)
        field(TARGETCONFIGURATIONVALUESET_DESCRIPTOR)
        field(VALIDATIONFAILUREREASON_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CURRENCYCODE_DESCRIPTOR.index -> builder.currencyCode = deserializeString()
                ISVALIDEXCHANGE_DESCRIPTOR.index -> builder.isValidExchange = deserializeBoolean()
                OUTPUTRESERVEDINSTANCESWILLEXPIREAT_DESCRIPTOR.index -> builder.outputReservedInstancesWillExpireAt = deserializeString().let { Instant.fromIso8601(it) }
                PAYMENTDUE_DESCRIPTOR.index -> builder.paymentDue = deserializeString()
                RESERVEDINSTANCEVALUEROLLUP_DESCRIPTOR.index -> builder.reservedInstanceValueRollup = deserializeReservationValueDocument(deserializer)
                RESERVEDINSTANCEVALUESET_DESCRIPTOR.index -> builder.reservedInstanceValueSet =
                    deserializer.deserializeList(RESERVEDINSTANCEVALUESET_DESCRIPTOR) {
                        val col0 = mutableListOf<ReservedInstanceReservationValue>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeReservedInstanceReservationValueDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TARGETCONFIGURATIONVALUEROLLUP_DESCRIPTOR.index -> builder.targetConfigurationValueRollup = deserializeReservationValueDocument(deserializer)
                TARGETCONFIGURATIONVALUESET_DESCRIPTOR.index -> builder.targetConfigurationValueSet =
                    deserializer.deserializeList(TARGETCONFIGURATIONVALUESET_DESCRIPTOR) {
                        val col0 = mutableListOf<TargetReservationValue>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTargetReservationValueDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                VALIDATIONFAILUREREASON_DESCRIPTOR.index -> builder.validationFailureReason = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
