// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseEc2QueryErrorResponse
import aws.sdk.kotlin.services.ec2.model.DeprovisionPublicIpv4PoolCidrResponse
import aws.sdk.kotlin.services.ec2.model.Ec2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class DeprovisionPublicIpv4PoolCidrOperationDeserializer: HttpDeserialize<DeprovisionPublicIpv4PoolCidrResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeprovisionPublicIpv4PoolCidrResponse {
        if (!response.status.isSuccess()) {
            throwDeprovisionPublicIpv4PoolCidrError(context, response)
        }
        val builder = DeprovisionPublicIpv4PoolCidrResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeprovisionPublicIpv4PoolCidrOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeprovisionPublicIpv4PoolCidrError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseEc2QueryErrorResponse(payload)
    } catch (ex: Exception) {
        throw Ec2Exception("Failed to parse response as 'ec2Query' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> Ec2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeprovisionPublicIpv4PoolCidrOperationBody(builder: DeprovisionPublicIpv4PoolCidrResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val DEPROVISIONEDADDRESSES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("deprovisionedAddressSet"), XmlCollectionName("item"))
    val POOLID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("poolId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://ec2.amazonaws.com/doc/2016-11-15"))
        trait(XmlSerialName("DeprovisionPublicIpv4PoolCidrResult"))
        field(DEPROVISIONEDADDRESSES_DESCRIPTOR)
        field(POOLID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEPROVISIONEDADDRESSES_DESCRIPTOR.index -> builder.deprovisionedAddresses =
                    deserializer.deserializeList(DEPROVISIONEDADDRESSES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                POOLID_DESCRIPTOR.index -> builder.poolId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
