// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.transform

import aws.sdk.kotlin.services.ec2.model.CreateNetworkInterfaceRequest
import aws.sdk.kotlin.services.ec2.model.InstanceIpv6Address
import aws.sdk.kotlin.services.ec2.model.Ipv4PrefixSpecificationRequest
import aws.sdk.kotlin.services.ec2.model.Ipv6PrefixSpecificationRequest
import aws.sdk.kotlin.services.ec2.model.NetworkInterfaceCreationType
import aws.sdk.kotlin.services.ec2.model.PrivateIpAddressSpecification
import aws.sdk.kotlin.services.ec2.model.TagSpecification
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlFlattened
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateNetworkInterfaceOperationSerializer: HttpSerialize<CreateNetworkInterfaceRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateNetworkInterfaceRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeCreateNetworkInterfaceOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeCreateNetworkInterfaceOperationBody(context: ExecutionContext, input: CreateNetworkInterfaceRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ClientToken"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Description"))
    val DRYRUN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("DryRun"))
    val GROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("SecurityGroupId"), FormUrlFlattened)
    val INTERFACETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, FormUrlSerialName("InterfaceType"))
    val IPV4PREFIXCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("Ipv4PrefixCount"))
    val IPV4PREFIXES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Ipv4Prefix"), FormUrlFlattened)
    val IPV6ADDRESSCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("Ipv6AddressCount"))
    val IPV6ADDRESSES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Ipv6Addresses"), FormUrlFlattened)
    val IPV6PREFIXCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("Ipv6PrefixCount"))
    val IPV6PREFIXES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Ipv6Prefix"), FormUrlFlattened)
    val PRIVATEIPADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("PrivateIpAddress"))
    val PRIVATEIPADDRESSES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("PrivateIpAddresses"), FormUrlFlattened)
    val SECONDARYPRIVATEIPADDRESSCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("SecondaryPrivateIpAddressCount"))
    val SUBNETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("SubnetId"))
    val TAGSPECIFICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("TagSpecification"), FormUrlFlattened)
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("CreateNetworkInterfaceRequest"))
        trait(QueryLiteral("Action", "CreateNetworkInterface"))
        trait(QueryLiteral("Version", "2016-11-15"))
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DRYRUN_DESCRIPTOR)
        field(GROUPS_DESCRIPTOR)
        field(INTERFACETYPE_DESCRIPTOR)
        field(IPV4PREFIXCOUNT_DESCRIPTOR)
        field(IPV4PREFIXES_DESCRIPTOR)
        field(IPV6ADDRESSCOUNT_DESCRIPTOR)
        field(IPV6ADDRESSES_DESCRIPTOR)
        field(IPV6PREFIXCOUNT_DESCRIPTOR)
        field(IPV6PREFIXES_DESCRIPTOR)
        field(PRIVATEIPADDRESS_DESCRIPTOR)
        field(PRIVATEIPADDRESSES_DESCRIPTOR)
        field(SECONDARYPRIVATEIPADDRESSCOUNT_DESCRIPTOR)
        field(SUBNETID_DESCRIPTOR)
        field(TAGSPECIFICATIONS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.dryRun?.let { field(DRYRUN_DESCRIPTOR, it) }
        if (input.groups != null) {
            listField(GROUPS_DESCRIPTOR) {
                for (el0 in input.groups) {
                    serializeString(el0)
                }
            }
        }
        input.interfaceType?.let { field(INTERFACETYPE_DESCRIPTOR, it.value) }
        input.ipv4PrefixCount?.let { field(IPV4PREFIXCOUNT_DESCRIPTOR, it) }
        if (input.ipv4Prefixes != null) {
            listField(IPV4PREFIXES_DESCRIPTOR) {
                for (el0 in input.ipv4Prefixes) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeIpv4PrefixSpecificationRequestDocument))
                }
            }
        }
        input.ipv6AddressCount?.let { field(IPV6ADDRESSCOUNT_DESCRIPTOR, it) }
        if (input.ipv6Addresses != null) {
            listField(IPV6ADDRESSES_DESCRIPTOR) {
                for (el0 in input.ipv6Addresses) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeInstanceIpv6AddressDocument))
                }
            }
        }
        input.ipv6PrefixCount?.let { field(IPV6PREFIXCOUNT_DESCRIPTOR, it) }
        if (input.ipv6Prefixes != null) {
            listField(IPV6PREFIXES_DESCRIPTOR) {
                for (el0 in input.ipv6Prefixes) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeIpv6PrefixSpecificationRequestDocument))
                }
            }
        }
        input.privateIpAddress?.let { field(PRIVATEIPADDRESS_DESCRIPTOR, it) }
        if (input.privateIpAddresses != null) {
            listField(PRIVATEIPADDRESSES_DESCRIPTOR) {
                for (el0 in input.privateIpAddresses) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializePrivateIpAddressSpecificationDocument))
                }
            }
        }
        input.secondaryPrivateIpAddressCount?.let { field(SECONDARYPRIVATEIPADDRESSCOUNT_DESCRIPTOR, it) }
        input.subnetId?.let { field(SUBNETID_DESCRIPTOR, it) }
        if (input.tagSpecifications != null) {
            listField(TAGSPECIFICATIONS_DESCRIPTOR) {
                for (el0 in input.tagSpecifications) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagSpecificationDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
