// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes VPN connection options.
 */
public class VpnConnectionOptionsSpecification private constructor(builder: Builder) {
    /**
     * Indicate whether to enable acceleration for the VPN connection.
     *
     * Default: `false`
     */
    public val enableAcceleration: kotlin.Boolean? = builder.enableAcceleration
    /**
     * The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
     *
     * Default: `0.0.0.0/0`
     */
    public val localIpv4NetworkCidr: kotlin.String? = builder.localIpv4NetworkCidr
    /**
     * The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
     *
     * Default: `::/0`
     */
    public val localIpv6NetworkCidr: kotlin.String? = builder.localIpv6NetworkCidr
    /**
     * The type of IPv4 address assigned to the outside interface of the customer gateway device.
     *
     * Valid values: `PrivateIpv4` | `PublicIpv4`
     *
     * Default: `PublicIpv4`
     */
    public val outsideIpAddressType: kotlin.String? = builder.outsideIpAddressType
    /**
     * The IPv4 CIDR on the Amazon Web Services side of the VPN connection.
     *
     * Default: `0.0.0.0/0`
     */
    public val remoteIpv4NetworkCidr: kotlin.String? = builder.remoteIpv4NetworkCidr
    /**
     * The IPv6 CIDR on the Amazon Web Services side of the VPN connection.
     *
     * Default: `::/0`
     */
    public val remoteIpv6NetworkCidr: kotlin.String? = builder.remoteIpv6NetworkCidr
    /**
     * Indicate whether the VPN connection uses static routes only. If you are creating a VPN connection for a device that does not support BGP, you must specify `true`. Use CreateVpnConnectionRoute to create a static route.
     *
     * Default: `false`
     */
    public val staticRoutesOnly: kotlin.Boolean? = builder.staticRoutesOnly
    /**
     * The transit gateway attachment ID to use for the VPN tunnel.
     *
     * Required if `OutsideIpAddressType` is set to `PrivateIpv4`.
     */
    public val transportTransitGatewayAttachmentId: kotlin.String? = builder.transportTransitGatewayAttachmentId
    /**
     * Indicate whether the VPN tunnels process IPv4 or IPv6 traffic.
     *
     * Default: `ipv4`
     */
    public val tunnelInsideIpVersion: aws.sdk.kotlin.services.ec2.model.TunnelInsideIpVersion? = builder.tunnelInsideIpVersion
    /**
     * The tunnel options for the VPN connection.
     */
    public val tunnelOptions: List<VpnTunnelOptionsSpecification>? = builder.tunnelOptions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.VpnConnectionOptionsSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpnConnectionOptionsSpecification(")
        append("enableAcceleration=$enableAcceleration,")
        append("localIpv4NetworkCidr=$localIpv4NetworkCidr,")
        append("localIpv6NetworkCidr=$localIpv6NetworkCidr,")
        append("outsideIpAddressType=$outsideIpAddressType,")
        append("remoteIpv4NetworkCidr=$remoteIpv4NetworkCidr,")
        append("remoteIpv6NetworkCidr=$remoteIpv6NetworkCidr,")
        append("staticRoutesOnly=$staticRoutesOnly,")
        append("transportTransitGatewayAttachmentId=$transportTransitGatewayAttachmentId,")
        append("tunnelInsideIpVersion=$tunnelInsideIpVersion,")
        append("tunnelOptions=$tunnelOptions)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enableAcceleration?.hashCode() ?: 0
        result = 31 * result + (localIpv4NetworkCidr?.hashCode() ?: 0)
        result = 31 * result + (localIpv6NetworkCidr?.hashCode() ?: 0)
        result = 31 * result + (outsideIpAddressType?.hashCode() ?: 0)
        result = 31 * result + (remoteIpv4NetworkCidr?.hashCode() ?: 0)
        result = 31 * result + (remoteIpv6NetworkCidr?.hashCode() ?: 0)
        result = 31 * result + (staticRoutesOnly?.hashCode() ?: 0)
        result = 31 * result + (transportTransitGatewayAttachmentId?.hashCode() ?: 0)
        result = 31 * result + (tunnelInsideIpVersion?.hashCode() ?: 0)
        result = 31 * result + (tunnelOptions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpnConnectionOptionsSpecification

        if (enableAcceleration != other.enableAcceleration) return false
        if (localIpv4NetworkCidr != other.localIpv4NetworkCidr) return false
        if (localIpv6NetworkCidr != other.localIpv6NetworkCidr) return false
        if (outsideIpAddressType != other.outsideIpAddressType) return false
        if (remoteIpv4NetworkCidr != other.remoteIpv4NetworkCidr) return false
        if (remoteIpv6NetworkCidr != other.remoteIpv6NetworkCidr) return false
        if (staticRoutesOnly != other.staticRoutesOnly) return false
        if (transportTransitGatewayAttachmentId != other.transportTransitGatewayAttachmentId) return false
        if (tunnelInsideIpVersion != other.tunnelInsideIpVersion) return false
        if (tunnelOptions != other.tunnelOptions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.VpnConnectionOptionsSpecification = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicate whether to enable acceleration for the VPN connection.
         *
         * Default: `false`
         */
        public var enableAcceleration: kotlin.Boolean? = null
        /**
         * The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
         *
         * Default: `0.0.0.0/0`
         */
        public var localIpv4NetworkCidr: kotlin.String? = null
        /**
         * The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
         *
         * Default: `::/0`
         */
        public var localIpv6NetworkCidr: kotlin.String? = null
        /**
         * The type of IPv4 address assigned to the outside interface of the customer gateway device.
         *
         * Valid values: `PrivateIpv4` | `PublicIpv4`
         *
         * Default: `PublicIpv4`
         */
        public var outsideIpAddressType: kotlin.String? = null
        /**
         * The IPv4 CIDR on the Amazon Web Services side of the VPN connection.
         *
         * Default: `0.0.0.0/0`
         */
        public var remoteIpv4NetworkCidr: kotlin.String? = null
        /**
         * The IPv6 CIDR on the Amazon Web Services side of the VPN connection.
         *
         * Default: `::/0`
         */
        public var remoteIpv6NetworkCidr: kotlin.String? = null
        /**
         * Indicate whether the VPN connection uses static routes only. If you are creating a VPN connection for a device that does not support BGP, you must specify `true`. Use CreateVpnConnectionRoute to create a static route.
         *
         * Default: `false`
         */
        public var staticRoutesOnly: kotlin.Boolean? = null
        /**
         * The transit gateway attachment ID to use for the VPN tunnel.
         *
         * Required if `OutsideIpAddressType` is set to `PrivateIpv4`.
         */
        public var transportTransitGatewayAttachmentId: kotlin.String? = null
        /**
         * Indicate whether the VPN tunnels process IPv4 or IPv6 traffic.
         *
         * Default: `ipv4`
         */
        public var tunnelInsideIpVersion: aws.sdk.kotlin.services.ec2.model.TunnelInsideIpVersion? = null
        /**
         * The tunnel options for the VPN connection.
         */
        public var tunnelOptions: List<VpnTunnelOptionsSpecification>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.VpnConnectionOptionsSpecification) : this() {
            this.enableAcceleration = x.enableAcceleration
            this.localIpv4NetworkCidr = x.localIpv4NetworkCidr
            this.localIpv6NetworkCidr = x.localIpv6NetworkCidr
            this.outsideIpAddressType = x.outsideIpAddressType
            this.remoteIpv4NetworkCidr = x.remoteIpv4NetworkCidr
            this.remoteIpv6NetworkCidr = x.remoteIpv6NetworkCidr
            this.staticRoutesOnly = x.staticRoutesOnly
            this.transportTransitGatewayAttachmentId = x.transportTransitGatewayAttachmentId
            this.tunnelInsideIpVersion = x.tunnelInsideIpVersion
            this.tunnelOptions = x.tunnelOptions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.VpnConnectionOptionsSpecification = VpnConnectionOptionsSpecification(this)
    }
}
