// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a VPN connection.
 */
public class VpnConnection private constructor(builder: Builder) {
    /**
     * The category of the VPN connection. A value of `VPN` indicates an Amazon Web Services VPN connection. A value of `VPN-Classic` indicates an Amazon Web Services Classic VPN connection.
     */
    public val category: kotlin.String? = builder.category
    /**
     * The ARN of the core network.
     */
    public val coreNetworkArn: kotlin.String? = builder.coreNetworkArn
    /**
     * The ARN of the core network attachment.
     */
    public val coreNetworkAttachmentArn: kotlin.String? = builder.coreNetworkAttachmentArn
    /**
     * The configuration information for the VPN connection's customer gateway (in the native XML format). This element is always present in the CreateVpnConnection response; however, it's present in the DescribeVpnConnections response only if the VPN connection is in the `pending` or `available` state.
     */
    public val customerGatewayConfiguration: kotlin.String? = builder.customerGatewayConfiguration
    /**
     * The ID of the customer gateway at your end of the VPN connection.
     */
    public val customerGatewayId: kotlin.String? = builder.customerGatewayId
    /**
     * The current state of the gateway association.
     */
    public val gatewayAssociationState: aws.sdk.kotlin.services.ec2.model.GatewayAssociationState? = builder.gatewayAssociationState
    /**
     * The VPN connection options.
     */
    public val options: aws.sdk.kotlin.services.ec2.model.VpnConnectionOptions? = builder.options
    /**
     * The static routes associated with the VPN connection.
     */
    public val routes: List<VpnStaticRoute>? = builder.routes
    /**
     * The current state of the VPN connection.
     */
    public val state: aws.sdk.kotlin.services.ec2.model.VpnState? = builder.state
    /**
     * Any tags assigned to the VPN connection.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The ID of the transit gateway associated with the VPN connection.
     */
    public val transitGatewayId: kotlin.String? = builder.transitGatewayId
    /**
     * The type of VPN connection.
     */
    public val type: aws.sdk.kotlin.services.ec2.model.GatewayType? = builder.type
    /**
     * Information about the VPN tunnel.
     */
    public val vgwTelemetry: List<VgwTelemetry>? = builder.vgwTelemetry
    /**
     * The ID of the VPN connection.
     */
    public val vpnConnectionId: kotlin.String? = builder.vpnConnectionId
    /**
     * The ID of the virtual private gateway at the Amazon Web Services side of the VPN connection.
     */
    public val vpnGatewayId: kotlin.String? = builder.vpnGatewayId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.VpnConnection = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpnConnection(")
        append("category=$category,")
        append("coreNetworkArn=$coreNetworkArn,")
        append("coreNetworkAttachmentArn=$coreNetworkAttachmentArn,")
        append("customerGatewayConfiguration=$customerGatewayConfiguration,")
        append("customerGatewayId=$customerGatewayId,")
        append("gatewayAssociationState=$gatewayAssociationState,")
        append("options=$options,")
        append("routes=$routes,")
        append("state=$state,")
        append("tags=$tags,")
        append("transitGatewayId=$transitGatewayId,")
        append("type=$type,")
        append("vgwTelemetry=$vgwTelemetry,")
        append("vpnConnectionId=$vpnConnectionId,")
        append("vpnGatewayId=$vpnGatewayId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = category?.hashCode() ?: 0
        result = 31 * result + (coreNetworkArn?.hashCode() ?: 0)
        result = 31 * result + (coreNetworkAttachmentArn?.hashCode() ?: 0)
        result = 31 * result + (customerGatewayConfiguration?.hashCode() ?: 0)
        result = 31 * result + (customerGatewayId?.hashCode() ?: 0)
        result = 31 * result + (gatewayAssociationState?.hashCode() ?: 0)
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (routes?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (vgwTelemetry?.hashCode() ?: 0)
        result = 31 * result + (vpnConnectionId?.hashCode() ?: 0)
        result = 31 * result + (vpnGatewayId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpnConnection

        if (category != other.category) return false
        if (coreNetworkArn != other.coreNetworkArn) return false
        if (coreNetworkAttachmentArn != other.coreNetworkAttachmentArn) return false
        if (customerGatewayConfiguration != other.customerGatewayConfiguration) return false
        if (customerGatewayId != other.customerGatewayId) return false
        if (gatewayAssociationState != other.gatewayAssociationState) return false
        if (options != other.options) return false
        if (routes != other.routes) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (transitGatewayId != other.transitGatewayId) return false
        if (type != other.type) return false
        if (vgwTelemetry != other.vgwTelemetry) return false
        if (vpnConnectionId != other.vpnConnectionId) return false
        if (vpnGatewayId != other.vpnGatewayId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.VpnConnection = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The category of the VPN connection. A value of `VPN` indicates an Amazon Web Services VPN connection. A value of `VPN-Classic` indicates an Amazon Web Services Classic VPN connection.
         */
        public var category: kotlin.String? = null
        /**
         * The ARN of the core network.
         */
        public var coreNetworkArn: kotlin.String? = null
        /**
         * The ARN of the core network attachment.
         */
        public var coreNetworkAttachmentArn: kotlin.String? = null
        /**
         * The configuration information for the VPN connection's customer gateway (in the native XML format). This element is always present in the CreateVpnConnection response; however, it's present in the DescribeVpnConnections response only if the VPN connection is in the `pending` or `available` state.
         */
        public var customerGatewayConfiguration: kotlin.String? = null
        /**
         * The ID of the customer gateway at your end of the VPN connection.
         */
        public var customerGatewayId: kotlin.String? = null
        /**
         * The current state of the gateway association.
         */
        public var gatewayAssociationState: aws.sdk.kotlin.services.ec2.model.GatewayAssociationState? = null
        /**
         * The VPN connection options.
         */
        public var options: aws.sdk.kotlin.services.ec2.model.VpnConnectionOptions? = null
        /**
         * The static routes associated with the VPN connection.
         */
        public var routes: List<VpnStaticRoute>? = null
        /**
         * The current state of the VPN connection.
         */
        public var state: aws.sdk.kotlin.services.ec2.model.VpnState? = null
        /**
         * Any tags assigned to the VPN connection.
         */
        public var tags: List<Tag>? = null
        /**
         * The ID of the transit gateway associated with the VPN connection.
         */
        public var transitGatewayId: kotlin.String? = null
        /**
         * The type of VPN connection.
         */
        public var type: aws.sdk.kotlin.services.ec2.model.GatewayType? = null
        /**
         * Information about the VPN tunnel.
         */
        public var vgwTelemetry: List<VgwTelemetry>? = null
        /**
         * The ID of the VPN connection.
         */
        public var vpnConnectionId: kotlin.String? = null
        /**
         * The ID of the virtual private gateway at the Amazon Web Services side of the VPN connection.
         */
        public var vpnGatewayId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.VpnConnection) : this() {
            this.category = x.category
            this.coreNetworkArn = x.coreNetworkArn
            this.coreNetworkAttachmentArn = x.coreNetworkAttachmentArn
            this.customerGatewayConfiguration = x.customerGatewayConfiguration
            this.customerGatewayId = x.customerGatewayId
            this.gatewayAssociationState = x.gatewayAssociationState
            this.options = x.options
            this.routes = x.routes
            this.state = x.state
            this.tags = x.tags
            this.transitGatewayId = x.transitGatewayId
            this.type = x.type
            this.vgwTelemetry = x.vgwTelemetry
            this.vpnConnectionId = x.vpnConnectionId
            this.vpnGatewayId = x.vpnGatewayId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.VpnConnection = VpnConnection(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.VpnConnectionOptions] inside the given [block]
         */
        public fun options(block: aws.sdk.kotlin.services.ec2.model.VpnConnectionOptions.Builder.() -> kotlin.Unit) {
            this.options = aws.sdk.kotlin.services.ec2.model.VpnConnectionOptions.invoke(block)
        }
    }
}
