// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a VPC in a VPC peering connection.
 */
public class VpcPeeringConnectionVpcInfo private constructor(builder: Builder) {
    /**
     * The IPv4 CIDR block for the VPC.
     */
    public val cidrBlock: kotlin.String? = builder.cidrBlock
    /**
     * Information about the IPv4 CIDR blocks for the VPC.
     */
    public val cidrBlockSet: List<CidrBlock>? = builder.cidrBlockSet
    /**
     * The IPv6 CIDR block for the VPC.
     */
    public val ipv6CidrBlockSet: List<Ipv6CidrBlock>? = builder.ipv6CidrBlockSet
    /**
     * The ID of the Amazon Web Services account that owns the VPC.
     */
    public val ownerId: kotlin.String? = builder.ownerId
    /**
     * Information about the VPC peering connection options for the accepter or requester VPC.
     */
    public val peeringOptions: aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionOptionsDescription? = builder.peeringOptions
    /**
     * The Region in which the VPC is located.
     */
    public val region: kotlin.String? = builder.region
    /**
     * The ID of the VPC.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionVpcInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcPeeringConnectionVpcInfo(")
        append("cidrBlock=$cidrBlock,")
        append("cidrBlockSet=$cidrBlockSet,")
        append("ipv6CidrBlockSet=$ipv6CidrBlockSet,")
        append("ownerId=$ownerId,")
        append("peeringOptions=$peeringOptions,")
        append("region=$region,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidrBlock?.hashCode() ?: 0
        result = 31 * result + (cidrBlockSet?.hashCode() ?: 0)
        result = 31 * result + (ipv6CidrBlockSet?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (peeringOptions?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcPeeringConnectionVpcInfo

        if (cidrBlock != other.cidrBlock) return false
        if (cidrBlockSet != other.cidrBlockSet) return false
        if (ipv6CidrBlockSet != other.ipv6CidrBlockSet) return false
        if (ownerId != other.ownerId) return false
        if (peeringOptions != other.peeringOptions) return false
        if (region != other.region) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionVpcInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The IPv4 CIDR block for the VPC.
         */
        public var cidrBlock: kotlin.String? = null
        /**
         * Information about the IPv4 CIDR blocks for the VPC.
         */
        public var cidrBlockSet: List<CidrBlock>? = null
        /**
         * The IPv6 CIDR block for the VPC.
         */
        public var ipv6CidrBlockSet: List<Ipv6CidrBlock>? = null
        /**
         * The ID of the Amazon Web Services account that owns the VPC.
         */
        public var ownerId: kotlin.String? = null
        /**
         * Information about the VPC peering connection options for the accepter or requester VPC.
         */
        public var peeringOptions: aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionOptionsDescription? = null
        /**
         * The Region in which the VPC is located.
         */
        public var region: kotlin.String? = null
        /**
         * The ID of the VPC.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionVpcInfo) : this() {
            this.cidrBlock = x.cidrBlock
            this.cidrBlockSet = x.cidrBlockSet
            this.ipv6CidrBlockSet = x.ipv6CidrBlockSet
            this.ownerId = x.ownerId
            this.peeringOptions = x.peeringOptions
            this.region = x.region
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionVpcInfo = VpcPeeringConnectionVpcInfo(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionOptionsDescription] inside the given [block]
         */
        public fun peeringOptions(block: aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionOptionsDescription.Builder.() -> kotlin.Unit) {
            this.peeringOptions = aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionOptionsDescription.invoke(block)
        }
    }
}
