// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see [Migrate from EC2-Classic to a VPC](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html) in the *Amazon Elastic Compute Cloud User Guide*.
 *
 * Describes the VPC peering connection options.
 */
public class VpcPeeringConnectionOptionsDescription private constructor(builder: Builder) {
    /**
     * Indicates whether a local VPC can resolve public DNS hostnames to private IP addresses when queried from instances in a peer VPC.
     */
    public val allowDnsResolutionFromRemoteVpc: kotlin.Boolean? = builder.allowDnsResolutionFromRemoteVpc
    /**
     * Indicates whether a local ClassicLink connection can communicate with the peer VPC over the VPC peering connection.
     */
    public val allowEgressFromLocalClassicLinkToRemoteVpc: kotlin.Boolean? = builder.allowEgressFromLocalClassicLinkToRemoteVpc
    /**
     * Indicates whether a local VPC can communicate with a ClassicLink connection in the peer VPC over the VPC peering connection.
     */
    public val allowEgressFromLocalVpcToRemoteClassicLink: kotlin.Boolean? = builder.allowEgressFromLocalVpcToRemoteClassicLink

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionOptionsDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcPeeringConnectionOptionsDescription(")
        append("allowDnsResolutionFromRemoteVpc=$allowDnsResolutionFromRemoteVpc,")
        append("allowEgressFromLocalClassicLinkToRemoteVpc=$allowEgressFromLocalClassicLinkToRemoteVpc,")
        append("allowEgressFromLocalVpcToRemoteClassicLink=$allowEgressFromLocalVpcToRemoteClassicLink)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowDnsResolutionFromRemoteVpc?.hashCode() ?: 0
        result = 31 * result + (allowEgressFromLocalClassicLinkToRemoteVpc?.hashCode() ?: 0)
        result = 31 * result + (allowEgressFromLocalVpcToRemoteClassicLink?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcPeeringConnectionOptionsDescription

        if (allowDnsResolutionFromRemoteVpc != other.allowDnsResolutionFromRemoteVpc) return false
        if (allowEgressFromLocalClassicLinkToRemoteVpc != other.allowEgressFromLocalClassicLinkToRemoteVpc) return false
        if (allowEgressFromLocalVpcToRemoteClassicLink != other.allowEgressFromLocalVpcToRemoteClassicLink) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionOptionsDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether a local VPC can resolve public DNS hostnames to private IP addresses when queried from instances in a peer VPC.
         */
        public var allowDnsResolutionFromRemoteVpc: kotlin.Boolean? = null
        /**
         * Indicates whether a local ClassicLink connection can communicate with the peer VPC over the VPC peering connection.
         */
        public var allowEgressFromLocalClassicLinkToRemoteVpc: kotlin.Boolean? = null
        /**
         * Indicates whether a local VPC can communicate with a ClassicLink connection in the peer VPC over the VPC peering connection.
         */
        public var allowEgressFromLocalVpcToRemoteClassicLink: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionOptionsDescription) : this() {
            this.allowDnsResolutionFromRemoteVpc = x.allowDnsResolutionFromRemoteVpc
            this.allowEgressFromLocalClassicLinkToRemoteVpc = x.allowEgressFromLocalClassicLinkToRemoteVpc
            this.allowEgressFromLocalVpcToRemoteClassicLink = x.allowEgressFromLocalVpcToRemoteClassicLink
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionOptionsDescription = VpcPeeringConnectionOptionsDescription(this)
    }
}
