// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a VPC peering connection.
 */
public class VpcPeeringConnection private constructor(builder: Builder) {
    /**
     * Information about the accepter VPC. CIDR block information is only returned when describing an active VPC peering connection.
     */
    public val accepterVpcInfo: aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionVpcInfo? = builder.accepterVpcInfo
    /**
     * The time that an unaccepted VPC peering connection will expire.
     */
    public val expirationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.expirationTime
    /**
     * Information about the requester VPC. CIDR block information is only returned when describing an active VPC peering connection.
     */
    public val requesterVpcInfo: aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionVpcInfo? = builder.requesterVpcInfo
    /**
     * The status of the VPC peering connection.
     */
    public val status: aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionStateReason? = builder.status
    /**
     * Any tags assigned to the resource.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The ID of the VPC peering connection.
     */
    public val vpcPeeringConnectionId: kotlin.String? = builder.vpcPeeringConnectionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.VpcPeeringConnection = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcPeeringConnection(")
        append("accepterVpcInfo=$accepterVpcInfo,")
        append("expirationTime=$expirationTime,")
        append("requesterVpcInfo=$requesterVpcInfo,")
        append("status=$status,")
        append("tags=$tags,")
        append("vpcPeeringConnectionId=$vpcPeeringConnectionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accepterVpcInfo?.hashCode() ?: 0
        result = 31 * result + (expirationTime?.hashCode() ?: 0)
        result = 31 * result + (requesterVpcInfo?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcPeeringConnectionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcPeeringConnection

        if (accepterVpcInfo != other.accepterVpcInfo) return false
        if (expirationTime != other.expirationTime) return false
        if (requesterVpcInfo != other.requesterVpcInfo) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (vpcPeeringConnectionId != other.vpcPeeringConnectionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.VpcPeeringConnection = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Information about the accepter VPC. CIDR block information is only returned when describing an active VPC peering connection.
         */
        public var accepterVpcInfo: aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionVpcInfo? = null
        /**
         * The time that an unaccepted VPC peering connection will expire.
         */
        public var expirationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about the requester VPC. CIDR block information is only returned when describing an active VPC peering connection.
         */
        public var requesterVpcInfo: aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionVpcInfo? = null
        /**
         * The status of the VPC peering connection.
         */
        public var status: aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionStateReason? = null
        /**
         * Any tags assigned to the resource.
         */
        public var tags: List<Tag>? = null
        /**
         * The ID of the VPC peering connection.
         */
        public var vpcPeeringConnectionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.VpcPeeringConnection) : this() {
            this.accepterVpcInfo = x.accepterVpcInfo
            this.expirationTime = x.expirationTime
            this.requesterVpcInfo = x.requesterVpcInfo
            this.status = x.status
            this.tags = x.tags
            this.vpcPeeringConnectionId = x.vpcPeeringConnectionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.VpcPeeringConnection = VpcPeeringConnection(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionVpcInfo] inside the given [block]
         */
        public fun accepterVpcInfo(block: aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionVpcInfo.Builder.() -> kotlin.Unit) {
            this.accepterVpcInfo = aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionVpcInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionVpcInfo] inside the given [block]
         */
        public fun requesterVpcInfo(block: aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionVpcInfo.Builder.() -> kotlin.Unit) {
            this.requesterVpcInfo = aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionVpcInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionStateReason] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionStateReason.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionStateReason.invoke(block)
        }
    }
}
