// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a VPC endpoint connection to a service.
 */
public class VpcEndpointConnection private constructor(builder: Builder) {
    /**
     * The date and time that the VPC endpoint was created.
     */
    public val creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTimestamp
    /**
     * The DNS entries for the VPC endpoint.
     */
    public val dnsEntries: List<DnsEntry>? = builder.dnsEntries
    /**
     * The Amazon Resource Names (ARNs) of the Gateway Load Balancers for the service.
     */
    public val gatewayLoadBalancerArns: List<String>? = builder.gatewayLoadBalancerArns
    /**
     * The IP address type for the endpoint.
     */
    public val ipAddressType: aws.sdk.kotlin.services.ec2.model.IpAddressType? = builder.ipAddressType
    /**
     * The Amazon Resource Names (ARNs) of the network load balancers for the service.
     */
    public val networkLoadBalancerArns: List<String>? = builder.networkLoadBalancerArns
    /**
     * The ID of the service to which the endpoint is connected.
     */
    public val serviceId: kotlin.String? = builder.serviceId
    /**
     * The tags.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The ID of the VPC endpoint connection.
     */
    public val vpcEndpointConnectionId: kotlin.String? = builder.vpcEndpointConnectionId
    /**
     * The ID of the VPC endpoint.
     */
    public val vpcEndpointId: kotlin.String? = builder.vpcEndpointId
    /**
     * The ID of the Amazon Web Services account that owns the VPC endpoint.
     */
    public val vpcEndpointOwner: kotlin.String? = builder.vpcEndpointOwner
    /**
     * The state of the VPC endpoint.
     */
    public val vpcEndpointState: aws.sdk.kotlin.services.ec2.model.State? = builder.vpcEndpointState

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.VpcEndpointConnection = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcEndpointConnection(")
        append("creationTimestamp=$creationTimestamp,")
        append("dnsEntries=$dnsEntries,")
        append("gatewayLoadBalancerArns=$gatewayLoadBalancerArns,")
        append("ipAddressType=$ipAddressType,")
        append("networkLoadBalancerArns=$networkLoadBalancerArns,")
        append("serviceId=$serviceId,")
        append("tags=$tags,")
        append("vpcEndpointConnectionId=$vpcEndpointConnectionId,")
        append("vpcEndpointId=$vpcEndpointId,")
        append("vpcEndpointOwner=$vpcEndpointOwner,")
        append("vpcEndpointState=$vpcEndpointState)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTimestamp?.hashCode() ?: 0
        result = 31 * result + (dnsEntries?.hashCode() ?: 0)
        result = 31 * result + (gatewayLoadBalancerArns?.hashCode() ?: 0)
        result = 31 * result + (ipAddressType?.hashCode() ?: 0)
        result = 31 * result + (networkLoadBalancerArns?.hashCode() ?: 0)
        result = 31 * result + (serviceId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointConnectionId?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointId?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointOwner?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointState?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcEndpointConnection

        if (creationTimestamp != other.creationTimestamp) return false
        if (dnsEntries != other.dnsEntries) return false
        if (gatewayLoadBalancerArns != other.gatewayLoadBalancerArns) return false
        if (ipAddressType != other.ipAddressType) return false
        if (networkLoadBalancerArns != other.networkLoadBalancerArns) return false
        if (serviceId != other.serviceId) return false
        if (tags != other.tags) return false
        if (vpcEndpointConnectionId != other.vpcEndpointConnectionId) return false
        if (vpcEndpointId != other.vpcEndpointId) return false
        if (vpcEndpointOwner != other.vpcEndpointOwner) return false
        if (vpcEndpointState != other.vpcEndpointState) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.VpcEndpointConnection = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time that the VPC endpoint was created.
         */
        public var creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The DNS entries for the VPC endpoint.
         */
        public var dnsEntries: List<DnsEntry>? = null
        /**
         * The Amazon Resource Names (ARNs) of the Gateway Load Balancers for the service.
         */
        public var gatewayLoadBalancerArns: List<String>? = null
        /**
         * The IP address type for the endpoint.
         */
        public var ipAddressType: aws.sdk.kotlin.services.ec2.model.IpAddressType? = null
        /**
         * The Amazon Resource Names (ARNs) of the network load balancers for the service.
         */
        public var networkLoadBalancerArns: List<String>? = null
        /**
         * The ID of the service to which the endpoint is connected.
         */
        public var serviceId: kotlin.String? = null
        /**
         * The tags.
         */
        public var tags: List<Tag>? = null
        /**
         * The ID of the VPC endpoint connection.
         */
        public var vpcEndpointConnectionId: kotlin.String? = null
        /**
         * The ID of the VPC endpoint.
         */
        public var vpcEndpointId: kotlin.String? = null
        /**
         * The ID of the Amazon Web Services account that owns the VPC endpoint.
         */
        public var vpcEndpointOwner: kotlin.String? = null
        /**
         * The state of the VPC endpoint.
         */
        public var vpcEndpointState: aws.sdk.kotlin.services.ec2.model.State? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.VpcEndpointConnection) : this() {
            this.creationTimestamp = x.creationTimestamp
            this.dnsEntries = x.dnsEntries
            this.gatewayLoadBalancerArns = x.gatewayLoadBalancerArns
            this.ipAddressType = x.ipAddressType
            this.networkLoadBalancerArns = x.networkLoadBalancerArns
            this.serviceId = x.serviceId
            this.tags = x.tags
            this.vpcEndpointConnectionId = x.vpcEndpointConnectionId
            this.vpcEndpointId = x.vpcEndpointId
            this.vpcEndpointOwner = x.vpcEndpointOwner
            this.vpcEndpointState = x.vpcEndpointState
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.VpcEndpointConnection = VpcEndpointConnection(this)
    }
}
