// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a target network associated with a Client VPN endpoint.
 */
public class TargetNetwork private constructor(builder: Builder) {
    /**
     * The ID of the association.
     */
    public val associationId: kotlin.String? = builder.associationId
    /**
     * The ID of the Client VPN endpoint with which the target network is associated.
     */
    public val clientVpnEndpointId: kotlin.String? = builder.clientVpnEndpointId
    /**
     * The IDs of the security groups applied to the target network association.
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * The current state of the target network association.
     */
    public val status: aws.sdk.kotlin.services.ec2.model.AssociationStatus? = builder.status
    /**
     * The ID of the subnet specified as the target network.
     */
    public val targetNetworkId: kotlin.String? = builder.targetNetworkId
    /**
     * The ID of the VPC in which the target network (subnet) is located.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.TargetNetwork = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TargetNetwork(")
        append("associationId=$associationId,")
        append("clientVpnEndpointId=$clientVpnEndpointId,")
        append("securityGroups=$securityGroups,")
        append("status=$status,")
        append("targetNetworkId=$targetNetworkId,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationId?.hashCode() ?: 0
        result = 31 * result + (clientVpnEndpointId?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetNetworkId?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TargetNetwork

        if (associationId != other.associationId) return false
        if (clientVpnEndpointId != other.clientVpnEndpointId) return false
        if (securityGroups != other.securityGroups) return false
        if (status != other.status) return false
        if (targetNetworkId != other.targetNetworkId) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.TargetNetwork = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the association.
         */
        public var associationId: kotlin.String? = null
        /**
         * The ID of the Client VPN endpoint with which the target network is associated.
         */
        public var clientVpnEndpointId: kotlin.String? = null
        /**
         * The IDs of the security groups applied to the target network association.
         */
        public var securityGroups: List<String>? = null
        /**
         * The current state of the target network association.
         */
        public var status: aws.sdk.kotlin.services.ec2.model.AssociationStatus? = null
        /**
         * The ID of the subnet specified as the target network.
         */
        public var targetNetworkId: kotlin.String? = null
        /**
         * The ID of the VPC in which the target network (subnet) is located.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.TargetNetwork) : this() {
            this.associationId = x.associationId
            this.clientVpnEndpointId = x.clientVpnEndpointId
            this.securityGroups = x.securityGroups
            this.status = x.status
            this.targetNetworkId = x.targetNetworkId
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.TargetNetwork = TargetNetwork(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AssociationStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.ec2.model.AssociationStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.ec2.model.AssociationStatus.invoke(block)
        }
    }
}
