// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a service configuration for a VPC endpoint service.
 */
public class ServiceConfiguration private constructor(builder: Builder) {
    /**
     * Indicates whether requests from other Amazon Web Services accounts to create an endpoint to the service must first be accepted.
     */
    public val acceptanceRequired: kotlin.Boolean? = builder.acceptanceRequired
    /**
     * The Availability Zones in which the service is available.
     */
    public val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * The DNS names for the service.
     */
    public val baseEndpointDnsNames: List<String>? = builder.baseEndpointDnsNames
    /**
     * The Amazon Resource Names (ARNs) of the Gateway Load Balancers for the service.
     */
    public val gatewayLoadBalancerArns: List<String>? = builder.gatewayLoadBalancerArns
    /**
     * Indicates whether the service manages its VPC endpoints. Management of the service VPC endpoints using the VPC endpoint API is restricted.
     */
    public val managesVpcEndpoints: kotlin.Boolean? = builder.managesVpcEndpoints
    /**
     * The Amazon Resource Names (ARNs) of the Network Load Balancers for the service.
     */
    public val networkLoadBalancerArns: List<String>? = builder.networkLoadBalancerArns
    /**
     * The payer responsibility.
     */
    public val payerResponsibility: aws.sdk.kotlin.services.ec2.model.PayerResponsibility? = builder.payerResponsibility
    /**
     * The private DNS name for the service.
     */
    public val privateDnsName: kotlin.String? = builder.privateDnsName
    /**
     * Information about the endpoint service private DNS name configuration.
     */
    public val privateDnsNameConfiguration: aws.sdk.kotlin.services.ec2.model.PrivateDnsNameConfiguration? = builder.privateDnsNameConfiguration
    /**
     * The ID of the service.
     */
    public val serviceId: kotlin.String? = builder.serviceId
    /**
     * The name of the service.
     */
    public val serviceName: kotlin.String? = builder.serviceName
    /**
     * The service state.
     */
    public val serviceState: aws.sdk.kotlin.services.ec2.model.ServiceState? = builder.serviceState
    /**
     * The type of service.
     */
    public val serviceType: List<ServiceTypeDetail>? = builder.serviceType
    /**
     * The supported IP address types.
     */
    public val supportedIpAddressTypes: List<ServiceConnectivityType>? = builder.supportedIpAddressTypes
    /**
     * Any tags assigned to the service.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.ServiceConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceConfiguration(")
        append("acceptanceRequired=$acceptanceRequired,")
        append("availabilityZones=$availabilityZones,")
        append("baseEndpointDnsNames=$baseEndpointDnsNames,")
        append("gatewayLoadBalancerArns=$gatewayLoadBalancerArns,")
        append("managesVpcEndpoints=$managesVpcEndpoints,")
        append("networkLoadBalancerArns=$networkLoadBalancerArns,")
        append("payerResponsibility=$payerResponsibility,")
        append("privateDnsName=$privateDnsName,")
        append("privateDnsNameConfiguration=$privateDnsNameConfiguration,")
        append("serviceId=$serviceId,")
        append("serviceName=$serviceName,")
        append("serviceState=$serviceState,")
        append("serviceType=$serviceType,")
        append("supportedIpAddressTypes=$supportedIpAddressTypes,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptanceRequired?.hashCode() ?: 0
        result = 31 * result + (availabilityZones?.hashCode() ?: 0)
        result = 31 * result + (baseEndpointDnsNames?.hashCode() ?: 0)
        result = 31 * result + (gatewayLoadBalancerArns?.hashCode() ?: 0)
        result = 31 * result + (managesVpcEndpoints?.hashCode() ?: 0)
        result = 31 * result + (networkLoadBalancerArns?.hashCode() ?: 0)
        result = 31 * result + (payerResponsibility?.hashCode() ?: 0)
        result = 31 * result + (privateDnsName?.hashCode() ?: 0)
        result = 31 * result + (privateDnsNameConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serviceId?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (serviceState?.hashCode() ?: 0)
        result = 31 * result + (serviceType?.hashCode() ?: 0)
        result = 31 * result + (supportedIpAddressTypes?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServiceConfiguration

        if (acceptanceRequired != other.acceptanceRequired) return false
        if (availabilityZones != other.availabilityZones) return false
        if (baseEndpointDnsNames != other.baseEndpointDnsNames) return false
        if (gatewayLoadBalancerArns != other.gatewayLoadBalancerArns) return false
        if (managesVpcEndpoints != other.managesVpcEndpoints) return false
        if (networkLoadBalancerArns != other.networkLoadBalancerArns) return false
        if (payerResponsibility != other.payerResponsibility) return false
        if (privateDnsName != other.privateDnsName) return false
        if (privateDnsNameConfiguration != other.privateDnsNameConfiguration) return false
        if (serviceId != other.serviceId) return false
        if (serviceName != other.serviceName) return false
        if (serviceState != other.serviceState) return false
        if (serviceType != other.serviceType) return false
        if (supportedIpAddressTypes != other.supportedIpAddressTypes) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.ServiceConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether requests from other Amazon Web Services accounts to create an endpoint to the service must first be accepted.
         */
        public var acceptanceRequired: kotlin.Boolean? = null
        /**
         * The Availability Zones in which the service is available.
         */
        public var availabilityZones: List<String>? = null
        /**
         * The DNS names for the service.
         */
        public var baseEndpointDnsNames: List<String>? = null
        /**
         * The Amazon Resource Names (ARNs) of the Gateway Load Balancers for the service.
         */
        public var gatewayLoadBalancerArns: List<String>? = null
        /**
         * Indicates whether the service manages its VPC endpoints. Management of the service VPC endpoints using the VPC endpoint API is restricted.
         */
        public var managesVpcEndpoints: kotlin.Boolean? = null
        /**
         * The Amazon Resource Names (ARNs) of the Network Load Balancers for the service.
         */
        public var networkLoadBalancerArns: List<String>? = null
        /**
         * The payer responsibility.
         */
        public var payerResponsibility: aws.sdk.kotlin.services.ec2.model.PayerResponsibility? = null
        /**
         * The private DNS name for the service.
         */
        public var privateDnsName: kotlin.String? = null
        /**
         * Information about the endpoint service private DNS name configuration.
         */
        public var privateDnsNameConfiguration: aws.sdk.kotlin.services.ec2.model.PrivateDnsNameConfiguration? = null
        /**
         * The ID of the service.
         */
        public var serviceId: kotlin.String? = null
        /**
         * The name of the service.
         */
        public var serviceName: kotlin.String? = null
        /**
         * The service state.
         */
        public var serviceState: aws.sdk.kotlin.services.ec2.model.ServiceState? = null
        /**
         * The type of service.
         */
        public var serviceType: List<ServiceTypeDetail>? = null
        /**
         * The supported IP address types.
         */
        public var supportedIpAddressTypes: List<ServiceConnectivityType>? = null
        /**
         * Any tags assigned to the service.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.ServiceConfiguration) : this() {
            this.acceptanceRequired = x.acceptanceRequired
            this.availabilityZones = x.availabilityZones
            this.baseEndpointDnsNames = x.baseEndpointDnsNames
            this.gatewayLoadBalancerArns = x.gatewayLoadBalancerArns
            this.managesVpcEndpoints = x.managesVpcEndpoints
            this.networkLoadBalancerArns = x.networkLoadBalancerArns
            this.payerResponsibility = x.payerResponsibility
            this.privateDnsName = x.privateDnsName
            this.privateDnsNameConfiguration = x.privateDnsNameConfiguration
            this.serviceId = x.serviceId
            this.serviceName = x.serviceName
            this.serviceState = x.serviceState
            this.serviceType = x.serviceType
            this.supportedIpAddressTypes = x.supportedIpAddressTypes
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.ServiceConfiguration = ServiceConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.PrivateDnsNameConfiguration] inside the given [block]
         */
        public fun privateDnsNameConfiguration(block: aws.sdk.kotlin.services.ec2.model.PrivateDnsNameConfiguration.Builder.() -> kotlin.Unit) {
            this.privateDnsNameConfiguration = aws.sdk.kotlin.services.ec2.model.PrivateDnsNameConfiguration.invoke(block)
        }
    }
}
