// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



public class RunInstancesRequest private constructor(builder: Builder) {
    /**
     * Reserved.
     */
    public val additionalInfo: kotlin.String? = builder.additionalInfo
    /**
     * The block device mapping, which defines the EBS volumes and instance store volumes to attach to the instance at launch. For more information, see [Block device mappings](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html) in the *Amazon EC2 User Guide*.
     */
    public val blockDeviceMappings: List<BlockDeviceMapping>? = builder.blockDeviceMappings
    /**
     * Information about the Capacity Reservation targeting option. If you do not specify this parameter, the instance's Capacity Reservation preference defaults to `open`, which enables it to run in any open Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).
     */
    public val capacityReservationSpecification: aws.sdk.kotlin.services.ec2.model.CapacityReservationSpecification? = builder.capacityReservationSpecification
    /**
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not specify a client token, a randomly generated token is used for the request to ensure idempotency.
     *
     * For more information, see [Ensuring Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
     *
     * Constraints: Maximum 64 ASCII characters
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The CPU options for the instance. For more information, see [Optimize CPU options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) in the *Amazon EC2 User Guide*.
     */
    public val cpuOptions: aws.sdk.kotlin.services.ec2.model.CpuOptionsRequest? = builder.cpuOptions
    /**
     * The credit option for CPU usage of the burstable performance instance. Valid values are `standard` and `unlimited`. To change this attribute after launch, use [ ModifyInstanceCreditSpecification](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceCreditSpecification.html). For more information, see [Burstable performance instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html) in the *Amazon EC2 User Guide*.
     *
     * Default: `standard` (T2 instances) or `unlimited` (T3/T3a/T4g instances)
     *
     * For T3 instances with `host` tenancy, only `standard` is supported.
     */
    public val creditSpecification: aws.sdk.kotlin.services.ec2.model.CreditSpecificationRequest? = builder.creditSpecification
    /**
     * Indicates whether an instance is enabled for stop protection. For more information, see [Stop protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
     */
    public val disableApiStop: kotlin.Boolean? = builder.disableApiStop
    /**
     * If you set this parameter to `true`, you can't terminate the instance using the Amazon EC2 console, CLI, or API; otherwise, you can. To change this attribute after launch, use [ModifyInstanceAttribute](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html). Alternatively, if you set `InstanceInitiatedShutdownBehavior` to `terminate`, you can terminate the instance by running the shutdown command from the instance.
     *
     * Default: `false`
     */
    public val disableApiTermination: kotlin.Boolean? = builder.disableApiTermination
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
     *
     * Default: `false`
     */
    public val ebsOptimized: kotlin.Boolean? = builder.ebsOptimized
    /**
     * An elastic GPU to associate with the instance. An Elastic GPU is a GPU resource that you can attach to your Windows instance to accelerate the graphics performance of your applications. For more information, see [Amazon EC2 Elastic GPUs](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html) in the *Amazon EC2 User Guide*.
     */
    public val elasticGpuSpecification: List<ElasticGpuSpecification>? = builder.elasticGpuSpecification
    /**
     * An elastic inference accelerator to associate with the instance. Elastic inference accelerators are a resource you can attach to your Amazon EC2 instances to accelerate your Deep Learning (DL) inference workloads.
     *
     * You cannot specify accelerators from different generations in the same request.
     */
    public val elasticInferenceAccelerators: List<ElasticInferenceAccelerator>? = builder.elasticInferenceAccelerators
    /**
     * Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves. For more information, see [ What is Amazon Web Services Nitro Enclaves?](https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html) in the *Amazon Web Services Nitro Enclaves User Guide*.
     *
     * You can't enable Amazon Web Services Nitro Enclaves and hibernation on the same instance.
     */
    public val enclaveOptions: aws.sdk.kotlin.services.ec2.model.EnclaveOptionsRequest? = builder.enclaveOptions
    /**
     * Indicates whether an instance is enabled for hibernation. For more information, see [Hibernate your instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html) in the *Amazon EC2 User Guide*.
     *
     * You can't enable hibernation and Amazon Web Services Nitro Enclaves on the same instance.
     */
    public val hibernationOptions: aws.sdk.kotlin.services.ec2.model.HibernationOptionsRequest? = builder.hibernationOptions
    /**
     * The name or Amazon Resource Name (ARN) of an IAM instance profile.
     */
    public val iamInstanceProfile: aws.sdk.kotlin.services.ec2.model.IamInstanceProfileSpecification? = builder.iamInstanceProfile
    /**
     * The ID of the AMI. An AMI ID is required to launch an instance and must be specified here or in a launch template.
     */
    public val imageId: kotlin.String? = builder.imageId
    /**
     * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
     *
     * Default: `stop`
     */
    public val instanceInitiatedShutdownBehavior: aws.sdk.kotlin.services.ec2.model.ShutdownBehavior? = builder.instanceInitiatedShutdownBehavior
    /**
     * The market (purchasing) option for the instances.
     *
     * For RunInstances, persistent Spot Instance requests are only supported when **InstanceInterruptionBehavior** is set to either `hibernate` or `stop`.
     */
    public val instanceMarketOptions: aws.sdk.kotlin.services.ec2.model.InstanceMarketOptionsRequest? = builder.instanceMarketOptions
    /**
     * The instance type. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon EC2 User Guide*.
     *
     * Default: `m1.small`
     */
    public val instanceType: aws.sdk.kotlin.services.ec2.model.InstanceType? = builder.instanceType
    /**
     * &#91;EC2-VPC&#93; The number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet. You cannot specify this option and the option to assign specific IPv6 addresses in the same request. You can specify this option if you've specified a minimum number of instances to launch.
     *
     * You cannot specify this option and the network interfaces option in the same request.
     */
    public val ipv6AddressCount: kotlin.Int? = builder.ipv6AddressCount
    /**
     * &#91;EC2-VPC&#93; The IPv6 addresses from the range of the subnet to associate with the primary network interface. You cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified a minimum number of instances to launch.
     *
     * You cannot specify this option and the network interfaces option in the same request.
     */
    public val ipv6Addresses: List<InstanceIpv6Address>? = builder.ipv6Addresses
    /**
     * The ID of the kernel.
     *
     * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see [PV-GRUB](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html) in the *Amazon EC2 User Guide*.
     */
    public val kernelId: kotlin.String? = builder.kernelId
    /**
     * The name of the key pair. You can create a key pair using [CreateKeyPair](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html) or [ImportKeyPair](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html).
     *
     * If you do not specify a key pair, you can't connect to the instance unless you choose an AMI that is configured to allow users another way to log in.
     */
    public val keyName: kotlin.String? = builder.keyName
    /**
     * The launch template to use to launch the instances. Any parameters that you specify in RunInstances override the same parameters in the launch template. You can specify either the name or ID of a launch template, but not both.
     */
    public val launchTemplate: aws.sdk.kotlin.services.ec2.model.LaunchTemplateSpecification? = builder.launchTemplate
    /**
     * The license configurations.
     */
    public val licenseSpecifications: List<LicenseConfigurationRequest>? = builder.licenseSpecifications
    /**
     * The maintenance and recovery options for the instance.
     */
    public val maintenanceOptions: aws.sdk.kotlin.services.ec2.model.InstanceMaintenanceOptionsRequest? = builder.maintenanceOptions
    /**
     * The maximum number of instances to launch. If you specify more instances than Amazon EC2 can launch in the target Availability Zone, Amazon EC2 launches the largest possible number of instances above `MinCount`.
     *
     * Constraints: Between 1 and the maximum number you're allowed for the specified instance type. For more information about the default limits, and how to request an increase, see [How many instances can I run in Amazon EC2](http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2) in the Amazon EC2 FAQ.
     */
    public val maxCount: kotlin.Int? = builder.maxCount
    /**
     * The metadata options for the instance. For more information, see [Instance metadata and user data](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html).
     */
    public val metadataOptions: aws.sdk.kotlin.services.ec2.model.InstanceMetadataOptionsRequest? = builder.metadataOptions
    /**
     * The minimum number of instances to launch. If you specify a minimum that is more instances than Amazon EC2 can launch in the target Availability Zone, Amazon EC2 launches no instances.
     *
     * Constraints: Between 1 and the maximum number you're allowed for the specified instance type. For more information about the default limits, and how to request an increase, see [How many instances can I run in Amazon EC2](http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2) in the Amazon EC2 General FAQ.
     */
    public val minCount: kotlin.Int? = builder.minCount
    /**
     * Specifies whether detailed monitoring is enabled for the instance.
     */
    public val monitoring: aws.sdk.kotlin.services.ec2.model.RunInstancesMonitoringEnabled? = builder.monitoring
    /**
     * The network interfaces to associate with the instance. If you specify a network interface, you must specify any security groups and subnets as part of the network interface.
     */
    public val networkInterfaces: List<InstanceNetworkInterfaceSpecification>? = builder.networkInterfaces
    /**
     * The placement for the instance.
     */
    public val placement: aws.sdk.kotlin.services.ec2.model.Placement? = builder.placement
    /**
     * The options for the instance hostname. The default values are inherited from the subnet.
     */
    public val privateDnsNameOptions: aws.sdk.kotlin.services.ec2.model.PrivateDnsNameOptionsRequest? = builder.privateDnsNameOptions
    /**
     * &#91;EC2-VPC&#93; The primary IPv4 address. You must specify a value from the IPv4 address range of the subnet.
     *
     * Only one private IP address can be designated as primary. You can't specify this option if you've specified the option to designate a private IP address as the primary IP address in a network interface specification. You cannot specify this option if you're launching more than one instance in the request.
     *
     * You cannot specify this option and the network interfaces option in the same request.
     */
    public val privateIpAddress: kotlin.String? = builder.privateIpAddress
    /**
     * The ID of the RAM disk to select. Some kernels require additional drivers at launch. Check the kernel requirements for information about whether you need to specify a RAM disk. To find kernel requirements, go to the Amazon Web Services Resource Center and search for the kernel ID.
     *
     * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see [PV-GRUB](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html) in the *Amazon EC2 User Guide*.
     */
    public val ramdiskId: kotlin.String? = builder.ramdiskId
    /**
     * The IDs of the security groups. You can create a security group using [CreateSecurityGroup](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html).
     *
     * If you specify a network interface, you must specify any security groups as part of the network interface.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * &#91;EC2-Classic, default VPC&#93; The names of the security groups. For a nondefault VPC, you must use security group IDs instead.
     *
     * If you specify a network interface, you must specify any security groups as part of the network interface.
     *
     * Default: Amazon EC2 uses the default security group.
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * &#91;EC2-VPC&#93; The ID of the subnet to launch the instance into.
     *
     * If you specify a network interface, you must specify any subnets as part of the network interface.
     */
    public val subnetId: kotlin.String? = builder.subnetId
    /**
     * The tags to apply to the resources that are created during instance launch.
     *
     * You can specify tags for the following resources only:
     * + Instances
     * + Volumes
     * + Elastic graphics
     * + Spot Instance requests
     * + Network interfaces
     *
     * To tag a resource after it has been created, see [CreateTags](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html).
     */
    public val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * The user data script to make available to the instance. For more information, see [Run commands on your Linux instance at launch](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html) and [Run commands on your Windows instance at launch](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-windows-user-data.html). If you are using a command line tool, base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide base64-encoded text. User data is limited to 16 KB.
     */
    public val userData: kotlin.String? = builder.userData

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.RunInstancesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RunInstancesRequest(")
        append("additionalInfo=$additionalInfo,")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("capacityReservationSpecification=$capacityReservationSpecification,")
        append("clientToken=$clientToken,")
        append("cpuOptions=$cpuOptions,")
        append("creditSpecification=$creditSpecification,")
        append("disableApiStop=$disableApiStop,")
        append("disableApiTermination=$disableApiTermination,")
        append("dryRun=$dryRun,")
        append("ebsOptimized=$ebsOptimized,")
        append("elasticGpuSpecification=$elasticGpuSpecification,")
        append("elasticInferenceAccelerators=$elasticInferenceAccelerators,")
        append("enclaveOptions=$enclaveOptions,")
        append("hibernationOptions=$hibernationOptions,")
        append("iamInstanceProfile=$iamInstanceProfile,")
        append("imageId=$imageId,")
        append("instanceInitiatedShutdownBehavior=$instanceInitiatedShutdownBehavior,")
        append("instanceMarketOptions=$instanceMarketOptions,")
        append("instanceType=$instanceType,")
        append("ipv6AddressCount=$ipv6AddressCount,")
        append("ipv6Addresses=$ipv6Addresses,")
        append("kernelId=$kernelId,")
        append("keyName=$keyName,")
        append("launchTemplate=$launchTemplate,")
        append("licenseSpecifications=$licenseSpecifications,")
        append("maintenanceOptions=$maintenanceOptions,")
        append("maxCount=$maxCount,")
        append("metadataOptions=$metadataOptions,")
        append("minCount=$minCount,")
        append("monitoring=$monitoring,")
        append("networkInterfaces=$networkInterfaces,")
        append("placement=$placement,")
        append("privateDnsNameOptions=$privateDnsNameOptions,")
        append("privateIpAddress=$privateIpAddress,")
        append("ramdiskId=$ramdiskId,")
        append("securityGroupIds=$securityGroupIds,")
        append("securityGroups=$securityGroups,")
        append("subnetId=$subnetId,")
        append("tagSpecifications=$tagSpecifications,")
        append("userData=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalInfo?.hashCode() ?: 0
        result = 31 * result + (blockDeviceMappings?.hashCode() ?: 0)
        result = 31 * result + (capacityReservationSpecification?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (cpuOptions?.hashCode() ?: 0)
        result = 31 * result + (creditSpecification?.hashCode() ?: 0)
        result = 31 * result + (disableApiStop?.hashCode() ?: 0)
        result = 31 * result + (disableApiTermination?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (ebsOptimized?.hashCode() ?: 0)
        result = 31 * result + (elasticGpuSpecification?.hashCode() ?: 0)
        result = 31 * result + (elasticInferenceAccelerators?.hashCode() ?: 0)
        result = 31 * result + (enclaveOptions?.hashCode() ?: 0)
        result = 31 * result + (hibernationOptions?.hashCode() ?: 0)
        result = 31 * result + (iamInstanceProfile?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (instanceInitiatedShutdownBehavior?.hashCode() ?: 0)
        result = 31 * result + (instanceMarketOptions?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (ipv6AddressCount ?: 0)
        result = 31 * result + (ipv6Addresses?.hashCode() ?: 0)
        result = 31 * result + (kernelId?.hashCode() ?: 0)
        result = 31 * result + (keyName?.hashCode() ?: 0)
        result = 31 * result + (launchTemplate?.hashCode() ?: 0)
        result = 31 * result + (licenseSpecifications?.hashCode() ?: 0)
        result = 31 * result + (maintenanceOptions?.hashCode() ?: 0)
        result = 31 * result + (maxCount ?: 0)
        result = 31 * result + (metadataOptions?.hashCode() ?: 0)
        result = 31 * result + (minCount ?: 0)
        result = 31 * result + (monitoring?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaces?.hashCode() ?: 0)
        result = 31 * result + (placement?.hashCode() ?: 0)
        result = 31 * result + (privateDnsNameOptions?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddress?.hashCode() ?: 0)
        result = 31 * result + (ramdiskId?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (userData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RunInstancesRequest

        if (additionalInfo != other.additionalInfo) return false
        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (capacityReservationSpecification != other.capacityReservationSpecification) return false
        if (clientToken != other.clientToken) return false
        if (cpuOptions != other.cpuOptions) return false
        if (creditSpecification != other.creditSpecification) return false
        if (disableApiStop != other.disableApiStop) return false
        if (disableApiTermination != other.disableApiTermination) return false
        if (dryRun != other.dryRun) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (elasticGpuSpecification != other.elasticGpuSpecification) return false
        if (elasticInferenceAccelerators != other.elasticInferenceAccelerators) return false
        if (enclaveOptions != other.enclaveOptions) return false
        if (hibernationOptions != other.hibernationOptions) return false
        if (iamInstanceProfile != other.iamInstanceProfile) return false
        if (imageId != other.imageId) return false
        if (instanceInitiatedShutdownBehavior != other.instanceInitiatedShutdownBehavior) return false
        if (instanceMarketOptions != other.instanceMarketOptions) return false
        if (instanceType != other.instanceType) return false
        if (ipv6AddressCount != other.ipv6AddressCount) return false
        if (ipv6Addresses != other.ipv6Addresses) return false
        if (kernelId != other.kernelId) return false
        if (keyName != other.keyName) return false
        if (launchTemplate != other.launchTemplate) return false
        if (licenseSpecifications != other.licenseSpecifications) return false
        if (maintenanceOptions != other.maintenanceOptions) return false
        if (maxCount != other.maxCount) return false
        if (metadataOptions != other.metadataOptions) return false
        if (minCount != other.minCount) return false
        if (monitoring != other.monitoring) return false
        if (networkInterfaces != other.networkInterfaces) return false
        if (placement != other.placement) return false
        if (privateDnsNameOptions != other.privateDnsNameOptions) return false
        if (privateIpAddress != other.privateIpAddress) return false
        if (ramdiskId != other.ramdiskId) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (securityGroups != other.securityGroups) return false
        if (subnetId != other.subnetId) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (userData != other.userData) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.RunInstancesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Reserved.
         */
        public var additionalInfo: kotlin.String? = null
        /**
         * The block device mapping, which defines the EBS volumes and instance store volumes to attach to the instance at launch. For more information, see [Block device mappings](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html) in the *Amazon EC2 User Guide*.
         */
        public var blockDeviceMappings: List<BlockDeviceMapping>? = null
        /**
         * Information about the Capacity Reservation targeting option. If you do not specify this parameter, the instance's Capacity Reservation preference defaults to `open`, which enables it to run in any open Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).
         */
        public var capacityReservationSpecification: aws.sdk.kotlin.services.ec2.model.CapacityReservationSpecification? = null
        /**
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not specify a client token, a randomly generated token is used for the request to ensure idempotency.
         *
         * For more information, see [Ensuring Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
         *
         * Constraints: Maximum 64 ASCII characters
         */
        public var clientToken: kotlin.String? = null
        /**
         * The CPU options for the instance. For more information, see [Optimize CPU options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) in the *Amazon EC2 User Guide*.
         */
        public var cpuOptions: aws.sdk.kotlin.services.ec2.model.CpuOptionsRequest? = null
        /**
         * The credit option for CPU usage of the burstable performance instance. Valid values are `standard` and `unlimited`. To change this attribute after launch, use [ ModifyInstanceCreditSpecification](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceCreditSpecification.html). For more information, see [Burstable performance instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html) in the *Amazon EC2 User Guide*.
         *
         * Default: `standard` (T2 instances) or `unlimited` (T3/T3a/T4g instances)
         *
         * For T3 instances with `host` tenancy, only `standard` is supported.
         */
        public var creditSpecification: aws.sdk.kotlin.services.ec2.model.CreditSpecificationRequest? = null
        /**
         * Indicates whether an instance is enabled for stop protection. For more information, see [Stop protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
         */
        public var disableApiStop: kotlin.Boolean? = null
        /**
         * If you set this parameter to `true`, you can't terminate the instance using the Amazon EC2 console, CLI, or API; otherwise, you can. To change this attribute after launch, use [ModifyInstanceAttribute](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html). Alternatively, if you set `InstanceInitiatedShutdownBehavior` to `terminate`, you can terminate the instance by running the shutdown command from the instance.
         *
         * Default: `false`
         */
        public var disableApiTermination: kotlin.Boolean? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
         *
         * Default: `false`
         */
        public var ebsOptimized: kotlin.Boolean? = null
        /**
         * An elastic GPU to associate with the instance. An Elastic GPU is a GPU resource that you can attach to your Windows instance to accelerate the graphics performance of your applications. For more information, see [Amazon EC2 Elastic GPUs](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html) in the *Amazon EC2 User Guide*.
         */
        public var elasticGpuSpecification: List<ElasticGpuSpecification>? = null
        /**
         * An elastic inference accelerator to associate with the instance. Elastic inference accelerators are a resource you can attach to your Amazon EC2 instances to accelerate your Deep Learning (DL) inference workloads.
         *
         * You cannot specify accelerators from different generations in the same request.
         */
        public var elasticInferenceAccelerators: List<ElasticInferenceAccelerator>? = null
        /**
         * Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves. For more information, see [ What is Amazon Web Services Nitro Enclaves?](https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html) in the *Amazon Web Services Nitro Enclaves User Guide*.
         *
         * You can't enable Amazon Web Services Nitro Enclaves and hibernation on the same instance.
         */
        public var enclaveOptions: aws.sdk.kotlin.services.ec2.model.EnclaveOptionsRequest? = null
        /**
         * Indicates whether an instance is enabled for hibernation. For more information, see [Hibernate your instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html) in the *Amazon EC2 User Guide*.
         *
         * You can't enable hibernation and Amazon Web Services Nitro Enclaves on the same instance.
         */
        public var hibernationOptions: aws.sdk.kotlin.services.ec2.model.HibernationOptionsRequest? = null
        /**
         * The name or Amazon Resource Name (ARN) of an IAM instance profile.
         */
        public var iamInstanceProfile: aws.sdk.kotlin.services.ec2.model.IamInstanceProfileSpecification? = null
        /**
         * The ID of the AMI. An AMI ID is required to launch an instance and must be specified here or in a launch template.
         */
        public var imageId: kotlin.String? = null
        /**
         * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
         *
         * Default: `stop`
         */
        public var instanceInitiatedShutdownBehavior: aws.sdk.kotlin.services.ec2.model.ShutdownBehavior? = null
        /**
         * The market (purchasing) option for the instances.
         *
         * For RunInstances, persistent Spot Instance requests are only supported when **InstanceInterruptionBehavior** is set to either `hibernate` or `stop`.
         */
        public var instanceMarketOptions: aws.sdk.kotlin.services.ec2.model.InstanceMarketOptionsRequest? = null
        /**
         * The instance type. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon EC2 User Guide*.
         *
         * Default: `m1.small`
         */
        public var instanceType: aws.sdk.kotlin.services.ec2.model.InstanceType? = null
        /**
         * &#91;EC2-VPC&#93; The number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet. You cannot specify this option and the option to assign specific IPv6 addresses in the same request. You can specify this option if you've specified a minimum number of instances to launch.
         *
         * You cannot specify this option and the network interfaces option in the same request.
         */
        public var ipv6AddressCount: kotlin.Int? = null
        /**
         * &#91;EC2-VPC&#93; The IPv6 addresses from the range of the subnet to associate with the primary network interface. You cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified a minimum number of instances to launch.
         *
         * You cannot specify this option and the network interfaces option in the same request.
         */
        public var ipv6Addresses: List<InstanceIpv6Address>? = null
        /**
         * The ID of the kernel.
         *
         * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see [PV-GRUB](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html) in the *Amazon EC2 User Guide*.
         */
        public var kernelId: kotlin.String? = null
        /**
         * The name of the key pair. You can create a key pair using [CreateKeyPair](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html) or [ImportKeyPair](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html).
         *
         * If you do not specify a key pair, you can't connect to the instance unless you choose an AMI that is configured to allow users another way to log in.
         */
        public var keyName: kotlin.String? = null
        /**
         * The launch template to use to launch the instances. Any parameters that you specify in RunInstances override the same parameters in the launch template. You can specify either the name or ID of a launch template, but not both.
         */
        public var launchTemplate: aws.sdk.kotlin.services.ec2.model.LaunchTemplateSpecification? = null
        /**
         * The license configurations.
         */
        public var licenseSpecifications: List<LicenseConfigurationRequest>? = null
        /**
         * The maintenance and recovery options for the instance.
         */
        public var maintenanceOptions: aws.sdk.kotlin.services.ec2.model.InstanceMaintenanceOptionsRequest? = null
        /**
         * The maximum number of instances to launch. If you specify more instances than Amazon EC2 can launch in the target Availability Zone, Amazon EC2 launches the largest possible number of instances above `MinCount`.
         *
         * Constraints: Between 1 and the maximum number you're allowed for the specified instance type. For more information about the default limits, and how to request an increase, see [How many instances can I run in Amazon EC2](http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2) in the Amazon EC2 FAQ.
         */
        public var maxCount: kotlin.Int? = null
        /**
         * The metadata options for the instance. For more information, see [Instance metadata and user data](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html).
         */
        public var metadataOptions: aws.sdk.kotlin.services.ec2.model.InstanceMetadataOptionsRequest? = null
        /**
         * The minimum number of instances to launch. If you specify a minimum that is more instances than Amazon EC2 can launch in the target Availability Zone, Amazon EC2 launches no instances.
         *
         * Constraints: Between 1 and the maximum number you're allowed for the specified instance type. For more information about the default limits, and how to request an increase, see [How many instances can I run in Amazon EC2](http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2) in the Amazon EC2 General FAQ.
         */
        public var minCount: kotlin.Int? = null
        /**
         * Specifies whether detailed monitoring is enabled for the instance.
         */
        public var monitoring: aws.sdk.kotlin.services.ec2.model.RunInstancesMonitoringEnabled? = null
        /**
         * The network interfaces to associate with the instance. If you specify a network interface, you must specify any security groups and subnets as part of the network interface.
         */
        public var networkInterfaces: List<InstanceNetworkInterfaceSpecification>? = null
        /**
         * The placement for the instance.
         */
        public var placement: aws.sdk.kotlin.services.ec2.model.Placement? = null
        /**
         * The options for the instance hostname. The default values are inherited from the subnet.
         */
        public var privateDnsNameOptions: aws.sdk.kotlin.services.ec2.model.PrivateDnsNameOptionsRequest? = null
        /**
         * &#91;EC2-VPC&#93; The primary IPv4 address. You must specify a value from the IPv4 address range of the subnet.
         *
         * Only one private IP address can be designated as primary. You can't specify this option if you've specified the option to designate a private IP address as the primary IP address in a network interface specification. You cannot specify this option if you're launching more than one instance in the request.
         *
         * You cannot specify this option and the network interfaces option in the same request.
         */
        public var privateIpAddress: kotlin.String? = null
        /**
         * The ID of the RAM disk to select. Some kernels require additional drivers at launch. Check the kernel requirements for information about whether you need to specify a RAM disk. To find kernel requirements, go to the Amazon Web Services Resource Center and search for the kernel ID.
         *
         * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see [PV-GRUB](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html) in the *Amazon EC2 User Guide*.
         */
        public var ramdiskId: kotlin.String? = null
        /**
         * The IDs of the security groups. You can create a security group using [CreateSecurityGroup](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html).
         *
         * If you specify a network interface, you must specify any security groups as part of the network interface.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * &#91;EC2-Classic, default VPC&#93; The names of the security groups. For a nondefault VPC, you must use security group IDs instead.
         *
         * If you specify a network interface, you must specify any security groups as part of the network interface.
         *
         * Default: Amazon EC2 uses the default security group.
         */
        public var securityGroups: List<String>? = null
        /**
         * &#91;EC2-VPC&#93; The ID of the subnet to launch the instance into.
         *
         * If you specify a network interface, you must specify any subnets as part of the network interface.
         */
        public var subnetId: kotlin.String? = null
        /**
         * The tags to apply to the resources that are created during instance launch.
         *
         * You can specify tags for the following resources only:
         * + Instances
         * + Volumes
         * + Elastic graphics
         * + Spot Instance requests
         * + Network interfaces
         *
         * To tag a resource after it has been created, see [CreateTags](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html).
         */
        public var tagSpecifications: List<TagSpecification>? = null
        /**
         * The user data script to make available to the instance. For more information, see [Run commands on your Linux instance at launch](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html) and [Run commands on your Windows instance at launch](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-windows-user-data.html). If you are using a command line tool, base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide base64-encoded text. User data is limited to 16 KB.
         */
        public var userData: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.RunInstancesRequest) : this() {
            this.additionalInfo = x.additionalInfo
            this.blockDeviceMappings = x.blockDeviceMappings
            this.capacityReservationSpecification = x.capacityReservationSpecification
            this.clientToken = x.clientToken
            this.cpuOptions = x.cpuOptions
            this.creditSpecification = x.creditSpecification
            this.disableApiStop = x.disableApiStop
            this.disableApiTermination = x.disableApiTermination
            this.dryRun = x.dryRun
            this.ebsOptimized = x.ebsOptimized
            this.elasticGpuSpecification = x.elasticGpuSpecification
            this.elasticInferenceAccelerators = x.elasticInferenceAccelerators
            this.enclaveOptions = x.enclaveOptions
            this.hibernationOptions = x.hibernationOptions
            this.iamInstanceProfile = x.iamInstanceProfile
            this.imageId = x.imageId
            this.instanceInitiatedShutdownBehavior = x.instanceInitiatedShutdownBehavior
            this.instanceMarketOptions = x.instanceMarketOptions
            this.instanceType = x.instanceType
            this.ipv6AddressCount = x.ipv6AddressCount
            this.ipv6Addresses = x.ipv6Addresses
            this.kernelId = x.kernelId
            this.keyName = x.keyName
            this.launchTemplate = x.launchTemplate
            this.licenseSpecifications = x.licenseSpecifications
            this.maintenanceOptions = x.maintenanceOptions
            this.maxCount = x.maxCount
            this.metadataOptions = x.metadataOptions
            this.minCount = x.minCount
            this.monitoring = x.monitoring
            this.networkInterfaces = x.networkInterfaces
            this.placement = x.placement
            this.privateDnsNameOptions = x.privateDnsNameOptions
            this.privateIpAddress = x.privateIpAddress
            this.ramdiskId = x.ramdiskId
            this.securityGroupIds = x.securityGroupIds
            this.securityGroups = x.securityGroups
            this.subnetId = x.subnetId
            this.tagSpecifications = x.tagSpecifications
            this.userData = x.userData
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.RunInstancesRequest = RunInstancesRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.CapacityReservationSpecification] inside the given [block]
         */
        public fun capacityReservationSpecification(block: aws.sdk.kotlin.services.ec2.model.CapacityReservationSpecification.Builder.() -> kotlin.Unit) {
            this.capacityReservationSpecification = aws.sdk.kotlin.services.ec2.model.CapacityReservationSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.CpuOptionsRequest] inside the given [block]
         */
        public fun cpuOptions(block: aws.sdk.kotlin.services.ec2.model.CpuOptionsRequest.Builder.() -> kotlin.Unit) {
            this.cpuOptions = aws.sdk.kotlin.services.ec2.model.CpuOptionsRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.CreditSpecificationRequest] inside the given [block]
         */
        public fun creditSpecification(block: aws.sdk.kotlin.services.ec2.model.CreditSpecificationRequest.Builder.() -> kotlin.Unit) {
            this.creditSpecification = aws.sdk.kotlin.services.ec2.model.CreditSpecificationRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.EnclaveOptionsRequest] inside the given [block]
         */
        public fun enclaveOptions(block: aws.sdk.kotlin.services.ec2.model.EnclaveOptionsRequest.Builder.() -> kotlin.Unit) {
            this.enclaveOptions = aws.sdk.kotlin.services.ec2.model.EnclaveOptionsRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.HibernationOptionsRequest] inside the given [block]
         */
        public fun hibernationOptions(block: aws.sdk.kotlin.services.ec2.model.HibernationOptionsRequest.Builder.() -> kotlin.Unit) {
            this.hibernationOptions = aws.sdk.kotlin.services.ec2.model.HibernationOptionsRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.IamInstanceProfileSpecification] inside the given [block]
         */
        public fun iamInstanceProfile(block: aws.sdk.kotlin.services.ec2.model.IamInstanceProfileSpecification.Builder.() -> kotlin.Unit) {
            this.iamInstanceProfile = aws.sdk.kotlin.services.ec2.model.IamInstanceProfileSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.InstanceMarketOptionsRequest] inside the given [block]
         */
        public fun instanceMarketOptions(block: aws.sdk.kotlin.services.ec2.model.InstanceMarketOptionsRequest.Builder.() -> kotlin.Unit) {
            this.instanceMarketOptions = aws.sdk.kotlin.services.ec2.model.InstanceMarketOptionsRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateSpecification] inside the given [block]
         */
        public fun launchTemplate(block: aws.sdk.kotlin.services.ec2.model.LaunchTemplateSpecification.Builder.() -> kotlin.Unit) {
            this.launchTemplate = aws.sdk.kotlin.services.ec2.model.LaunchTemplateSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.InstanceMaintenanceOptionsRequest] inside the given [block]
         */
        public fun maintenanceOptions(block: aws.sdk.kotlin.services.ec2.model.InstanceMaintenanceOptionsRequest.Builder.() -> kotlin.Unit) {
            this.maintenanceOptions = aws.sdk.kotlin.services.ec2.model.InstanceMaintenanceOptionsRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.InstanceMetadataOptionsRequest] inside the given [block]
         */
        public fun metadataOptions(block: aws.sdk.kotlin.services.ec2.model.InstanceMetadataOptionsRequest.Builder.() -> kotlin.Unit) {
            this.metadataOptions = aws.sdk.kotlin.services.ec2.model.InstanceMetadataOptionsRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.RunInstancesMonitoringEnabled] inside the given [block]
         */
        public fun monitoring(block: aws.sdk.kotlin.services.ec2.model.RunInstancesMonitoringEnabled.Builder.() -> kotlin.Unit) {
            this.monitoring = aws.sdk.kotlin.services.ec2.model.RunInstancesMonitoringEnabled.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.Placement] inside the given [block]
         */
        public fun placement(block: aws.sdk.kotlin.services.ec2.model.Placement.Builder.() -> kotlin.Unit) {
            this.placement = aws.sdk.kotlin.services.ec2.model.Placement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.PrivateDnsNameOptionsRequest] inside the given [block]
         */
        public fun privateDnsNameOptions(block: aws.sdk.kotlin.services.ec2.model.PrivateDnsNameOptionsRequest.Builder.() -> kotlin.Unit) {
            this.privateDnsNameOptions = aws.sdk.kotlin.services.ec2.model.PrivateDnsNameOptionsRequest.invoke(block)
        }
    }
}
