// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * The information for a launch template.
 */
public class ResponseLaunchTemplateData private constructor(builder: Builder) {
    /**
     * The block device mappings.
     */
    public val blockDeviceMappings: List<LaunchTemplateBlockDeviceMapping>? = builder.blockDeviceMappings
    /**
     * Information about the Capacity Reservation targeting option.
     */
    public val capacityReservationSpecification: aws.sdk.kotlin.services.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse? = builder.capacityReservationSpecification
    /**
     * The CPU options for the instance. For more information, see [Optimizing CPU options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) in the *Amazon Elastic Compute Cloud User Guide*.
     */
    public val cpuOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplateCpuOptions? = builder.cpuOptions
    /**
     * The credit option for CPU usage of the instance.
     */
    public val creditSpecification: aws.sdk.kotlin.services.ec2.model.CreditSpecification? = builder.creditSpecification
    /**
     * Indicates whether the instance is enabled for stop protection. For more information, see [Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
     */
    public val disableApiStop: kotlin.Boolean? = builder.disableApiStop
    /**
     * If set to `true`, indicates that the instance cannot be terminated using the Amazon EC2 console, command line tool, or API.
     */
    public val disableApiTermination: kotlin.Boolean? = builder.disableApiTermination
    /**
     * Indicates whether the instance is optimized for Amazon EBS I/O.
     */
    public val ebsOptimized: kotlin.Boolean? = builder.ebsOptimized
    /**
     * The elastic GPU specification.
     */
    public val elasticGpuSpecifications: List<ElasticGpuSpecificationResponse>? = builder.elasticGpuSpecifications
    /**
     * The elastic inference accelerator for the instance.
     */
    public val elasticInferenceAccelerators: List<LaunchTemplateElasticInferenceAcceleratorResponse>? = builder.elasticInferenceAccelerators
    /**
     * Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves.
     */
    public val enclaveOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplateEnclaveOptions? = builder.enclaveOptions
    /**
     * Indicates whether an instance is configured for hibernation. For more information, see [Hibernate your instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html) in the *Amazon Elastic Compute Cloud User Guide*.
     */
    public val hibernationOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplateHibernationOptions? = builder.hibernationOptions
    /**
     * The IAM instance profile.
     */
    public val iamInstanceProfile: aws.sdk.kotlin.services.ec2.model.LaunchTemplateIamInstanceProfileSpecification? = builder.iamInstanceProfile
    /**
     * The ID of the AMI that was used to launch the instance.
     */
    public val imageId: kotlin.String? = builder.imageId
    /**
     * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
     */
    public val instanceInitiatedShutdownBehavior: aws.sdk.kotlin.services.ec2.model.ShutdownBehavior? = builder.instanceInitiatedShutdownBehavior
    /**
     * The market (purchasing) option for the instances.
     */
    public val instanceMarketOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMarketOptions? = builder.instanceMarketOptions
    /**
     * The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify instance types with these attributes.
     *
     * If you specify `InstanceRequirements`, you can't specify `InstanceTypes`.
     */
    public val instanceRequirements: aws.sdk.kotlin.services.ec2.model.InstanceRequirements? = builder.instanceRequirements
    /**
     * The instance type.
     */
    public val instanceType: aws.sdk.kotlin.services.ec2.model.InstanceType? = builder.instanceType
    /**
     * The ID of the kernel, if applicable.
     */
    public val kernelId: kotlin.String? = builder.kernelId
    /**
     * The name of the key pair.
     */
    public val keyName: kotlin.String? = builder.keyName
    /**
     * The license configurations.
     */
    public val licenseSpecifications: List<LaunchTemplateLicenseConfiguration>? = builder.licenseSpecifications
    /**
     * The maintenance options for your instance.
     */
    public val maintenanceOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMaintenanceOptions? = builder.maintenanceOptions
    /**
     * The metadata options for the instance. For more information, see [Instance metadata and user data](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html) in the *Amazon Elastic Compute Cloud User Guide*.
     */
    public val metadataOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMetadataOptions? = builder.metadataOptions
    /**
     * The monitoring for the instance.
     */
    public val monitoring: aws.sdk.kotlin.services.ec2.model.LaunchTemplatesMonitoring? = builder.monitoring
    /**
     * The network interfaces.
     */
    public val networkInterfaces: List<LaunchTemplateInstanceNetworkInterfaceSpecification>? = builder.networkInterfaces
    /**
     * The placement of the instance.
     */
    public val placement: aws.sdk.kotlin.services.ec2.model.LaunchTemplatePlacement? = builder.placement
    /**
     * The options for the instance hostname.
     */
    public val privateDnsNameOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplatePrivateDnsNameOptions? = builder.privateDnsNameOptions
    /**
     * The ID of the RAM disk, if applicable.
     */
    public val ramDiskId: kotlin.String? = builder.ramDiskId
    /**
     * The security group IDs.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The security group names.
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * The tags that are applied to the resources that are created during instance launch.
     */
    public val tagSpecifications: List<LaunchTemplateTagSpecification>? = builder.tagSpecifications
    /**
     * The user data for the instance.
     */
    public val userData: kotlin.String? = builder.userData

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.ResponseLaunchTemplateData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResponseLaunchTemplateData(")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("capacityReservationSpecification=$capacityReservationSpecification,")
        append("cpuOptions=$cpuOptions,")
        append("creditSpecification=$creditSpecification,")
        append("disableApiStop=$disableApiStop,")
        append("disableApiTermination=$disableApiTermination,")
        append("ebsOptimized=$ebsOptimized,")
        append("elasticGpuSpecifications=$elasticGpuSpecifications,")
        append("elasticInferenceAccelerators=$elasticInferenceAccelerators,")
        append("enclaveOptions=$enclaveOptions,")
        append("hibernationOptions=$hibernationOptions,")
        append("iamInstanceProfile=$iamInstanceProfile,")
        append("imageId=$imageId,")
        append("instanceInitiatedShutdownBehavior=$instanceInitiatedShutdownBehavior,")
        append("instanceMarketOptions=$instanceMarketOptions,")
        append("instanceRequirements=$instanceRequirements,")
        append("instanceType=$instanceType,")
        append("kernelId=$kernelId,")
        append("keyName=$keyName,")
        append("licenseSpecifications=$licenseSpecifications,")
        append("maintenanceOptions=$maintenanceOptions,")
        append("metadataOptions=$metadataOptions,")
        append("monitoring=$monitoring,")
        append("networkInterfaces=$networkInterfaces,")
        append("placement=$placement,")
        append("privateDnsNameOptions=$privateDnsNameOptions,")
        append("ramDiskId=$ramDiskId,")
        append("securityGroupIds=$securityGroupIds,")
        append("securityGroups=$securityGroups,")
        append("tagSpecifications=$tagSpecifications,")
        append("userData=$userData)")
    }

    override fun hashCode(): kotlin.Int {
        var result = blockDeviceMappings?.hashCode() ?: 0
        result = 31 * result + (capacityReservationSpecification?.hashCode() ?: 0)
        result = 31 * result + (cpuOptions?.hashCode() ?: 0)
        result = 31 * result + (creditSpecification?.hashCode() ?: 0)
        result = 31 * result + (disableApiStop?.hashCode() ?: 0)
        result = 31 * result + (disableApiTermination?.hashCode() ?: 0)
        result = 31 * result + (ebsOptimized?.hashCode() ?: 0)
        result = 31 * result + (elasticGpuSpecifications?.hashCode() ?: 0)
        result = 31 * result + (elasticInferenceAccelerators?.hashCode() ?: 0)
        result = 31 * result + (enclaveOptions?.hashCode() ?: 0)
        result = 31 * result + (hibernationOptions?.hashCode() ?: 0)
        result = 31 * result + (iamInstanceProfile?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (instanceInitiatedShutdownBehavior?.hashCode() ?: 0)
        result = 31 * result + (instanceMarketOptions?.hashCode() ?: 0)
        result = 31 * result + (instanceRequirements?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (kernelId?.hashCode() ?: 0)
        result = 31 * result + (keyName?.hashCode() ?: 0)
        result = 31 * result + (licenseSpecifications?.hashCode() ?: 0)
        result = 31 * result + (maintenanceOptions?.hashCode() ?: 0)
        result = 31 * result + (metadataOptions?.hashCode() ?: 0)
        result = 31 * result + (monitoring?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaces?.hashCode() ?: 0)
        result = 31 * result + (placement?.hashCode() ?: 0)
        result = 31 * result + (privateDnsNameOptions?.hashCode() ?: 0)
        result = 31 * result + (ramDiskId?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (userData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResponseLaunchTemplateData

        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (capacityReservationSpecification != other.capacityReservationSpecification) return false
        if (cpuOptions != other.cpuOptions) return false
        if (creditSpecification != other.creditSpecification) return false
        if (disableApiStop != other.disableApiStop) return false
        if (disableApiTermination != other.disableApiTermination) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (elasticGpuSpecifications != other.elasticGpuSpecifications) return false
        if (elasticInferenceAccelerators != other.elasticInferenceAccelerators) return false
        if (enclaveOptions != other.enclaveOptions) return false
        if (hibernationOptions != other.hibernationOptions) return false
        if (iamInstanceProfile != other.iamInstanceProfile) return false
        if (imageId != other.imageId) return false
        if (instanceInitiatedShutdownBehavior != other.instanceInitiatedShutdownBehavior) return false
        if (instanceMarketOptions != other.instanceMarketOptions) return false
        if (instanceRequirements != other.instanceRequirements) return false
        if (instanceType != other.instanceType) return false
        if (kernelId != other.kernelId) return false
        if (keyName != other.keyName) return false
        if (licenseSpecifications != other.licenseSpecifications) return false
        if (maintenanceOptions != other.maintenanceOptions) return false
        if (metadataOptions != other.metadataOptions) return false
        if (monitoring != other.monitoring) return false
        if (networkInterfaces != other.networkInterfaces) return false
        if (placement != other.placement) return false
        if (privateDnsNameOptions != other.privateDnsNameOptions) return false
        if (ramDiskId != other.ramDiskId) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (securityGroups != other.securityGroups) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (userData != other.userData) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.ResponseLaunchTemplateData = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The block device mappings.
         */
        public var blockDeviceMappings: List<LaunchTemplateBlockDeviceMapping>? = null
        /**
         * Information about the Capacity Reservation targeting option.
         */
        public var capacityReservationSpecification: aws.sdk.kotlin.services.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse? = null
        /**
         * The CPU options for the instance. For more information, see [Optimizing CPU options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) in the *Amazon Elastic Compute Cloud User Guide*.
         */
        public var cpuOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplateCpuOptions? = null
        /**
         * The credit option for CPU usage of the instance.
         */
        public var creditSpecification: aws.sdk.kotlin.services.ec2.model.CreditSpecification? = null
        /**
         * Indicates whether the instance is enabled for stop protection. For more information, see [Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
         */
        public var disableApiStop: kotlin.Boolean? = null
        /**
         * If set to `true`, indicates that the instance cannot be terminated using the Amazon EC2 console, command line tool, or API.
         */
        public var disableApiTermination: kotlin.Boolean? = null
        /**
         * Indicates whether the instance is optimized for Amazon EBS I/O.
         */
        public var ebsOptimized: kotlin.Boolean? = null
        /**
         * The elastic GPU specification.
         */
        public var elasticGpuSpecifications: List<ElasticGpuSpecificationResponse>? = null
        /**
         * The elastic inference accelerator for the instance.
         */
        public var elasticInferenceAccelerators: List<LaunchTemplateElasticInferenceAcceleratorResponse>? = null
        /**
         * Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves.
         */
        public var enclaveOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplateEnclaveOptions? = null
        /**
         * Indicates whether an instance is configured for hibernation. For more information, see [Hibernate your instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html) in the *Amazon Elastic Compute Cloud User Guide*.
         */
        public var hibernationOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplateHibernationOptions? = null
        /**
         * The IAM instance profile.
         */
        public var iamInstanceProfile: aws.sdk.kotlin.services.ec2.model.LaunchTemplateIamInstanceProfileSpecification? = null
        /**
         * The ID of the AMI that was used to launch the instance.
         */
        public var imageId: kotlin.String? = null
        /**
         * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
         */
        public var instanceInitiatedShutdownBehavior: aws.sdk.kotlin.services.ec2.model.ShutdownBehavior? = null
        /**
         * The market (purchasing) option for the instances.
         */
        public var instanceMarketOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMarketOptions? = null
        /**
         * The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify instance types with these attributes.
         *
         * If you specify `InstanceRequirements`, you can't specify `InstanceTypes`.
         */
        public var instanceRequirements: aws.sdk.kotlin.services.ec2.model.InstanceRequirements? = null
        /**
         * The instance type.
         */
        public var instanceType: aws.sdk.kotlin.services.ec2.model.InstanceType? = null
        /**
         * The ID of the kernel, if applicable.
         */
        public var kernelId: kotlin.String? = null
        /**
         * The name of the key pair.
         */
        public var keyName: kotlin.String? = null
        /**
         * The license configurations.
         */
        public var licenseSpecifications: List<LaunchTemplateLicenseConfiguration>? = null
        /**
         * The maintenance options for your instance.
         */
        public var maintenanceOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMaintenanceOptions? = null
        /**
         * The metadata options for the instance. For more information, see [Instance metadata and user data](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html) in the *Amazon Elastic Compute Cloud User Guide*.
         */
        public var metadataOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMetadataOptions? = null
        /**
         * The monitoring for the instance.
         */
        public var monitoring: aws.sdk.kotlin.services.ec2.model.LaunchTemplatesMonitoring? = null
        /**
         * The network interfaces.
         */
        public var networkInterfaces: List<LaunchTemplateInstanceNetworkInterfaceSpecification>? = null
        /**
         * The placement of the instance.
         */
        public var placement: aws.sdk.kotlin.services.ec2.model.LaunchTemplatePlacement? = null
        /**
         * The options for the instance hostname.
         */
        public var privateDnsNameOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplatePrivateDnsNameOptions? = null
        /**
         * The ID of the RAM disk, if applicable.
         */
        public var ramDiskId: kotlin.String? = null
        /**
         * The security group IDs.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The security group names.
         */
        public var securityGroups: List<String>? = null
        /**
         * The tags that are applied to the resources that are created during instance launch.
         */
        public var tagSpecifications: List<LaunchTemplateTagSpecification>? = null
        /**
         * The user data for the instance.
         */
        public var userData: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.ResponseLaunchTemplateData) : this() {
            this.blockDeviceMappings = x.blockDeviceMappings
            this.capacityReservationSpecification = x.capacityReservationSpecification
            this.cpuOptions = x.cpuOptions
            this.creditSpecification = x.creditSpecification
            this.disableApiStop = x.disableApiStop
            this.disableApiTermination = x.disableApiTermination
            this.ebsOptimized = x.ebsOptimized
            this.elasticGpuSpecifications = x.elasticGpuSpecifications
            this.elasticInferenceAccelerators = x.elasticInferenceAccelerators
            this.enclaveOptions = x.enclaveOptions
            this.hibernationOptions = x.hibernationOptions
            this.iamInstanceProfile = x.iamInstanceProfile
            this.imageId = x.imageId
            this.instanceInitiatedShutdownBehavior = x.instanceInitiatedShutdownBehavior
            this.instanceMarketOptions = x.instanceMarketOptions
            this.instanceRequirements = x.instanceRequirements
            this.instanceType = x.instanceType
            this.kernelId = x.kernelId
            this.keyName = x.keyName
            this.licenseSpecifications = x.licenseSpecifications
            this.maintenanceOptions = x.maintenanceOptions
            this.metadataOptions = x.metadataOptions
            this.monitoring = x.monitoring
            this.networkInterfaces = x.networkInterfaces
            this.placement = x.placement
            this.privateDnsNameOptions = x.privateDnsNameOptions
            this.ramDiskId = x.ramDiskId
            this.securityGroupIds = x.securityGroupIds
            this.securityGroups = x.securityGroups
            this.tagSpecifications = x.tagSpecifications
            this.userData = x.userData
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.ResponseLaunchTemplateData = ResponseLaunchTemplateData(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse] inside the given [block]
         */
        public fun capacityReservationSpecification(block: aws.sdk.kotlin.services.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse.Builder.() -> kotlin.Unit) {
            this.capacityReservationSpecification = aws.sdk.kotlin.services.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateCpuOptions] inside the given [block]
         */
        public fun cpuOptions(block: aws.sdk.kotlin.services.ec2.model.LaunchTemplateCpuOptions.Builder.() -> kotlin.Unit) {
            this.cpuOptions = aws.sdk.kotlin.services.ec2.model.LaunchTemplateCpuOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.CreditSpecification] inside the given [block]
         */
        public fun creditSpecification(block: aws.sdk.kotlin.services.ec2.model.CreditSpecification.Builder.() -> kotlin.Unit) {
            this.creditSpecification = aws.sdk.kotlin.services.ec2.model.CreditSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateEnclaveOptions] inside the given [block]
         */
        public fun enclaveOptions(block: aws.sdk.kotlin.services.ec2.model.LaunchTemplateEnclaveOptions.Builder.() -> kotlin.Unit) {
            this.enclaveOptions = aws.sdk.kotlin.services.ec2.model.LaunchTemplateEnclaveOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateHibernationOptions] inside the given [block]
         */
        public fun hibernationOptions(block: aws.sdk.kotlin.services.ec2.model.LaunchTemplateHibernationOptions.Builder.() -> kotlin.Unit) {
            this.hibernationOptions = aws.sdk.kotlin.services.ec2.model.LaunchTemplateHibernationOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateIamInstanceProfileSpecification] inside the given [block]
         */
        public fun iamInstanceProfile(block: aws.sdk.kotlin.services.ec2.model.LaunchTemplateIamInstanceProfileSpecification.Builder.() -> kotlin.Unit) {
            this.iamInstanceProfile = aws.sdk.kotlin.services.ec2.model.LaunchTemplateIamInstanceProfileSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMarketOptions] inside the given [block]
         */
        public fun instanceMarketOptions(block: aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMarketOptions.Builder.() -> kotlin.Unit) {
            this.instanceMarketOptions = aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMarketOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.InstanceRequirements] inside the given [block]
         */
        public fun instanceRequirements(block: aws.sdk.kotlin.services.ec2.model.InstanceRequirements.Builder.() -> kotlin.Unit) {
            this.instanceRequirements = aws.sdk.kotlin.services.ec2.model.InstanceRequirements.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMaintenanceOptions] inside the given [block]
         */
        public fun maintenanceOptions(block: aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMaintenanceOptions.Builder.() -> kotlin.Unit) {
            this.maintenanceOptions = aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMaintenanceOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMetadataOptions] inside the given [block]
         */
        public fun metadataOptions(block: aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMetadataOptions.Builder.() -> kotlin.Unit) {
            this.metadataOptions = aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMetadataOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplatesMonitoring] inside the given [block]
         */
        public fun monitoring(block: aws.sdk.kotlin.services.ec2.model.LaunchTemplatesMonitoring.Builder.() -> kotlin.Unit) {
            this.monitoring = aws.sdk.kotlin.services.ec2.model.LaunchTemplatesMonitoring.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplatePlacement] inside the given [block]
         */
        public fun placement(block: aws.sdk.kotlin.services.ec2.model.LaunchTemplatePlacement.Builder.() -> kotlin.Unit) {
            this.placement = aws.sdk.kotlin.services.ec2.model.LaunchTemplatePlacement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplatePrivateDnsNameOptions] inside the given [block]
         */
        public fun privateDnsNameOptions(block: aws.sdk.kotlin.services.ec2.model.LaunchTemplatePrivateDnsNameOptions.Builder.() -> kotlin.Unit) {
            this.privateDnsNameOptions = aws.sdk.kotlin.services.ec2.model.LaunchTemplatePrivateDnsNameOptions.invoke(block)
        }
    }
}
