// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Information about an instance type to use in a Capacity Reservation Fleet.
 */
public class ReservationFleetInstanceSpecification private constructor(builder: Builder) {
    /**
     * The Availability Zone in which the Capacity Reservation Fleet reserves the capacity. A Capacity Reservation Fleet can't span Availability Zones. All instance type specifications that you specify for the Fleet must use the same Availability Zone.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The ID of the Availability Zone in which the Capacity Reservation Fleet reserves the capacity. A Capacity Reservation Fleet can't span Availability Zones. All instance type specifications that you specify for the Fleet must use the same Availability Zone.
     */
    public val availabilityZoneId: kotlin.String? = builder.availabilityZoneId
    /**
     * Indicates whether the Capacity Reservation Fleet supports EBS-optimized instances types. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using EBS-optimized instance types.
     */
    public val ebsOptimized: kotlin.Boolean? = builder.ebsOptimized
    /**
     * The type of operating system for which the Capacity Reservation Fleet reserves capacity.
     */
    public val instancePlatform: aws.sdk.kotlin.services.ec2.model.CapacityReservationInstancePlatform? = builder.instancePlatform
    /**
     * The instance type for which the Capacity Reservation Fleet reserves capacity.
     */
    public val instanceType: aws.sdk.kotlin.services.ec2.model.InstanceType? = builder.instanceType
    /**
     * The priority to assign to the instance type. This value is used to determine which of the instance types specified for the Fleet should be prioritized for use. A lower value indicates a high priority. For more information, see [Instance type priority](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#instance-priority) in the Amazon EC2 User Guide.
     */
    public val priority: kotlin.Int? = builder.priority
    /**
     * The number of capacity units provided by the specified instance type. This value, together with the total target capacity that you specify for the Fleet determine the number of instances for which the Fleet reserves capacity. Both values are based on units that make sense for your workload. For more information, see [Total target capacity](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity) in the Amazon EC2 User Guide.
     */
    public val weight: kotlin.Double? = builder.weight

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.ReservationFleetInstanceSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReservationFleetInstanceSpecification(")
        append("availabilityZone=$availabilityZone,")
        append("availabilityZoneId=$availabilityZoneId,")
        append("ebsOptimized=$ebsOptimized,")
        append("instancePlatform=$instancePlatform,")
        append("instanceType=$instanceType,")
        append("priority=$priority,")
        append("weight=$weight)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (availabilityZoneId?.hashCode() ?: 0)
        result = 31 * result + (ebsOptimized?.hashCode() ?: 0)
        result = 31 * result + (instancePlatform?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (weight?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReservationFleetInstanceSpecification

        if (availabilityZone != other.availabilityZone) return false
        if (availabilityZoneId != other.availabilityZoneId) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (instancePlatform != other.instancePlatform) return false
        if (instanceType != other.instanceType) return false
        if (priority != other.priority) return false
        if (weight != other.weight) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.ReservationFleetInstanceSpecification = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Availability Zone in which the Capacity Reservation Fleet reserves the capacity. A Capacity Reservation Fleet can't span Availability Zones. All instance type specifications that you specify for the Fleet must use the same Availability Zone.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The ID of the Availability Zone in which the Capacity Reservation Fleet reserves the capacity. A Capacity Reservation Fleet can't span Availability Zones. All instance type specifications that you specify for the Fleet must use the same Availability Zone.
         */
        public var availabilityZoneId: kotlin.String? = null
        /**
         * Indicates whether the Capacity Reservation Fleet supports EBS-optimized instances types. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using EBS-optimized instance types.
         */
        public var ebsOptimized: kotlin.Boolean? = null
        /**
         * The type of operating system for which the Capacity Reservation Fleet reserves capacity.
         */
        public var instancePlatform: aws.sdk.kotlin.services.ec2.model.CapacityReservationInstancePlatform? = null
        /**
         * The instance type for which the Capacity Reservation Fleet reserves capacity.
         */
        public var instanceType: aws.sdk.kotlin.services.ec2.model.InstanceType? = null
        /**
         * The priority to assign to the instance type. This value is used to determine which of the instance types specified for the Fleet should be prioritized for use. A lower value indicates a high priority. For more information, see [Instance type priority](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#instance-priority) in the Amazon EC2 User Guide.
         */
        public var priority: kotlin.Int? = null
        /**
         * The number of capacity units provided by the specified instance type. This value, together with the total target capacity that you specify for the Fleet determine the number of instances for which the Fleet reserves capacity. Both values are based on units that make sense for your workload. For more information, see [Total target capacity](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity) in the Amazon EC2 User Guide.
         */
        public var weight: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.ReservationFleetInstanceSpecification) : this() {
            this.availabilityZone = x.availabilityZone
            this.availabilityZoneId = x.availabilityZoneId
            this.ebsOptimized = x.ebsOptimized
            this.instancePlatform = x.instancePlatform
            this.instanceType = x.instanceType
            this.priority = x.priority
            this.weight = x.weight
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.ReservationFleetInstanceSpecification = ReservationFleetInstanceSpecification(this)
    }
}
