// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Information about a root volume replacement task.
 */
public class ReplaceRootVolumeTask private constructor(builder: Builder) {
    /**
     * The time the task completed.
     */
    public val completeTime: kotlin.String? = builder.completeTime
    /**
     * Indicates whether the original root volume is to be deleted after the root volume replacement task completes.
     */
    public val deleteReplacedRootVolume: kotlin.Boolean? = builder.deleteReplacedRootVolume
    /**
     * The ID of the AMI used to create the replacement root volume.
     */
    public val imageId: kotlin.String? = builder.imageId
    /**
     * The ID of the instance for which the root volume replacement task was created.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The ID of the root volume replacement task.
     */
    public val replaceRootVolumeTaskId: kotlin.String? = builder.replaceRootVolumeTaskId
    /**
     * The ID of the snapshot used to create the replacement root volume.
     */
    public val snapshotId: kotlin.String? = builder.snapshotId
    /**
     * The time the task was started.
     */
    public val startTime: kotlin.String? = builder.startTime
    /**
     * The tags assigned to the task.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The state of the task. The task can be in one of the following states:
     * + `pending` - the replacement volume is being created.
     * + `in-progress` - the original volume is being detached and the replacement volume is being attached.
     * + `succeeded` - the replacement volume has been successfully attached to the instance and the instance is available.
     * + `failing` - the replacement task is in the process of failing.
     * + `failed` - the replacement task has failed but the original root volume is still attached.
     * + `failing-detached` - the replacement task is in the process of failing. The instance might have no root volume attached.
     * + `failed-detached` - the replacement task has failed and the instance has no root volume attached.
     */
    public val taskState: aws.sdk.kotlin.services.ec2.model.ReplaceRootVolumeTaskState? = builder.taskState

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.ReplaceRootVolumeTask = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplaceRootVolumeTask(")
        append("completeTime=$completeTime,")
        append("deleteReplacedRootVolume=$deleteReplacedRootVolume,")
        append("imageId=$imageId,")
        append("instanceId=$instanceId,")
        append("replaceRootVolumeTaskId=$replaceRootVolumeTaskId,")
        append("snapshotId=$snapshotId,")
        append("startTime=$startTime,")
        append("tags=$tags,")
        append("taskState=$taskState)")
    }

    override fun hashCode(): kotlin.Int {
        var result = completeTime?.hashCode() ?: 0
        result = 31 * result + (deleteReplacedRootVolume?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (replaceRootVolumeTaskId?.hashCode() ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (taskState?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplaceRootVolumeTask

        if (completeTime != other.completeTime) return false
        if (deleteReplacedRootVolume != other.deleteReplacedRootVolume) return false
        if (imageId != other.imageId) return false
        if (instanceId != other.instanceId) return false
        if (replaceRootVolumeTaskId != other.replaceRootVolumeTaskId) return false
        if (snapshotId != other.snapshotId) return false
        if (startTime != other.startTime) return false
        if (tags != other.tags) return false
        if (taskState != other.taskState) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.ReplaceRootVolumeTask = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time the task completed.
         */
        public var completeTime: kotlin.String? = null
        /**
         * Indicates whether the original root volume is to be deleted after the root volume replacement task completes.
         */
        public var deleteReplacedRootVolume: kotlin.Boolean? = null
        /**
         * The ID of the AMI used to create the replacement root volume.
         */
        public var imageId: kotlin.String? = null
        /**
         * The ID of the instance for which the root volume replacement task was created.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The ID of the root volume replacement task.
         */
        public var replaceRootVolumeTaskId: kotlin.String? = null
        /**
         * The ID of the snapshot used to create the replacement root volume.
         */
        public var snapshotId: kotlin.String? = null
        /**
         * The time the task was started.
         */
        public var startTime: kotlin.String? = null
        /**
         * The tags assigned to the task.
         */
        public var tags: List<Tag>? = null
        /**
         * The state of the task. The task can be in one of the following states:
         * + `pending` - the replacement volume is being created.
         * + `in-progress` - the original volume is being detached and the replacement volume is being attached.
         * + `succeeded` - the replacement volume has been successfully attached to the instance and the instance is available.
         * + `failing` - the replacement task is in the process of failing.
         * + `failed` - the replacement task has failed but the original root volume is still attached.
         * + `failing-detached` - the replacement task is in the process of failing. The instance might have no root volume attached.
         * + `failed-detached` - the replacement task has failed and the instance has no root volume attached.
         */
        public var taskState: aws.sdk.kotlin.services.ec2.model.ReplaceRootVolumeTaskState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.ReplaceRootVolumeTask) : this() {
            this.completeTime = x.completeTime
            this.deleteReplacedRootVolume = x.deleteReplacedRootVolume
            this.imageId = x.imageId
            this.instanceId = x.instanceId
            this.replaceRootVolumeTaskId = x.replaceRootVolumeTaskId
            this.snapshotId = x.snapshotId
            this.startTime = x.startTime
            this.tags = x.tags
            this.taskState = x.taskState
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.ReplaceRootVolumeTask = ReplaceRootVolumeTask(this)
    }
}
