// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes association information for an Elastic IP address (IPv4 only), or a Carrier IP address (for a network interface which resides in a subnet in a Wavelength Zone).
 */
public class NetworkInterfaceAssociation private constructor(builder: Builder) {
    /**
     * The allocation ID.
     */
    public val allocationId: kotlin.String? = builder.allocationId
    /**
     * The association ID.
     */
    public val associationId: kotlin.String? = builder.associationId
    /**
     * The carrier IP address associated with the network interface.
     *
     * This option is only available when the network interface is in a subnet which is associated with a Wavelength Zone.
     */
    public val carrierIp: kotlin.String? = builder.carrierIp
    /**
     * The customer-owned IP address associated with the network interface.
     */
    public val customerOwnedIp: kotlin.String? = builder.customerOwnedIp
    /**
     * The ID of the Elastic IP address owner.
     */
    public val ipOwnerId: kotlin.String? = builder.ipOwnerId
    /**
     * The public DNS name.
     */
    public val publicDnsName: kotlin.String? = builder.publicDnsName
    /**
     * The address of the Elastic IP address bound to the network interface.
     */
    public val publicIp: kotlin.String? = builder.publicIp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.NetworkInterfaceAssociation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkInterfaceAssociation(")
        append("allocationId=$allocationId,")
        append("associationId=$associationId,")
        append("carrierIp=$carrierIp,")
        append("customerOwnedIp=$customerOwnedIp,")
        append("ipOwnerId=$ipOwnerId,")
        append("publicDnsName=$publicDnsName,")
        append("publicIp=$publicIp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocationId?.hashCode() ?: 0
        result = 31 * result + (associationId?.hashCode() ?: 0)
        result = 31 * result + (carrierIp?.hashCode() ?: 0)
        result = 31 * result + (customerOwnedIp?.hashCode() ?: 0)
        result = 31 * result + (ipOwnerId?.hashCode() ?: 0)
        result = 31 * result + (publicDnsName?.hashCode() ?: 0)
        result = 31 * result + (publicIp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NetworkInterfaceAssociation

        if (allocationId != other.allocationId) return false
        if (associationId != other.associationId) return false
        if (carrierIp != other.carrierIp) return false
        if (customerOwnedIp != other.customerOwnedIp) return false
        if (ipOwnerId != other.ipOwnerId) return false
        if (publicDnsName != other.publicDnsName) return false
        if (publicIp != other.publicIp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.NetworkInterfaceAssociation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The allocation ID.
         */
        public var allocationId: kotlin.String? = null
        /**
         * The association ID.
         */
        public var associationId: kotlin.String? = null
        /**
         * The carrier IP address associated with the network interface.
         *
         * This option is only available when the network interface is in a subnet which is associated with a Wavelength Zone.
         */
        public var carrierIp: kotlin.String? = null
        /**
         * The customer-owned IP address associated with the network interface.
         */
        public var customerOwnedIp: kotlin.String? = null
        /**
         * The ID of the Elastic IP address owner.
         */
        public var ipOwnerId: kotlin.String? = null
        /**
         * The public DNS name.
         */
        public var publicDnsName: kotlin.String? = null
        /**
         * The address of the Elastic IP address bound to the network interface.
         */
        public var publicIp: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.NetworkInterfaceAssociation) : this() {
            this.allocationId = x.allocationId
            this.associationId = x.associationId
            this.carrierIp = x.carrierIp
            this.customerOwnedIp = x.customerOwnedIp
            this.ipOwnerId = x.ipOwnerId
            this.publicDnsName = x.publicDnsName
            this.publicIp = x.publicIp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.NetworkInterfaceAssociation = NetworkInterfaceAssociation(this)
    }
}
