// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a network interface.
 */
public class NetworkInterface private constructor(builder: Builder) {
    /**
     * The association information for an Elastic IP address (IPv4) associated with the network interface.
     */
    public val association: aws.sdk.kotlin.services.ec2.model.NetworkInterfaceAssociation? = builder.association
    /**
     * The network interface attachment.
     */
    public val attachment: aws.sdk.kotlin.services.ec2.model.NetworkInterfaceAttachment? = builder.attachment
    /**
     * The Availability Zone.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * Indicates whether a network interface with an IPv6 address is unreachable from the public internet. If the value is `true`, inbound traffic from the internet is dropped and you cannot assign an elastic IP address to the network interface. The network interface is reachable from peered VPCs and resources connected through a transit gateway, including on-premises networks.
     */
    public val denyAllIgwTraffic: kotlin.Boolean? = builder.denyAllIgwTraffic
    /**
     * A description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Any security groups for the network interface.
     */
    public val groups: List<GroupIdentifier>? = builder.groups
    /**
     * The type of network interface.
     */
    public val interfaceType: aws.sdk.kotlin.services.ec2.model.NetworkInterfaceType? = builder.interfaceType
    /**
     * The IPv4 prefixes that are assigned to the network interface.
     */
    public val ipv4Prefixes: List<Ipv4PrefixSpecification>? = builder.ipv4Prefixes
    /**
     * The IPv6 globally unique address associated with the network interface.
     */
    public val ipv6Address: kotlin.String? = builder.ipv6Address
    /**
     * The IPv6 addresses associated with the network interface.
     */
    public val ipv6Addresses: List<NetworkInterfaceIpv6Address>? = builder.ipv6Addresses
    /**
     * Indicates whether this is an IPv6 only network interface.
     */
    public val ipv6Native: kotlin.Boolean? = builder.ipv6Native
    /**
     * The IPv6 prefixes that are assigned to the network interface.
     */
    public val ipv6Prefixes: List<Ipv6PrefixSpecification>? = builder.ipv6Prefixes
    /**
     * The MAC address.
     */
    public val macAddress: kotlin.String? = builder.macAddress
    /**
     * The ID of the network interface.
     */
    public val networkInterfaceId: kotlin.String? = builder.networkInterfaceId
    /**
     * The Amazon Resource Name (ARN) of the Outpost.
     */
    public val outpostArn: kotlin.String? = builder.outpostArn
    /**
     * The Amazon Web Services account ID of the owner of the network interface.
     */
    public val ownerId: kotlin.String? = builder.ownerId
    /**
     * The private DNS name.
     */
    public val privateDnsName: kotlin.String? = builder.privateDnsName
    /**
     * The IPv4 address of the network interface within the subnet.
     */
    public val privateIpAddress: kotlin.String? = builder.privateIpAddress
    /**
     * The private IPv4 addresses associated with the network interface.
     */
    public val privateIpAddresses: List<NetworkInterfacePrivateIpAddress>? = builder.privateIpAddresses
    /**
     * The alias or Amazon Web Services account ID of the principal or service that created the network interface.
     */
    public val requesterId: kotlin.String? = builder.requesterId
    /**
     * Indicates whether the network interface is being managed by Amazon Web Services.
     */
    public val requesterManaged: kotlin.Boolean? = builder.requesterManaged
    /**
     * Indicates whether source/destination checking is enabled.
     */
    public val sourceDestCheck: kotlin.Boolean? = builder.sourceDestCheck
    /**
     * The status of the network interface.
     */
    public val status: aws.sdk.kotlin.services.ec2.model.NetworkInterfaceStatus? = builder.status
    /**
     * The ID of the subnet.
     */
    public val subnetId: kotlin.String? = builder.subnetId
    /**
     * Any tags assigned to the network interface.
     */
    public val tagSet: List<Tag>? = builder.tagSet
    /**
     * The ID of the VPC.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.NetworkInterface = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkInterface(")
        append("association=$association,")
        append("attachment=$attachment,")
        append("availabilityZone=$availabilityZone,")
        append("denyAllIgwTraffic=$denyAllIgwTraffic,")
        append("description=$description,")
        append("groups=$groups,")
        append("interfaceType=$interfaceType,")
        append("ipv4Prefixes=$ipv4Prefixes,")
        append("ipv6Address=$ipv6Address,")
        append("ipv6Addresses=$ipv6Addresses,")
        append("ipv6Native=$ipv6Native,")
        append("ipv6Prefixes=$ipv6Prefixes,")
        append("macAddress=$macAddress,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("outpostArn=$outpostArn,")
        append("ownerId=$ownerId,")
        append("privateDnsName=$privateDnsName,")
        append("privateIpAddress=$privateIpAddress,")
        append("privateIpAddresses=$privateIpAddresses,")
        append("requesterId=$requesterId,")
        append("requesterManaged=$requesterManaged,")
        append("sourceDestCheck=$sourceDestCheck,")
        append("status=$status,")
        append("subnetId=$subnetId,")
        append("tagSet=$tagSet,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = association?.hashCode() ?: 0
        result = 31 * result + (attachment?.hashCode() ?: 0)
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (denyAllIgwTraffic?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (groups?.hashCode() ?: 0)
        result = 31 * result + (interfaceType?.hashCode() ?: 0)
        result = 31 * result + (ipv4Prefixes?.hashCode() ?: 0)
        result = 31 * result + (ipv6Address?.hashCode() ?: 0)
        result = 31 * result + (ipv6Addresses?.hashCode() ?: 0)
        result = 31 * result + (ipv6Native?.hashCode() ?: 0)
        result = 31 * result + (ipv6Prefixes?.hashCode() ?: 0)
        result = 31 * result + (macAddress?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (privateDnsName?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddress?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddresses?.hashCode() ?: 0)
        result = 31 * result + (requesterId?.hashCode() ?: 0)
        result = 31 * result + (requesterManaged?.hashCode() ?: 0)
        result = 31 * result + (sourceDestCheck?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (tagSet?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NetworkInterface

        if (association != other.association) return false
        if (attachment != other.attachment) return false
        if (availabilityZone != other.availabilityZone) return false
        if (denyAllIgwTraffic != other.denyAllIgwTraffic) return false
        if (description != other.description) return false
        if (groups != other.groups) return false
        if (interfaceType != other.interfaceType) return false
        if (ipv4Prefixes != other.ipv4Prefixes) return false
        if (ipv6Address != other.ipv6Address) return false
        if (ipv6Addresses != other.ipv6Addresses) return false
        if (ipv6Native != other.ipv6Native) return false
        if (ipv6Prefixes != other.ipv6Prefixes) return false
        if (macAddress != other.macAddress) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (outpostArn != other.outpostArn) return false
        if (ownerId != other.ownerId) return false
        if (privateDnsName != other.privateDnsName) return false
        if (privateIpAddress != other.privateIpAddress) return false
        if (privateIpAddresses != other.privateIpAddresses) return false
        if (requesterId != other.requesterId) return false
        if (requesterManaged != other.requesterManaged) return false
        if (sourceDestCheck != other.sourceDestCheck) return false
        if (status != other.status) return false
        if (subnetId != other.subnetId) return false
        if (tagSet != other.tagSet) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.NetworkInterface = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The association information for an Elastic IP address (IPv4) associated with the network interface.
         */
        public var association: aws.sdk.kotlin.services.ec2.model.NetworkInterfaceAssociation? = null
        /**
         * The network interface attachment.
         */
        public var attachment: aws.sdk.kotlin.services.ec2.model.NetworkInterfaceAttachment? = null
        /**
         * The Availability Zone.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * Indicates whether a network interface with an IPv6 address is unreachable from the public internet. If the value is `true`, inbound traffic from the internet is dropped and you cannot assign an elastic IP address to the network interface. The network interface is reachable from peered VPCs and resources connected through a transit gateway, including on-premises networks.
         */
        public var denyAllIgwTraffic: kotlin.Boolean? = null
        /**
         * A description.
         */
        public var description: kotlin.String? = null
        /**
         * Any security groups for the network interface.
         */
        public var groups: List<GroupIdentifier>? = null
        /**
         * The type of network interface.
         */
        public var interfaceType: aws.sdk.kotlin.services.ec2.model.NetworkInterfaceType? = null
        /**
         * The IPv4 prefixes that are assigned to the network interface.
         */
        public var ipv4Prefixes: List<Ipv4PrefixSpecification>? = null
        /**
         * The IPv6 globally unique address associated with the network interface.
         */
        public var ipv6Address: kotlin.String? = null
        /**
         * The IPv6 addresses associated with the network interface.
         */
        public var ipv6Addresses: List<NetworkInterfaceIpv6Address>? = null
        /**
         * Indicates whether this is an IPv6 only network interface.
         */
        public var ipv6Native: kotlin.Boolean? = null
        /**
         * The IPv6 prefixes that are assigned to the network interface.
         */
        public var ipv6Prefixes: List<Ipv6PrefixSpecification>? = null
        /**
         * The MAC address.
         */
        public var macAddress: kotlin.String? = null
        /**
         * The ID of the network interface.
         */
        public var networkInterfaceId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Outpost.
         */
        public var outpostArn: kotlin.String? = null
        /**
         * The Amazon Web Services account ID of the owner of the network interface.
         */
        public var ownerId: kotlin.String? = null
        /**
         * The private DNS name.
         */
        public var privateDnsName: kotlin.String? = null
        /**
         * The IPv4 address of the network interface within the subnet.
         */
        public var privateIpAddress: kotlin.String? = null
        /**
         * The private IPv4 addresses associated with the network interface.
         */
        public var privateIpAddresses: List<NetworkInterfacePrivateIpAddress>? = null
        /**
         * The alias or Amazon Web Services account ID of the principal or service that created the network interface.
         */
        public var requesterId: kotlin.String? = null
        /**
         * Indicates whether the network interface is being managed by Amazon Web Services.
         */
        public var requesterManaged: kotlin.Boolean? = null
        /**
         * Indicates whether source/destination checking is enabled.
         */
        public var sourceDestCheck: kotlin.Boolean? = null
        /**
         * The status of the network interface.
         */
        public var status: aws.sdk.kotlin.services.ec2.model.NetworkInterfaceStatus? = null
        /**
         * The ID of the subnet.
         */
        public var subnetId: kotlin.String? = null
        /**
         * Any tags assigned to the network interface.
         */
        public var tagSet: List<Tag>? = null
        /**
         * The ID of the VPC.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.NetworkInterface) : this() {
            this.association = x.association
            this.attachment = x.attachment
            this.availabilityZone = x.availabilityZone
            this.denyAllIgwTraffic = x.denyAllIgwTraffic
            this.description = x.description
            this.groups = x.groups
            this.interfaceType = x.interfaceType
            this.ipv4Prefixes = x.ipv4Prefixes
            this.ipv6Address = x.ipv6Address
            this.ipv6Addresses = x.ipv6Addresses
            this.ipv6Native = x.ipv6Native
            this.ipv6Prefixes = x.ipv6Prefixes
            this.macAddress = x.macAddress
            this.networkInterfaceId = x.networkInterfaceId
            this.outpostArn = x.outpostArn
            this.ownerId = x.ownerId
            this.privateDnsName = x.privateDnsName
            this.privateIpAddress = x.privateIpAddress
            this.privateIpAddresses = x.privateIpAddresses
            this.requesterId = x.requesterId
            this.requesterManaged = x.requesterManaged
            this.sourceDestCheck = x.sourceDestCheck
            this.status = x.status
            this.subnetId = x.subnetId
            this.tagSet = x.tagSet
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.NetworkInterface = NetworkInterface(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.NetworkInterfaceAssociation] inside the given [block]
         */
        public fun association(block: aws.sdk.kotlin.services.ec2.model.NetworkInterfaceAssociation.Builder.() -> kotlin.Unit) {
            this.association = aws.sdk.kotlin.services.ec2.model.NetworkInterfaceAssociation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.NetworkInterfaceAttachment] inside the given [block]
         */
        public fun attachment(block: aws.sdk.kotlin.services.ec2.model.NetworkInterfaceAttachment.Builder.() -> kotlin.Unit) {
            this.attachment = aws.sdk.kotlin.services.ec2.model.NetworkInterfaceAttachment.invoke(block)
        }
    }
}
