// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the networking features of the instance type.
 */
public class NetworkInfo private constructor(builder: Builder) {
    /**
     * The index of the default network card, starting at 0.
     */
    public val defaultNetworkCardIndex: kotlin.Int? = builder.defaultNetworkCardIndex
    /**
     * Describes the Elastic Fabric Adapters for the instance type.
     */
    public val efaInfo: aws.sdk.kotlin.services.ec2.model.EfaInfo? = builder.efaInfo
    /**
     * Indicates whether Elastic Fabric Adapter (EFA) is supported.
     */
    public val efaSupported: kotlin.Boolean? = builder.efaSupported
    /**
     * Indicates whether Elastic Network Adapter (ENA) is supported.
     */
    public val enaSupport: aws.sdk.kotlin.services.ec2.model.EnaSupport? = builder.enaSupport
    /**
     * Indicates whether the instance type automatically encrypts in-transit traffic between instances.
     */
    public val encryptionInTransitSupported: kotlin.Boolean? = builder.encryptionInTransitSupported
    /**
     * The maximum number of IPv4 addresses per network interface.
     */
    public val ipv4AddressesPerInterface: kotlin.Int? = builder.ipv4AddressesPerInterface
    /**
     * The maximum number of IPv6 addresses per network interface.
     */
    public val ipv6AddressesPerInterface: kotlin.Int? = builder.ipv6AddressesPerInterface
    /**
     * Indicates whether IPv6 is supported.
     */
    public val ipv6Supported: kotlin.Boolean? = builder.ipv6Supported
    /**
     * The maximum number of physical network cards that can be allocated to the instance.
     */
    public val maximumNetworkCards: kotlin.Int? = builder.maximumNetworkCards
    /**
     * The maximum number of network interfaces for the instance type.
     */
    public val maximumNetworkInterfaces: kotlin.Int? = builder.maximumNetworkInterfaces
    /**
     * Describes the network cards for the instance type.
     */
    public val networkCards: List<NetworkCardInfo>? = builder.networkCards
    /**
     * The network performance.
     */
    public val networkPerformance: kotlin.String? = builder.networkPerformance

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.NetworkInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkInfo(")
        append("defaultNetworkCardIndex=$defaultNetworkCardIndex,")
        append("efaInfo=$efaInfo,")
        append("efaSupported=$efaSupported,")
        append("enaSupport=$enaSupport,")
        append("encryptionInTransitSupported=$encryptionInTransitSupported,")
        append("ipv4AddressesPerInterface=$ipv4AddressesPerInterface,")
        append("ipv6AddressesPerInterface=$ipv6AddressesPerInterface,")
        append("ipv6Supported=$ipv6Supported,")
        append("maximumNetworkCards=$maximumNetworkCards,")
        append("maximumNetworkInterfaces=$maximumNetworkInterfaces,")
        append("networkCards=$networkCards,")
        append("networkPerformance=$networkPerformance)")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultNetworkCardIndex ?: 0
        result = 31 * result + (efaInfo?.hashCode() ?: 0)
        result = 31 * result + (efaSupported?.hashCode() ?: 0)
        result = 31 * result + (enaSupport?.hashCode() ?: 0)
        result = 31 * result + (encryptionInTransitSupported?.hashCode() ?: 0)
        result = 31 * result + (ipv4AddressesPerInterface ?: 0)
        result = 31 * result + (ipv6AddressesPerInterface ?: 0)
        result = 31 * result + (ipv6Supported?.hashCode() ?: 0)
        result = 31 * result + (maximumNetworkCards ?: 0)
        result = 31 * result + (maximumNetworkInterfaces ?: 0)
        result = 31 * result + (networkCards?.hashCode() ?: 0)
        result = 31 * result + (networkPerformance?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NetworkInfo

        if (defaultNetworkCardIndex != other.defaultNetworkCardIndex) return false
        if (efaInfo != other.efaInfo) return false
        if (efaSupported != other.efaSupported) return false
        if (enaSupport != other.enaSupport) return false
        if (encryptionInTransitSupported != other.encryptionInTransitSupported) return false
        if (ipv4AddressesPerInterface != other.ipv4AddressesPerInterface) return false
        if (ipv6AddressesPerInterface != other.ipv6AddressesPerInterface) return false
        if (ipv6Supported != other.ipv6Supported) return false
        if (maximumNetworkCards != other.maximumNetworkCards) return false
        if (maximumNetworkInterfaces != other.maximumNetworkInterfaces) return false
        if (networkCards != other.networkCards) return false
        if (networkPerformance != other.networkPerformance) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.NetworkInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The index of the default network card, starting at 0.
         */
        public var defaultNetworkCardIndex: kotlin.Int? = null
        /**
         * Describes the Elastic Fabric Adapters for the instance type.
         */
        public var efaInfo: aws.sdk.kotlin.services.ec2.model.EfaInfo? = null
        /**
         * Indicates whether Elastic Fabric Adapter (EFA) is supported.
         */
        public var efaSupported: kotlin.Boolean? = null
        /**
         * Indicates whether Elastic Network Adapter (ENA) is supported.
         */
        public var enaSupport: aws.sdk.kotlin.services.ec2.model.EnaSupport? = null
        /**
         * Indicates whether the instance type automatically encrypts in-transit traffic between instances.
         */
        public var encryptionInTransitSupported: kotlin.Boolean? = null
        /**
         * The maximum number of IPv4 addresses per network interface.
         */
        public var ipv4AddressesPerInterface: kotlin.Int? = null
        /**
         * The maximum number of IPv6 addresses per network interface.
         */
        public var ipv6AddressesPerInterface: kotlin.Int? = null
        /**
         * Indicates whether IPv6 is supported.
         */
        public var ipv6Supported: kotlin.Boolean? = null
        /**
         * The maximum number of physical network cards that can be allocated to the instance.
         */
        public var maximumNetworkCards: kotlin.Int? = null
        /**
         * The maximum number of network interfaces for the instance type.
         */
        public var maximumNetworkInterfaces: kotlin.Int? = null
        /**
         * Describes the network cards for the instance type.
         */
        public var networkCards: List<NetworkCardInfo>? = null
        /**
         * The network performance.
         */
        public var networkPerformance: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.NetworkInfo) : this() {
            this.defaultNetworkCardIndex = x.defaultNetworkCardIndex
            this.efaInfo = x.efaInfo
            this.efaSupported = x.efaSupported
            this.enaSupport = x.enaSupport
            this.encryptionInTransitSupported = x.encryptionInTransitSupported
            this.ipv4AddressesPerInterface = x.ipv4AddressesPerInterface
            this.ipv6AddressesPerInterface = x.ipv6AddressesPerInterface
            this.ipv6Supported = x.ipv6Supported
            this.maximumNetworkCards = x.maximumNetworkCards
            this.maximumNetworkInterfaces = x.maximumNetworkInterfaces
            this.networkCards = x.networkCards
            this.networkPerformance = x.networkPerformance
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.NetworkInfo = NetworkInfo(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.EfaInfo] inside the given [block]
         */
        public fun efaInfo(block: aws.sdk.kotlin.services.ec2.model.EfaInfo.Builder.() -> kotlin.Unit) {
            this.efaInfo = aws.sdk.kotlin.services.ec2.model.EfaInfo.invoke(block)
        }
    }
}
