// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the IP addresses and network interface associated with a NAT gateway.
 */
public class NatGatewayAddress private constructor(builder: Builder) {
    /**
     * &#91;Public NAT gateway only&#93; The allocation ID of the Elastic IP address that's associated with the NAT gateway.
     */
    public val allocationId: kotlin.String? = builder.allocationId
    /**
     * The ID of the network interface associated with the NAT gateway.
     */
    public val networkInterfaceId: kotlin.String? = builder.networkInterfaceId
    /**
     * The private IP address associated with the NAT gateway.
     */
    public val privateIp: kotlin.String? = builder.privateIp
    /**
     * &#91;Public NAT gateway only&#93; The Elastic IP address associated with the NAT gateway.
     */
    public val publicIp: kotlin.String? = builder.publicIp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.NatGatewayAddress = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NatGatewayAddress(")
        append("allocationId=$allocationId,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("privateIp=$privateIp,")
        append("publicIp=$publicIp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocationId?.hashCode() ?: 0
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (privateIp?.hashCode() ?: 0)
        result = 31 * result + (publicIp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NatGatewayAddress

        if (allocationId != other.allocationId) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (privateIp != other.privateIp) return false
        if (publicIp != other.publicIp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.NatGatewayAddress = Builder(this).apply(block).build()

    public class Builder {
        /**
         * &#91;Public NAT gateway only&#93; The allocation ID of the Elastic IP address that's associated with the NAT gateway.
         */
        public var allocationId: kotlin.String? = null
        /**
         * The ID of the network interface associated with the NAT gateway.
         */
        public var networkInterfaceId: kotlin.String? = null
        /**
         * The private IP address associated with the NAT gateway.
         */
        public var privateIp: kotlin.String? = null
        /**
         * &#91;Public NAT gateway only&#93; The Elastic IP address associated with the NAT gateway.
         */
        public var publicIp: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.NatGatewayAddress) : this() {
            this.allocationId = x.allocationId
            this.networkInterfaceId = x.networkInterfaceId
            this.privateIp = x.privateIp
            this.publicIp = x.publicIp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.NatGatewayAddress = NatGatewayAddress(this)
    }
}
