// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * A CIDR provisioned to an IPAM pool.
 */
public class IpamPoolCidr private constructor(builder: Builder) {
    /**
     * The CIDR provisioned to the IPAM pool. A CIDR is a representation of an IP address and its associated network mask (or netmask) and refers to a range of IP addresses. An IPv4 CIDR example is `10.24.34.0/23`. An IPv6 CIDR example is `2001:DB8::/32`.
     */
    public val cidr: kotlin.String? = builder.cidr
    /**
     * Details related to why an IPAM pool CIDR failed to be provisioned.
     */
    public val failureReason: aws.sdk.kotlin.services.ec2.model.IpamPoolCidrFailureReason? = builder.failureReason
    /**
     * The state of the CIDR.
     */
    public val state: aws.sdk.kotlin.services.ec2.model.IpamPoolCidrState? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.IpamPoolCidr = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IpamPoolCidr(")
        append("cidr=$cidr,")
        append("failureReason=$failureReason,")
        append("state=$state)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidr?.hashCode() ?: 0
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IpamPoolCidr

        if (cidr != other.cidr) return false
        if (failureReason != other.failureReason) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.IpamPoolCidr = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The CIDR provisioned to the IPAM pool. A CIDR is a representation of an IP address and its associated network mask (or netmask) and refers to a range of IP addresses. An IPv4 CIDR example is `10.24.34.0/23`. An IPv6 CIDR example is `2001:DB8::/32`.
         */
        public var cidr: kotlin.String? = null
        /**
         * Details related to why an IPAM pool CIDR failed to be provisioned.
         */
        public var failureReason: aws.sdk.kotlin.services.ec2.model.IpamPoolCidrFailureReason? = null
        /**
         * The state of the CIDR.
         */
        public var state: aws.sdk.kotlin.services.ec2.model.IpamPoolCidrState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.IpamPoolCidr) : this() {
            this.cidr = x.cidr
            this.failureReason = x.failureReason
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.IpamPoolCidr = IpamPoolCidr(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.IpamPoolCidrFailureReason] inside the given [block]
         */
        public fun failureReason(block: aws.sdk.kotlin.services.ec2.model.IpamPoolCidrFailureReason.Builder.() -> kotlin.Unit) {
            this.failureReason = aws.sdk.kotlin.services.ec2.model.IpamPoolCidrFailureReason.invoke(block)
        }
    }
}
