// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The historical record of a CIDR within an IPAM scope. For more information, see [View the history of IP addresses](https://docs.aws.amazon.com/vpc/latest/ipam/view-history-cidr-ipam.html) in the *Amazon VPC IPAM User Guide*.
 */
public class IpamAddressHistoryRecord private constructor(builder: Builder) {
    /**
     * The CIDR of the resource.
     */
    public val resourceCidr: kotlin.String? = builder.resourceCidr
    /**
     * The compliance status of a resource. For more information on compliance statuses, see [Monitor CIDR usage by resource](https://docs.aws.amazon.com/vpc/latest/ipam/monitor-cidr-compliance-ipam.html) in the *Amazon VPC IPAM User Guide*.
     */
    public val resourceComplianceStatus: aws.sdk.kotlin.services.ec2.model.IpamComplianceStatus? = builder.resourceComplianceStatus
    /**
     * The ID of the resource.
     */
    public val resourceId: kotlin.String? = builder.resourceId
    /**
     * The name of the resource.
     */
    public val resourceName: kotlin.String? = builder.resourceName
    /**
     * The overlap status of an IPAM resource. The overlap status tells you if the CIDR for a resource overlaps with another CIDR in the scope. For more information on overlap statuses, see [Monitor CIDR usage by resource](https://docs.aws.amazon.com/vpc/latest/ipam/monitor-cidr-compliance-ipam.html) in the *Amazon VPC IPAM User Guide*.
     */
    public val resourceOverlapStatus: aws.sdk.kotlin.services.ec2.model.IpamOverlapStatus? = builder.resourceOverlapStatus
    /**
     * The ID of the resource owner.
     */
    public val resourceOwnerId: kotlin.String? = builder.resourceOwnerId
    /**
     * The Amazon Web Services Region of the resource.
     */
    public val resourceRegion: kotlin.String? = builder.resourceRegion
    /**
     * The type of the resource.
     */
    public val resourceType: aws.sdk.kotlin.services.ec2.model.IpamAddressHistoryResourceType? = builder.resourceType
    /**
     * Sampled end time of the resource-to-CIDR association within the IPAM scope. Changes are picked up in periodic snapshots, so the end time may have occurred before this specific time.
     */
    public val sampledEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.sampledEndTime
    /**
     * Sampled start time of the resource-to-CIDR association within the IPAM scope. Changes are picked up in periodic snapshots, so the start time may have occurred before this specific time.
     */
    public val sampledStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.sampledStartTime
    /**
     * The VPC ID of the resource.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.IpamAddressHistoryRecord = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IpamAddressHistoryRecord(")
        append("resourceCidr=$resourceCidr,")
        append("resourceComplianceStatus=$resourceComplianceStatus,")
        append("resourceId=$resourceId,")
        append("resourceName=$resourceName,")
        append("resourceOverlapStatus=$resourceOverlapStatus,")
        append("resourceOwnerId=$resourceOwnerId,")
        append("resourceRegion=$resourceRegion,")
        append("resourceType=$resourceType,")
        append("sampledEndTime=$sampledEndTime,")
        append("sampledStartTime=$sampledStartTime,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceCidr?.hashCode() ?: 0
        result = 31 * result + (resourceComplianceStatus?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceName?.hashCode() ?: 0)
        result = 31 * result + (resourceOverlapStatus?.hashCode() ?: 0)
        result = 31 * result + (resourceOwnerId?.hashCode() ?: 0)
        result = 31 * result + (resourceRegion?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (sampledEndTime?.hashCode() ?: 0)
        result = 31 * result + (sampledStartTime?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IpamAddressHistoryRecord

        if (resourceCidr != other.resourceCidr) return false
        if (resourceComplianceStatus != other.resourceComplianceStatus) return false
        if (resourceId != other.resourceId) return false
        if (resourceName != other.resourceName) return false
        if (resourceOverlapStatus != other.resourceOverlapStatus) return false
        if (resourceOwnerId != other.resourceOwnerId) return false
        if (resourceRegion != other.resourceRegion) return false
        if (resourceType != other.resourceType) return false
        if (sampledEndTime != other.sampledEndTime) return false
        if (sampledStartTime != other.sampledStartTime) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.IpamAddressHistoryRecord = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The CIDR of the resource.
         */
        public var resourceCidr: kotlin.String? = null
        /**
         * The compliance status of a resource. For more information on compliance statuses, see [Monitor CIDR usage by resource](https://docs.aws.amazon.com/vpc/latest/ipam/monitor-cidr-compliance-ipam.html) in the *Amazon VPC IPAM User Guide*.
         */
        public var resourceComplianceStatus: aws.sdk.kotlin.services.ec2.model.IpamComplianceStatus? = null
        /**
         * The ID of the resource.
         */
        public var resourceId: kotlin.String? = null
        /**
         * The name of the resource.
         */
        public var resourceName: kotlin.String? = null
        /**
         * The overlap status of an IPAM resource. The overlap status tells you if the CIDR for a resource overlaps with another CIDR in the scope. For more information on overlap statuses, see [Monitor CIDR usage by resource](https://docs.aws.amazon.com/vpc/latest/ipam/monitor-cidr-compliance-ipam.html) in the *Amazon VPC IPAM User Guide*.
         */
        public var resourceOverlapStatus: aws.sdk.kotlin.services.ec2.model.IpamOverlapStatus? = null
        /**
         * The ID of the resource owner.
         */
        public var resourceOwnerId: kotlin.String? = null
        /**
         * The Amazon Web Services Region of the resource.
         */
        public var resourceRegion: kotlin.String? = null
        /**
         * The type of the resource.
         */
        public var resourceType: aws.sdk.kotlin.services.ec2.model.IpamAddressHistoryResourceType? = null
        /**
         * Sampled end time of the resource-to-CIDR association within the IPAM scope. Changes are picked up in periodic snapshots, so the end time may have occurred before this specific time.
         */
        public var sampledEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Sampled start time of the resource-to-CIDR association within the IPAM scope. Changes are picked up in periodic snapshots, so the start time may have occurred before this specific time.
         */
        public var sampledStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The VPC ID of the resource.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.IpamAddressHistoryRecord) : this() {
            this.resourceCidr = x.resourceCidr
            this.resourceComplianceStatus = x.resourceComplianceStatus
            this.resourceId = x.resourceId
            this.resourceName = x.resourceName
            this.resourceOverlapStatus = x.resourceOverlapStatus
            this.resourceOwnerId = x.resourceOwnerId
            this.resourceRegion = x.resourceRegion
            this.resourceType = x.resourceType
            this.sampledEndTime = x.sampledEndTime
            this.sampledStartTime = x.sampledStartTime
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.IpamAddressHistoryRecord = IpamAddressHistoryRecord(this)
    }
}
