// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across Amazon Web Services Regions and accounts throughout your Amazon Web Services Organization. For more information, see [What is IPAM?](https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html) in the *Amazon VPC IPAM User Guide*.
 */
public class Ipam private constructor(builder: Builder) {
    /**
     * The description for the IPAM.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ARN of the IPAM.
     */
    public val ipamArn: kotlin.String? = builder.ipamArn
    /**
     * The ID of the IPAM.
     */
    public val ipamId: kotlin.String? = builder.ipamId
    /**
     * The Amazon Web Services Region of the IPAM.
     */
    public val ipamRegion: kotlin.String? = builder.ipamRegion
    /**
     * The operating Regions for an IPAM. Operating Regions are Amazon Web Services Regions where the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web Services Regions you select as operating Regions.
     *
     * For more information about operating Regions, see [Create an IPAM](https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html) in the *Amazon VPC IPAM User Guide*.
     */
    public val operatingRegions: List<IpamOperatingRegion>? = builder.operatingRegions
    /**
     * The Amazon Web Services account ID of the owner of the IPAM.
     */
    public val ownerId: kotlin.String? = builder.ownerId
    /**
     * The ID of the IPAM's default private scope.
     */
    public val privateDefaultScopeId: kotlin.String? = builder.privateDefaultScopeId
    /**
     * The ID of the IPAM's default public scope.
     */
    public val publicDefaultScopeId: kotlin.String? = builder.publicDefaultScopeId
    /**
     * The number of scopes in the IPAM. The scope quota is 5. For more information on quotas, see [Quotas in IPAM](https://docs.aws.amazon.com/vpc/latest/ipam/quotas-ipam.html) in the *Amazon VPC IPAM User Guide*.
     */
    public val scopeCount: kotlin.Int? = builder.scopeCount
    /**
     * The state of the IPAM.
     */
    public val state: aws.sdk.kotlin.services.ec2.model.IpamState? = builder.state
    /**
     * The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key `Owner` and the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.Ipam = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Ipam(")
        append("description=$description,")
        append("ipamArn=$ipamArn,")
        append("ipamId=$ipamId,")
        append("ipamRegion=$ipamRegion,")
        append("operatingRegions=$operatingRegions,")
        append("ownerId=$ownerId,")
        append("privateDefaultScopeId=$privateDefaultScopeId,")
        append("publicDefaultScopeId=$publicDefaultScopeId,")
        append("scopeCount=$scopeCount,")
        append("state=$state,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (ipamArn?.hashCode() ?: 0)
        result = 31 * result + (ipamId?.hashCode() ?: 0)
        result = 31 * result + (ipamRegion?.hashCode() ?: 0)
        result = 31 * result + (operatingRegions?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (privateDefaultScopeId?.hashCode() ?: 0)
        result = 31 * result + (publicDefaultScopeId?.hashCode() ?: 0)
        result = 31 * result + (scopeCount ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Ipam

        if (description != other.description) return false
        if (ipamArn != other.ipamArn) return false
        if (ipamId != other.ipamId) return false
        if (ipamRegion != other.ipamRegion) return false
        if (operatingRegions != other.operatingRegions) return false
        if (ownerId != other.ownerId) return false
        if (privateDefaultScopeId != other.privateDefaultScopeId) return false
        if (publicDefaultScopeId != other.publicDefaultScopeId) return false
        if (scopeCount != other.scopeCount) return false
        if (state != other.state) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.Ipam = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The description for the IPAM.
         */
        public var description: kotlin.String? = null
        /**
         * The ARN of the IPAM.
         */
        public var ipamArn: kotlin.String? = null
        /**
         * The ID of the IPAM.
         */
        public var ipamId: kotlin.String? = null
        /**
         * The Amazon Web Services Region of the IPAM.
         */
        public var ipamRegion: kotlin.String? = null
        /**
         * The operating Regions for an IPAM. Operating Regions are Amazon Web Services Regions where the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web Services Regions you select as operating Regions.
         *
         * For more information about operating Regions, see [Create an IPAM](https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html) in the *Amazon VPC IPAM User Guide*.
         */
        public var operatingRegions: List<IpamOperatingRegion>? = null
        /**
         * The Amazon Web Services account ID of the owner of the IPAM.
         */
        public var ownerId: kotlin.String? = null
        /**
         * The ID of the IPAM's default private scope.
         */
        public var privateDefaultScopeId: kotlin.String? = null
        /**
         * The ID of the IPAM's default public scope.
         */
        public var publicDefaultScopeId: kotlin.String? = null
        /**
         * The number of scopes in the IPAM. The scope quota is 5. For more information on quotas, see [Quotas in IPAM](https://docs.aws.amazon.com/vpc/latest/ipam/quotas-ipam.html) in the *Amazon VPC IPAM User Guide*.
         */
        public var scopeCount: kotlin.Int? = null
        /**
         * The state of the IPAM.
         */
        public var state: aws.sdk.kotlin.services.ec2.model.IpamState? = null
        /**
         * The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key `Owner` and the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.Ipam) : this() {
            this.description = x.description
            this.ipamArn = x.ipamArn
            this.ipamId = x.ipamId
            this.ipamRegion = x.ipamRegion
            this.operatingRegions = x.operatingRegions
            this.ownerId = x.ownerId
            this.privateDefaultScopeId = x.privateDefaultScopeId
            this.publicDefaultScopeId = x.publicDefaultScopeId
            this.scopeCount = x.scopeCount
            this.state = x.state
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.Ipam = Ipam(this)
    }
}
