// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a set of permissions for a security group rule.
 */
public class IpPermission private constructor(builder: Builder) {
    /**
     * The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of `-1` indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify all codes.
     */
    public val fromPort: kotlin.Int? = builder.fromPort
    /**
     * The IP protocol name (`tcp`, `udp`, `icmp`, `icmpv6`) or number (see [Protocol Numbers](http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)).
     *
     * &#91;VPC only&#93; Use `-1` to specify all protocols. When authorizing security group rules, specifying `-1` or a protocol number other than `tcp`, `udp`, `icmp`, or `icmpv6` allows traffic on all ports, regardless of any port range you specify. For `tcp`, `udp`, and `icmp`, you must specify a port range. For `icmpv6`, the port range is optional; if you omit the port range, traffic for all types and codes is allowed.
     */
    public val ipProtocol: kotlin.String? = builder.ipProtocol
    /**
     * The IPv4 ranges.
     */
    public val ipRanges: List<IpRange>? = builder.ipRanges
    /**
     * &#91;VPC only&#93; The IPv6 ranges.
     */
    public val ipv6Ranges: List<Ipv6Range>? = builder.ipv6Ranges
    /**
     * &#91;VPC only&#93; The prefix list IDs.
     */
    public val prefixListIds: List<PrefixListId>? = builder.prefixListIds
    /**
     * The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of `-1` indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all codes.
     */
    public val toPort: kotlin.Int? = builder.toPort
    /**
     * The security group and Amazon Web Services account ID pairs.
     */
    public val userIdGroupPairs: List<UserIdGroupPair>? = builder.userIdGroupPairs

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.IpPermission = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IpPermission(")
        append("fromPort=$fromPort,")
        append("ipProtocol=$ipProtocol,")
        append("ipRanges=$ipRanges,")
        append("ipv6Ranges=$ipv6Ranges,")
        append("prefixListIds=$prefixListIds,")
        append("toPort=$toPort,")
        append("userIdGroupPairs=$userIdGroupPairs)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fromPort ?: 0
        result = 31 * result + (ipProtocol?.hashCode() ?: 0)
        result = 31 * result + (ipRanges?.hashCode() ?: 0)
        result = 31 * result + (ipv6Ranges?.hashCode() ?: 0)
        result = 31 * result + (prefixListIds?.hashCode() ?: 0)
        result = 31 * result + (toPort ?: 0)
        result = 31 * result + (userIdGroupPairs?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IpPermission

        if (fromPort != other.fromPort) return false
        if (ipProtocol != other.ipProtocol) return false
        if (ipRanges != other.ipRanges) return false
        if (ipv6Ranges != other.ipv6Ranges) return false
        if (prefixListIds != other.prefixListIds) return false
        if (toPort != other.toPort) return false
        if (userIdGroupPairs != other.userIdGroupPairs) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.IpPermission = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of `-1` indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify all codes.
         */
        public var fromPort: kotlin.Int? = null
        /**
         * The IP protocol name (`tcp`, `udp`, `icmp`, `icmpv6`) or number (see [Protocol Numbers](http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)).
         *
         * &#91;VPC only&#93; Use `-1` to specify all protocols. When authorizing security group rules, specifying `-1` or a protocol number other than `tcp`, `udp`, `icmp`, or `icmpv6` allows traffic on all ports, regardless of any port range you specify. For `tcp`, `udp`, and `icmp`, you must specify a port range. For `icmpv6`, the port range is optional; if you omit the port range, traffic for all types and codes is allowed.
         */
        public var ipProtocol: kotlin.String? = null
        /**
         * The IPv4 ranges.
         */
        public var ipRanges: List<IpRange>? = null
        /**
         * &#91;VPC only&#93; The IPv6 ranges.
         */
        public var ipv6Ranges: List<Ipv6Range>? = null
        /**
         * &#91;VPC only&#93; The prefix list IDs.
         */
        public var prefixListIds: List<PrefixListId>? = null
        /**
         * The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of `-1` indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all codes.
         */
        public var toPort: kotlin.Int? = null
        /**
         * The security group and Amazon Web Services account ID pairs.
         */
        public var userIdGroupPairs: List<UserIdGroupPair>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.IpPermission) : this() {
            this.fromPort = x.fromPort
            this.ipProtocol = x.ipProtocol
            this.ipRanges = x.ipRanges
            this.ipv6Ranges = x.ipv6Ranges
            this.prefixListIds = x.prefixListIds
            this.toPort = x.toPort
            this.userIdGroupPairs = x.userIdGroupPairs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.IpPermission = IpPermission(this)
    }
}
