// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a network interface.
 */
public class InstanceNetworkInterfaceSpecification private constructor(builder: Builder) {
    /**
     * Indicates whether to assign a carrier IP address to the network interface.
     *
     * You can only assign a carrier IP address to a network interface that is in a subnet in a Wavelength Zone. For more information about carrier IP addresses, see [Carrier IP address](https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip) in the *Amazon Web Services Wavelength Developer Guide*.
     */
    public val associateCarrierIpAddress: kotlin.Boolean? = builder.associateCarrierIpAddress
    /**
     * Indicates whether to assign a public IPv4 address to an instance you launch in a VPC. The public IP address can only be assigned to a network interface for eth0, and can only be assigned to a new network interface, not an existing one. You cannot specify more than one network interface in the request. If launching into a default subnet, the default value is `true`.
     */
    public val associatePublicIpAddress: kotlin.Boolean? = builder.associatePublicIpAddress
    /**
     * If set to `true`, the interface is deleted when the instance is terminated. You can specify `true` only if creating a new network interface when launching an instance.
     */
    public val deleteOnTermination: kotlin.Boolean? = builder.deleteOnTermination
    /**
     * The description of the network interface. Applies only if creating a network interface when launching an instance.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The position of the network interface in the attachment order. A primary network interface has a device index of 0.
     *
     * If you specify a network interface when launching an instance, you must specify the device index.
     */
    public val deviceIndex: kotlin.Int? = builder.deviceIndex
    /**
     * The IDs of the security groups for the network interface. Applies only if creating a network interface when launching an instance.
     */
    public val groups: List<String>? = builder.groups
    /**
     * The type of network interface.
     *
     * Valid values: `interface` | `efa`
     */
    public val interfaceType: kotlin.String? = builder.interfaceType
    /**
     * The number of IPv4 delegated prefixes to be automatically assigned to the network interface. You cannot use this option if you use the `Ipv4Prefix` option.
     */
    public val ipv4PrefixCount: kotlin.Int? = builder.ipv4PrefixCount
    /**
     * The IPv4 delegated prefixes to be assigned to the network interface. You cannot use this option if you use the `Ipv4PrefixCount` option.
     */
    public val ipv4Prefixes: List<Ipv4PrefixSpecificationRequest>? = builder.ipv4Prefixes
    /**
     * A number of IPv6 addresses to assign to the network interface. Amazon EC2 chooses the IPv6 addresses from the range of the subnet. You cannot specify this option and the option to assign specific IPv6 addresses in the same request. You can specify this option if you've specified a minimum number of instances to launch.
     */
    public val ipv6AddressCount: kotlin.Int? = builder.ipv6AddressCount
    /**
     * The IPv6 addresses to assign to the network interface. You cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified a minimum number of instances to launch.
     */
    public val ipv6Addresses: List<InstanceIpv6Address>? = builder.ipv6Addresses
    /**
     * The number of IPv6 delegated prefixes to be automatically assigned to the network interface. You cannot use this option if you use the `Ipv6Prefix` option.
     */
    public val ipv6PrefixCount: kotlin.Int? = builder.ipv6PrefixCount
    /**
     * The IPv6 delegated prefixes to be assigned to the network interface. You cannot use this option if you use the `Ipv6PrefixCount` option.
     */
    public val ipv6Prefixes: List<Ipv6PrefixSpecificationRequest>? = builder.ipv6Prefixes
    /**
     * The index of the network card. Some instance types support multiple network cards. The primary network interface must be assigned to network card index 0. The default is network card index 0.
     *
     * If you are using [RequestSpotInstances](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html) to create Spot Instances, omit this parameter because you can’t specify the network card index when using this API. To specify the network card index, use [RunInstances](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html).
     */
    public val networkCardIndex: kotlin.Int? = builder.networkCardIndex
    /**
     * The ID of the network interface.
     *
     * If you are creating a Spot Fleet, omit this parameter because you can’t specify a network interface ID in a launch specification.
     */
    public val networkInterfaceId: kotlin.String? = builder.networkInterfaceId
    /**
     * The private IPv4 address of the network interface. Applies only if creating a network interface when launching an instance. You cannot specify this option if you're launching more than one instance in a [RunInstances](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html) request.
     */
    public val privateIpAddress: kotlin.String? = builder.privateIpAddress
    /**
     * The private IPv4 addresses to assign to the network interface. Only one private IPv4 address can be designated as primary. You cannot specify this option if you're launching more than one instance in a [RunInstances](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html) request.
     */
    public val privateIpAddresses: List<PrivateIpAddressSpecification>? = builder.privateIpAddresses
    /**
     * The number of secondary private IPv4 addresses. You can't specify this option and specify more than one private IP address using the private IP addresses option. You cannot specify this option if you're launching more than one instance in a [RunInstances](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html) request.
     */
    public val secondaryPrivateIpAddressCount: kotlin.Int? = builder.secondaryPrivateIpAddressCount
    /**
     * The ID of the subnet associated with the network interface. Applies only if creating a network interface when launching an instance.
     */
    public val subnetId: kotlin.String? = builder.subnetId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.InstanceNetworkInterfaceSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceNetworkInterfaceSpecification(")
        append("associateCarrierIpAddress=$associateCarrierIpAddress,")
        append("associatePublicIpAddress=$associatePublicIpAddress,")
        append("deleteOnTermination=$deleteOnTermination,")
        append("description=$description,")
        append("deviceIndex=$deviceIndex,")
        append("groups=$groups,")
        append("interfaceType=$interfaceType,")
        append("ipv4PrefixCount=$ipv4PrefixCount,")
        append("ipv4Prefixes=$ipv4Prefixes,")
        append("ipv6AddressCount=$ipv6AddressCount,")
        append("ipv6Addresses=$ipv6Addresses,")
        append("ipv6PrefixCount=$ipv6PrefixCount,")
        append("ipv6Prefixes=$ipv6Prefixes,")
        append("networkCardIndex=$networkCardIndex,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("privateIpAddress=$privateIpAddress,")
        append("privateIpAddresses=$privateIpAddresses,")
        append("secondaryPrivateIpAddressCount=$secondaryPrivateIpAddressCount,")
        append("subnetId=$subnetId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associateCarrierIpAddress?.hashCode() ?: 0
        result = 31 * result + (associatePublicIpAddress?.hashCode() ?: 0)
        result = 31 * result + (deleteOnTermination?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (deviceIndex ?: 0)
        result = 31 * result + (groups?.hashCode() ?: 0)
        result = 31 * result + (interfaceType?.hashCode() ?: 0)
        result = 31 * result + (ipv4PrefixCount ?: 0)
        result = 31 * result + (ipv4Prefixes?.hashCode() ?: 0)
        result = 31 * result + (ipv6AddressCount ?: 0)
        result = 31 * result + (ipv6Addresses?.hashCode() ?: 0)
        result = 31 * result + (ipv6PrefixCount ?: 0)
        result = 31 * result + (ipv6Prefixes?.hashCode() ?: 0)
        result = 31 * result + (networkCardIndex ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddress?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddresses?.hashCode() ?: 0)
        result = 31 * result + (secondaryPrivateIpAddressCount ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceNetworkInterfaceSpecification

        if (associateCarrierIpAddress != other.associateCarrierIpAddress) return false
        if (associatePublicIpAddress != other.associatePublicIpAddress) return false
        if (deleteOnTermination != other.deleteOnTermination) return false
        if (description != other.description) return false
        if (deviceIndex != other.deviceIndex) return false
        if (groups != other.groups) return false
        if (interfaceType != other.interfaceType) return false
        if (ipv4PrefixCount != other.ipv4PrefixCount) return false
        if (ipv4Prefixes != other.ipv4Prefixes) return false
        if (ipv6AddressCount != other.ipv6AddressCount) return false
        if (ipv6Addresses != other.ipv6Addresses) return false
        if (ipv6PrefixCount != other.ipv6PrefixCount) return false
        if (ipv6Prefixes != other.ipv6Prefixes) return false
        if (networkCardIndex != other.networkCardIndex) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (privateIpAddress != other.privateIpAddress) return false
        if (privateIpAddresses != other.privateIpAddresses) return false
        if (secondaryPrivateIpAddressCount != other.secondaryPrivateIpAddressCount) return false
        if (subnetId != other.subnetId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.InstanceNetworkInterfaceSpecification = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether to assign a carrier IP address to the network interface.
         *
         * You can only assign a carrier IP address to a network interface that is in a subnet in a Wavelength Zone. For more information about carrier IP addresses, see [Carrier IP address](https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip) in the *Amazon Web Services Wavelength Developer Guide*.
         */
        public var associateCarrierIpAddress: kotlin.Boolean? = null
        /**
         * Indicates whether to assign a public IPv4 address to an instance you launch in a VPC. The public IP address can only be assigned to a network interface for eth0, and can only be assigned to a new network interface, not an existing one. You cannot specify more than one network interface in the request. If launching into a default subnet, the default value is `true`.
         */
        public var associatePublicIpAddress: kotlin.Boolean? = null
        /**
         * If set to `true`, the interface is deleted when the instance is terminated. You can specify `true` only if creating a new network interface when launching an instance.
         */
        public var deleteOnTermination: kotlin.Boolean? = null
        /**
         * The description of the network interface. Applies only if creating a network interface when launching an instance.
         */
        public var description: kotlin.String? = null
        /**
         * The position of the network interface in the attachment order. A primary network interface has a device index of 0.
         *
         * If you specify a network interface when launching an instance, you must specify the device index.
         */
        public var deviceIndex: kotlin.Int? = null
        /**
         * The IDs of the security groups for the network interface. Applies only if creating a network interface when launching an instance.
         */
        public var groups: List<String>? = null
        /**
         * The type of network interface.
         *
         * Valid values: `interface` | `efa`
         */
        public var interfaceType: kotlin.String? = null
        /**
         * The number of IPv4 delegated prefixes to be automatically assigned to the network interface. You cannot use this option if you use the `Ipv4Prefix` option.
         */
        public var ipv4PrefixCount: kotlin.Int? = null
        /**
         * The IPv4 delegated prefixes to be assigned to the network interface. You cannot use this option if you use the `Ipv4PrefixCount` option.
         */
        public var ipv4Prefixes: List<Ipv4PrefixSpecificationRequest>? = null
        /**
         * A number of IPv6 addresses to assign to the network interface. Amazon EC2 chooses the IPv6 addresses from the range of the subnet. You cannot specify this option and the option to assign specific IPv6 addresses in the same request. You can specify this option if you've specified a minimum number of instances to launch.
         */
        public var ipv6AddressCount: kotlin.Int? = null
        /**
         * The IPv6 addresses to assign to the network interface. You cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified a minimum number of instances to launch.
         */
        public var ipv6Addresses: List<InstanceIpv6Address>? = null
        /**
         * The number of IPv6 delegated prefixes to be automatically assigned to the network interface. You cannot use this option if you use the `Ipv6Prefix` option.
         */
        public var ipv6PrefixCount: kotlin.Int? = null
        /**
         * The IPv6 delegated prefixes to be assigned to the network interface. You cannot use this option if you use the `Ipv6PrefixCount` option.
         */
        public var ipv6Prefixes: List<Ipv6PrefixSpecificationRequest>? = null
        /**
         * The index of the network card. Some instance types support multiple network cards. The primary network interface must be assigned to network card index 0. The default is network card index 0.
         *
         * If you are using [RequestSpotInstances](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html) to create Spot Instances, omit this parameter because you can’t specify the network card index when using this API. To specify the network card index, use [RunInstances](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html).
         */
        public var networkCardIndex: kotlin.Int? = null
        /**
         * The ID of the network interface.
         *
         * If you are creating a Spot Fleet, omit this parameter because you can’t specify a network interface ID in a launch specification.
         */
        public var networkInterfaceId: kotlin.String? = null
        /**
         * The private IPv4 address of the network interface. Applies only if creating a network interface when launching an instance. You cannot specify this option if you're launching more than one instance in a [RunInstances](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html) request.
         */
        public var privateIpAddress: kotlin.String? = null
        /**
         * The private IPv4 addresses to assign to the network interface. Only one private IPv4 address can be designated as primary. You cannot specify this option if you're launching more than one instance in a [RunInstances](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html) request.
         */
        public var privateIpAddresses: List<PrivateIpAddressSpecification>? = null
        /**
         * The number of secondary private IPv4 addresses. You can't specify this option and specify more than one private IP address using the private IP addresses option. You cannot specify this option if you're launching more than one instance in a [RunInstances](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html) request.
         */
        public var secondaryPrivateIpAddressCount: kotlin.Int? = null
        /**
         * The ID of the subnet associated with the network interface. Applies only if creating a network interface when launching an instance.
         */
        public var subnetId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.InstanceNetworkInterfaceSpecification) : this() {
            this.associateCarrierIpAddress = x.associateCarrierIpAddress
            this.associatePublicIpAddress = x.associatePublicIpAddress
            this.deleteOnTermination = x.deleteOnTermination
            this.description = x.description
            this.deviceIndex = x.deviceIndex
            this.groups = x.groups
            this.interfaceType = x.interfaceType
            this.ipv4PrefixCount = x.ipv4PrefixCount
            this.ipv4Prefixes = x.ipv4Prefixes
            this.ipv6AddressCount = x.ipv6AddressCount
            this.ipv6Addresses = x.ipv6Addresses
            this.ipv6PrefixCount = x.ipv6PrefixCount
            this.ipv6Prefixes = x.ipv6Prefixes
            this.networkCardIndex = x.networkCardIndex
            this.networkInterfaceId = x.networkInterfaceId
            this.privateIpAddress = x.privateIpAddress
            this.privateIpAddresses = x.privateIpAddresses
            this.secondaryPrivateIpAddressCount = x.secondaryPrivateIpAddressCount
            this.subnetId = x.subnetId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.InstanceNetworkInterfaceSpecification = InstanceNetworkInterfaceSpecification(this)
    }
}
