// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



public class DescribeVpcPeeringConnectionsRequest private constructor(builder: Builder) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * One or more filters.
     * + `accepter-vpc-info.cidr-block` - The IPv4 CIDR block of the accepter VPC.
     * + `accepter-vpc-info.owner-id` - The ID of the Amazon Web Services account that owns the accepter VPC.
     * + `accepter-vpc-info.vpc-id` - The ID of the accepter VPC.
     * + `expiration-time` - The expiration date and time for the VPC peering connection.
     * + `requester-vpc-info.cidr-block` - The IPv4 CIDR block of the requester's VPC.
     * + `requester-vpc-info.owner-id` - The ID of the Amazon Web Services account that owns the requester VPC.
     * + `requester-vpc-info.vpc-id` - The ID of the requester VPC.
     * + `status-code` - The status of the VPC peering connection (`pending-acceptance` | `failed` | `expired` | `provisioning` | `active` | `deleting` | `deleted` | `rejected`).
     * + `status-message` - A message that provides more information about the status of the VPC peering connection, if applicable.
     * + `tag`:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key `Owner` and the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
     * + `tag-key` - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
     * + `vpc-peering-connection-id` - The ID of the VPC peering connection.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned `nextToken` value.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token for the next page of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * One or more VPC peering connection IDs.
     *
     * Default: Describes all your VPC peering connections.
     */
    public val vpcPeeringConnectionIds: List<String>? = builder.vpcPeeringConnectionIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.DescribeVpcPeeringConnectionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeVpcPeeringConnectionsRequest(")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("vpcPeeringConnectionIds=$vpcPeeringConnectionIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (vpcPeeringConnectionIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeVpcPeeringConnectionsRequest

        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (vpcPeeringConnectionIds != other.vpcPeeringConnectionIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.DescribeVpcPeeringConnectionsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * One or more filters.
         * + `accepter-vpc-info.cidr-block` - The IPv4 CIDR block of the accepter VPC.
         * + `accepter-vpc-info.owner-id` - The ID of the Amazon Web Services account that owns the accepter VPC.
         * + `accepter-vpc-info.vpc-id` - The ID of the accepter VPC.
         * + `expiration-time` - The expiration date and time for the VPC peering connection.
         * + `requester-vpc-info.cidr-block` - The IPv4 CIDR block of the requester's VPC.
         * + `requester-vpc-info.owner-id` - The ID of the Amazon Web Services account that owns the requester VPC.
         * + `requester-vpc-info.vpc-id` - The ID of the requester VPC.
         * + `status-code` - The status of the VPC peering connection (`pending-acceptance` | `failed` | `expired` | `provisioning` | `active` | `deleting` | `deleted` | `rejected`).
         * + `status-message` - A message that provides more information about the status of the VPC peering connection, if applicable.
         * + `tag`:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key `Owner` and the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
         * + `tag-key` - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         * + `vpc-peering-connection-id` - The ID of the VPC peering connection.
         */
        public var filters: List<Filter>? = null
        /**
         * The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned `nextToken` value.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token for the next page of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * One or more VPC peering connection IDs.
         *
         * Default: Describes all your VPC peering connections.
         */
        public var vpcPeeringConnectionIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.DescribeVpcPeeringConnectionsRequest) : this() {
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.vpcPeeringConnectionIds = x.vpcPeeringConnectionIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.DescribeVpcPeeringConnectionsRequest = DescribeVpcPeeringConnectionsRequest(this)
    }
}
