// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for DescribeVpcEndpoints.
 */
public class DescribeVpcEndpointsRequest private constructor(builder: Builder) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * One or more filters.
     * + `ip-address-type` - The IP address type (`ipv4` | `ipv6`).
     * + `service-name` - The name of the service.
     * + `vpc-id` - The ID of the VPC in which the endpoint resides.
     * + `vpc-endpoint-id` - The ID of the endpoint.
     * + `vpc-endpoint-state` - The state of the endpoint (`pendingAcceptance` | `pending` | `available` | `deleting` | `deleted` | `rejected` | `failed`).
     * + `vpc-endpoint-type` - The type of VPC endpoint (`Interface` | `Gateway` | `GatewayLoadBalancer`).
     * + `tag`:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key `Owner` and the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
     * + `tag-key` - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of items to return for this request. The request returns a token that you can specify in a subsequent call to get the next set of results.
     *
     * Constraint: If the value is greater than 1,000, we return only 1,000 items.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token for the next set of items to return. (You received this token from a prior call.)
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * One or more endpoint IDs.
     */
    public val vpcEndpointIds: List<String>? = builder.vpcEndpointIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.DescribeVpcEndpointsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeVpcEndpointsRequest(")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("vpcEndpointIds=$vpcEndpointIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeVpcEndpointsRequest

        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (vpcEndpointIds != other.vpcEndpointIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.DescribeVpcEndpointsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * One or more filters.
         * + `ip-address-type` - The IP address type (`ipv4` | `ipv6`).
         * + `service-name` - The name of the service.
         * + `vpc-id` - The ID of the VPC in which the endpoint resides.
         * + `vpc-endpoint-id` - The ID of the endpoint.
         * + `vpc-endpoint-state` - The state of the endpoint (`pendingAcceptance` | `pending` | `available` | `deleting` | `deleted` | `rejected` | `failed`).
         * + `vpc-endpoint-type` - The type of VPC endpoint (`Interface` | `Gateway` | `GatewayLoadBalancer`).
         * + `tag`:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key `Owner` and the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
         * + `tag-key` - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         */
        public var filters: List<Filter>? = null
        /**
         * The maximum number of items to return for this request. The request returns a token that you can specify in a subsequent call to get the next set of results.
         *
         * Constraint: If the value is greater than 1,000, we return only 1,000 items.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token for the next set of items to return. (You received this token from a prior call.)
         */
        public var nextToken: kotlin.String? = null
        /**
         * One or more endpoint IDs.
         */
        public var vpcEndpointIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.DescribeVpcEndpointsRequest) : this() {
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.vpcEndpointIds = x.vpcEndpointIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.DescribeVpcEndpointsRequest = DescribeVpcEndpointsRequest(this)
    }
}
