// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



public class DescribeSecurityGroupsRequest private constructor(builder: Builder) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The filters. If using multiple filters for rules, the results include security groups for which any combination of rules - not necessarily a single rule - match all filters.
     * + `description` - The description of the security group.
     * + `egress.ip-permission.cidr` - An IPv4 CIDR block for an outbound security group rule.
     * + `egress.ip-permission.from-port` - For an outbound rule, the start of port range for the TCP and UDP protocols, or an ICMP type number.
     * + `egress.ip-permission.group-id` - The ID of a security group that has been referenced in an outbound security group rule.
     * + `egress.ip-permission.group-name` - The name of a security group that is referenced in an outbound security group rule.
     * + `egress.ip-permission.ipv6-cidr` - An IPv6 CIDR block for an outbound security group rule.
     * + `egress.ip-permission.prefix-list-id` - The ID of a prefix list to which a security group rule allows outbound access.
     * + `egress.ip-permission.protocol` - The IP protocol for an outbound security group rule (`tcp` | `udp` | `icmp`, a protocol number, or -1 for all protocols).
     * + `egress.ip-permission.to-port` - For an outbound rule, the end of port range for the TCP and UDP protocols, or an ICMP code.
     * + `egress.ip-permission.user-id` - The ID of an Amazon Web Services account that has been referenced in an outbound security group rule.
     * + `group-id` - The ID of the security group.
     * + `group-name` - The name of the security group.
     * + `ip-permission.cidr` - An IPv4 CIDR block for an inbound security group rule.
     * + `ip-permission.from-port` - For an inbound rule, the start of port range for the TCP and UDP protocols, or an ICMP type number.
     * + `ip-permission.group-id` - The ID of a security group that has been referenced in an inbound security group rule.
     * + `ip-permission.group-name` - The name of a security group that is referenced in an inbound security group rule.
     * + `ip-permission.ipv6-cidr` - An IPv6 CIDR block for an inbound security group rule.
     * + `ip-permission.prefix-list-id` - The ID of a prefix list from which a security group rule allows inbound access.
     * + `ip-permission.protocol` - The IP protocol for an inbound security group rule (`tcp` | `udp` | `icmp`, a protocol number, or -1 for all protocols).
     * + `ip-permission.to-port` - For an inbound rule, the end of port range for the TCP and UDP protocols, or an ICMP code.
     * + `ip-permission.user-id` - The ID of an Amazon Web Services account that has been referenced in an inbound security group rule.
     * + `owner-id` - The Amazon Web Services account ID of the owner of the security group.
     * + `tag`:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key `Owner` and the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
     * + `tag-key` - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
     * + `vpc-id` - The ID of the VPC specified when the security group was created.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * The IDs of the security groups. Required for security groups in a nondefault VPC.
     *
     * Default: Describes all of your security groups.
     */
    public val groupIds: List<String>? = builder.groupIds
    /**
     * &#91;EC2-Classic and default VPC only&#93; The names of the security groups. You can specify either the security group name or the security group ID. For security groups in a nondefault VPC, use the `group-name` filter to describe security groups by name.
     *
     * Default: Describes all of your security groups.
     */
    public val groupNames: List<String>? = builder.groupNames
    /**
     * The maximum number of results to return in a single call. To retrieve the remaining results, make another request with the returned `NextToken` value. This value can be between 5 and 1000. If this parameter is not specified, then all results are returned.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to request the next page of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.DescribeSecurityGroupsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeSecurityGroupsRequest(")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("groupIds=$groupIds,")
        append("groupNames=$groupNames,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (groupIds?.hashCode() ?: 0)
        result = 31 * result + (groupNames?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeSecurityGroupsRequest

        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (groupIds != other.groupIds) return false
        if (groupNames != other.groupNames) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.DescribeSecurityGroupsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * The filters. If using multiple filters for rules, the results include security groups for which any combination of rules - not necessarily a single rule - match all filters.
         * + `description` - The description of the security group.
         * + `egress.ip-permission.cidr` - An IPv4 CIDR block for an outbound security group rule.
         * + `egress.ip-permission.from-port` - For an outbound rule, the start of port range for the TCP and UDP protocols, or an ICMP type number.
         * + `egress.ip-permission.group-id` - The ID of a security group that has been referenced in an outbound security group rule.
         * + `egress.ip-permission.group-name` - The name of a security group that is referenced in an outbound security group rule.
         * + `egress.ip-permission.ipv6-cidr` - An IPv6 CIDR block for an outbound security group rule.
         * + `egress.ip-permission.prefix-list-id` - The ID of a prefix list to which a security group rule allows outbound access.
         * + `egress.ip-permission.protocol` - The IP protocol for an outbound security group rule (`tcp` | `udp` | `icmp`, a protocol number, or -1 for all protocols).
         * + `egress.ip-permission.to-port` - For an outbound rule, the end of port range for the TCP and UDP protocols, or an ICMP code.
         * + `egress.ip-permission.user-id` - The ID of an Amazon Web Services account that has been referenced in an outbound security group rule.
         * + `group-id` - The ID of the security group.
         * + `group-name` - The name of the security group.
         * + `ip-permission.cidr` - An IPv4 CIDR block for an inbound security group rule.
         * + `ip-permission.from-port` - For an inbound rule, the start of port range for the TCP and UDP protocols, or an ICMP type number.
         * + `ip-permission.group-id` - The ID of a security group that has been referenced in an inbound security group rule.
         * + `ip-permission.group-name` - The name of a security group that is referenced in an inbound security group rule.
         * + `ip-permission.ipv6-cidr` - An IPv6 CIDR block for an inbound security group rule.
         * + `ip-permission.prefix-list-id` - The ID of a prefix list from which a security group rule allows inbound access.
         * + `ip-permission.protocol` - The IP protocol for an inbound security group rule (`tcp` | `udp` | `icmp`, a protocol number, or -1 for all protocols).
         * + `ip-permission.to-port` - For an inbound rule, the end of port range for the TCP and UDP protocols, or an ICMP code.
         * + `ip-permission.user-id` - The ID of an Amazon Web Services account that has been referenced in an inbound security group rule.
         * + `owner-id` - The Amazon Web Services account ID of the owner of the security group.
         * + `tag`:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key `Owner` and the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
         * + `tag-key` - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         * + `vpc-id` - The ID of the VPC specified when the security group was created.
         */
        public var filters: List<Filter>? = null
        /**
         * The IDs of the security groups. Required for security groups in a nondefault VPC.
         *
         * Default: Describes all of your security groups.
         */
        public var groupIds: List<String>? = null
        /**
         * &#91;EC2-Classic and default VPC only&#93; The names of the security groups. You can specify either the security group name or the security group ID. For security groups in a nondefault VPC, use the `group-name` filter to describe security groups by name.
         *
         * Default: Describes all of your security groups.
         */
        public var groupNames: List<String>? = null
        /**
         * The maximum number of results to return in a single call. To retrieve the remaining results, make another request with the returned `NextToken` value. This value can be between 5 and 1000. If this parameter is not specified, then all results are returned.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token to request the next page of results.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.DescribeSecurityGroupsRequest) : this() {
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.groupIds = x.groupIds
            this.groupNames = x.groupNames
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.DescribeSecurityGroupsRequest = DescribeSecurityGroupsRequest(this)
    }
}
