// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for DescribeScheduledInstances.
 */
public class DescribeScheduledInstancesRequest private constructor(builder: Builder) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The filters.
     * + `availability-zone` - The Availability Zone (for example, `us-west-2a`).
     * + `instance-type` - The instance type (for example, `c4.large`).
     * + `network-platform` - The network platform (`EC2-Classic` or `EC2-VPC`).
     * + `platform` - The platform (`Linux/UNIX` or `Windows`).
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of results to return in a single call. This value can be between 5 and 300. The default value is 100. To retrieve the remaining results, make another call with the returned `NextToken` value.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token for the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The Scheduled Instance IDs.
     */
    public val scheduledInstanceIds: List<String>? = builder.scheduledInstanceIds
    /**
     * The time period for the first schedule to start.
     */
    public val slotStartTimeRange: aws.sdk.kotlin.services.ec2.model.SlotStartTimeRangeRequest? = builder.slotStartTimeRange

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.DescribeScheduledInstancesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeScheduledInstancesRequest(")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("scheduledInstanceIds=$scheduledInstanceIds,")
        append("slotStartTimeRange=$slotStartTimeRange)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (scheduledInstanceIds?.hashCode() ?: 0)
        result = 31 * result + (slotStartTimeRange?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeScheduledInstancesRequest

        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (scheduledInstanceIds != other.scheduledInstanceIds) return false
        if (slotStartTimeRange != other.slotStartTimeRange) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.DescribeScheduledInstancesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * The filters.
         * + `availability-zone` - The Availability Zone (for example, `us-west-2a`).
         * + `instance-type` - The instance type (for example, `c4.large`).
         * + `network-platform` - The network platform (`EC2-Classic` or `EC2-VPC`).
         * + `platform` - The platform (`Linux/UNIX` or `Windows`).
         */
        public var filters: List<Filter>? = null
        /**
         * The maximum number of results to return in a single call. This value can be between 5 and 300. The default value is 100. To retrieve the remaining results, make another call with the returned `NextToken` value.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token for the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The Scheduled Instance IDs.
         */
        public var scheduledInstanceIds: List<String>? = null
        /**
         * The time period for the first schedule to start.
         */
        public var slotStartTimeRange: aws.sdk.kotlin.services.ec2.model.SlotStartTimeRangeRequest? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.DescribeScheduledInstancesRequest) : this() {
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.scheduledInstanceIds = x.scheduledInstanceIds
            this.slotStartTimeRange = x.slotStartTimeRange
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.DescribeScheduledInstancesRequest = DescribeScheduledInstancesRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.SlotStartTimeRangeRequest] inside the given [block]
         */
        public fun slotStartTimeRange(block: aws.sdk.kotlin.services.ec2.model.SlotStartTimeRangeRequest.Builder.() -> kotlin.Unit) {
            this.slotStartTimeRange = aws.sdk.kotlin.services.ec2.model.SlotStartTimeRangeRequest.invoke(block)
        }
    }
}
