// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



public class DescribeElasticGpusRequest private constructor(builder: Builder) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The Elastic Graphics accelerator IDs.
     */
    public val elasticGpuIds: List<String>? = builder.elasticGpuIds
    /**
     * The filters.
     * + `availability-zone` - The Availability Zone in which the Elastic Graphics accelerator resides.
     * + `elastic-gpu-health` - The status of the Elastic Graphics accelerator (`OK` | `IMPAIRED`).
     * + `elastic-gpu-state` - The state of the Elastic Graphics accelerator (`ATTACHED`).
     * + `elastic-gpu-type` - The type of Elastic Graphics accelerator; for example, `eg1.medium`.
     * + `instance-id` - The ID of the instance to which the Elastic Graphics accelerator is associated.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned `NextToken` value. This value can be between 5 and 1000.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to request the next page of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.DescribeElasticGpusRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeElasticGpusRequest(")
        append("dryRun=$dryRun,")
        append("elasticGpuIds=$elasticGpuIds,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (elasticGpuIds?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeElasticGpusRequest

        if (dryRun != other.dryRun) return false
        if (elasticGpuIds != other.elasticGpuIds) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.DescribeElasticGpusRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * The Elastic Graphics accelerator IDs.
         */
        public var elasticGpuIds: List<String>? = null
        /**
         * The filters.
         * + `availability-zone` - The Availability Zone in which the Elastic Graphics accelerator resides.
         * + `elastic-gpu-health` - The status of the Elastic Graphics accelerator (`OK` | `IMPAIRED`).
         * + `elastic-gpu-state` - The state of the Elastic Graphics accelerator (`ATTACHED`).
         * + `elastic-gpu-type` - The type of Elastic Graphics accelerator; for example, `eg1.medium`.
         * + `instance-id` - The ID of the instance to which the Elastic Graphics accelerator is associated.
         */
        public var filters: List<Filter>? = null
        /**
         * The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned `NextToken` value. This value can be between 5 and 1000.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token to request the next page of results.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.DescribeElasticGpusRequest) : this() {
            this.dryRun = x.dryRun
            this.elasticGpuIds = x.elasticGpuIds
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.DescribeElasticGpusRequest = DescribeElasticGpusRequest(this)
    }
}
