// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for CreateVpcEndpoint.
 */
public class CreateVpcEndpointRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see [How to ensure idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The DNS options for the endpoint.
     */
    public val dnsOptions: aws.sdk.kotlin.services.ec2.model.DnsOptionsSpecification? = builder.dnsOptions
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The IP address type for the endpoint.
     */
    public val ipAddressType: aws.sdk.kotlin.services.ec2.model.IpAddressType? = builder.ipAddressType
    /**
     * (Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the service. The policy must be in valid JSON format. If this parameter is not specified, we attach a default policy that allows full access to the service.
     */
    public val policyDocument: kotlin.String? = builder.policyDocument
    /**
     * (Interface endpoint) Indicates whether to associate a private hosted zone with the specified VPC. The private hosted zone contains a record set for the default public DNS name for the service for the Region (for example, `kinesis.us-east-1.amazonaws.com`), which resolves to the private IP addresses of the endpoint network interfaces in the VPC. This enables you to make requests to the default public DNS name for the service instead of the public DNS names that are automatically generated by the VPC endpoint service.
     *
     * To use a private hosted zone, you must set the following VPC attributes to `true`: `enableDnsHostnames` and `enableDnsSupport`. Use ModifyVpcAttribute to set the VPC attributes.
     *
     * Default: `true`
     */
    public val privateDnsEnabled: kotlin.Boolean? = builder.privateDnsEnabled
    /**
     * (Gateway endpoint) One or more route table IDs.
     */
    public val routeTableIds: List<String>? = builder.routeTableIds
    /**
     * (Interface endpoint) The ID of one or more security groups to associate with the endpoint network interface.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The service name. To get a list of available services, use the DescribeVpcEndpointServices request, or get the name from the service provider.
     */
    public val serviceName: kotlin.String? = builder.serviceName
    /**
     * (Interface and Gateway Load Balancer endpoints) The ID of one or more subnets in which to create an endpoint network interface. For a Gateway Load Balancer endpoint, you can specify one subnet only.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * The tags to associate with the endpoint.
     */
    public val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * The type of endpoint.
     *
     * Default: Gateway
     */
    public val vpcEndpointType: aws.sdk.kotlin.services.ec2.model.VpcEndpointType? = builder.vpcEndpointType
    /**
     * The ID of the VPC in which the endpoint will be used.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.CreateVpcEndpointRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateVpcEndpointRequest(")
        append("clientToken=$clientToken,")
        append("dnsOptions=$dnsOptions,")
        append("dryRun=$dryRun,")
        append("ipAddressType=$ipAddressType,")
        append("policyDocument=$policyDocument,")
        append("privateDnsEnabled=$privateDnsEnabled,")
        append("routeTableIds=$routeTableIds,")
        append("securityGroupIds=$securityGroupIds,")
        append("serviceName=$serviceName,")
        append("subnetIds=$subnetIds,")
        append("tagSpecifications=$tagSpecifications,")
        append("vpcEndpointType=$vpcEndpointType,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (dnsOptions?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (ipAddressType?.hashCode() ?: 0)
        result = 31 * result + (policyDocument?.hashCode() ?: 0)
        result = 31 * result + (privateDnsEnabled?.hashCode() ?: 0)
        result = 31 * result + (routeTableIds?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointType?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateVpcEndpointRequest

        if (clientToken != other.clientToken) return false
        if (dnsOptions != other.dnsOptions) return false
        if (dryRun != other.dryRun) return false
        if (ipAddressType != other.ipAddressType) return false
        if (policyDocument != other.policyDocument) return false
        if (privateDnsEnabled != other.privateDnsEnabled) return false
        if (routeTableIds != other.routeTableIds) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (serviceName != other.serviceName) return false
        if (subnetIds != other.subnetIds) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (vpcEndpointType != other.vpcEndpointType) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.CreateVpcEndpointRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see [How to ensure idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
         */
        public var clientToken: kotlin.String? = null
        /**
         * The DNS options for the endpoint.
         */
        public var dnsOptions: aws.sdk.kotlin.services.ec2.model.DnsOptionsSpecification? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * The IP address type for the endpoint.
         */
        public var ipAddressType: aws.sdk.kotlin.services.ec2.model.IpAddressType? = null
        /**
         * (Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the service. The policy must be in valid JSON format. If this parameter is not specified, we attach a default policy that allows full access to the service.
         */
        public var policyDocument: kotlin.String? = null
        /**
         * (Interface endpoint) Indicates whether to associate a private hosted zone with the specified VPC. The private hosted zone contains a record set for the default public DNS name for the service for the Region (for example, `kinesis.us-east-1.amazonaws.com`), which resolves to the private IP addresses of the endpoint network interfaces in the VPC. This enables you to make requests to the default public DNS name for the service instead of the public DNS names that are automatically generated by the VPC endpoint service.
         *
         * To use a private hosted zone, you must set the following VPC attributes to `true`: `enableDnsHostnames` and `enableDnsSupport`. Use ModifyVpcAttribute to set the VPC attributes.
         *
         * Default: `true`
         */
        public var privateDnsEnabled: kotlin.Boolean? = null
        /**
         * (Gateway endpoint) One or more route table IDs.
         */
        public var routeTableIds: List<String>? = null
        /**
         * (Interface endpoint) The ID of one or more security groups to associate with the endpoint network interface.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The service name. To get a list of available services, use the DescribeVpcEndpointServices request, or get the name from the service provider.
         */
        public var serviceName: kotlin.String? = null
        /**
         * (Interface and Gateway Load Balancer endpoints) The ID of one or more subnets in which to create an endpoint network interface. For a Gateway Load Balancer endpoint, you can specify one subnet only.
         */
        public var subnetIds: List<String>? = null
        /**
         * The tags to associate with the endpoint.
         */
        public var tagSpecifications: List<TagSpecification>? = null
        /**
         * The type of endpoint.
         *
         * Default: Gateway
         */
        public var vpcEndpointType: aws.sdk.kotlin.services.ec2.model.VpcEndpointType? = null
        /**
         * The ID of the VPC in which the endpoint will be used.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.CreateVpcEndpointRequest) : this() {
            this.clientToken = x.clientToken
            this.dnsOptions = x.dnsOptions
            this.dryRun = x.dryRun
            this.ipAddressType = x.ipAddressType
            this.policyDocument = x.policyDocument
            this.privateDnsEnabled = x.privateDnsEnabled
            this.routeTableIds = x.routeTableIds
            this.securityGroupIds = x.securityGroupIds
            this.serviceName = x.serviceName
            this.subnetIds = x.subnetIds
            this.tagSpecifications = x.tagSpecifications
            this.vpcEndpointType = x.vpcEndpointType
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.CreateVpcEndpointRequest = CreateVpcEndpointRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.DnsOptionsSpecification] inside the given [block]
         */
        public fun dnsOptions(block: aws.sdk.kotlin.services.ec2.model.DnsOptionsSpecification.Builder.() -> kotlin.Unit) {
            this.dnsOptions = aws.sdk.kotlin.services.ec2.model.DnsOptionsSpecification.invoke(block)
        }
    }
}
