// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

public class CreateCapacityReservationFleetRequest private constructor(builder: Builder) {
    /**
     * The strategy used by the Capacity Reservation Fleet to determine which of the specified instance types to use. Currently, only the `prioritized` allocation strategy is supported. For more information, see [ Allocation strategy](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#allocation-strategy) in the Amazon EC2 User Guide.
     *
     * Valid values: `prioritized`
     */
    public val allocationStrategy: kotlin.String? = builder.allocationStrategy
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see [Ensure Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The date and time at which the Capacity Reservation Fleet expires. When the Capacity Reservation Fleet expires, its state changes to `expired` and all of the Capacity Reservations in the Fleet expire.
     *
     * The Capacity Reservation Fleet expires within an hour after the specified time. For example, if you specify `5/31/2019`, `13:30:55`, the Capacity Reservation Fleet is guaranteed to expire between `13:30:55` and `14:30:55` on `5/31/2019`.
     */
    public val endDate: aws.smithy.kotlin.runtime.time.Instant? = builder.endDate
    /**
     * Indicates the type of instance launches that the Capacity Reservation Fleet accepts. All Capacity Reservations in the Fleet inherit this instance matching criteria.
     *
     * Currently, Capacity Reservation Fleets support `open` instance matching criteria only. This means that instances that have matching attributes (instance type, platform, and Availability Zone) run in the Capacity Reservations automatically. Instances do not need to explicitly target a Capacity Reservation Fleet to use its reserved capacity.
     */
    public val instanceMatchCriteria: aws.sdk.kotlin.services.ec2.model.FleetInstanceMatchCriteria? = builder.instanceMatchCriteria
    /**
     * Information about the instance types for which to reserve the capacity.
     */
    public val instanceTypeSpecifications: List<ReservationFleetInstanceSpecification>? = builder.instanceTypeSpecifications
    /**
     * The tags to assign to the Capacity Reservation Fleet. The tags are automatically assigned to the Capacity Reservations in the Fleet.
     */
    public val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * Indicates the tenancy of the Capacity Reservation Fleet. All Capacity Reservations in the Fleet inherit this tenancy. The Capacity Reservation Fleet can have one of the following tenancy settings:
     * + `default` - The Capacity Reservation Fleet is created on hardware that is shared with other Amazon Web Services accounts.
     * + `dedicated` - The Capacity Reservations are created on single-tenant hardware that is dedicated to a single Amazon Web Services account.
     */
    public val tenancy: aws.sdk.kotlin.services.ec2.model.FleetCapacityReservationTenancy? = builder.tenancy
    /**
     * The total number of capacity units to be reserved by the Capacity Reservation Fleet. This value, together with the instance type weights that you assign to each instance type used by the Fleet determine the number of instances for which the Fleet reserves capacity. Both values are based on units that make sense for your workload. For more information, see [ Total target capacity](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity) in the Amazon EC2 User Guide.
     */
    public val totalTargetCapacity: kotlin.Int? = builder.totalTargetCapacity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.CreateCapacityReservationFleetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCapacityReservationFleetRequest(")
        append("allocationStrategy=$allocationStrategy,")
        append("clientToken=$clientToken,")
        append("dryRun=$dryRun,")
        append("endDate=$endDate,")
        append("instanceMatchCriteria=$instanceMatchCriteria,")
        append("instanceTypeSpecifications=$instanceTypeSpecifications,")
        append("tagSpecifications=$tagSpecifications,")
        append("tenancy=$tenancy,")
        append("totalTargetCapacity=$totalTargetCapacity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocationStrategy?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (endDate?.hashCode() ?: 0)
        result = 31 * result + (instanceMatchCriteria?.hashCode() ?: 0)
        result = 31 * result + (instanceTypeSpecifications?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (tenancy?.hashCode() ?: 0)
        result = 31 * result + (totalTargetCapacity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateCapacityReservationFleetRequest

        if (allocationStrategy != other.allocationStrategy) return false
        if (clientToken != other.clientToken) return false
        if (dryRun != other.dryRun) return false
        if (endDate != other.endDate) return false
        if (instanceMatchCriteria != other.instanceMatchCriteria) return false
        if (instanceTypeSpecifications != other.instanceTypeSpecifications) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (tenancy != other.tenancy) return false
        if (totalTargetCapacity != other.totalTargetCapacity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.CreateCapacityReservationFleetRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The strategy used by the Capacity Reservation Fleet to determine which of the specified instance types to use. Currently, only the `prioritized` allocation strategy is supported. For more information, see [ Allocation strategy](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#allocation-strategy) in the Amazon EC2 User Guide.
         *
         * Valid values: `prioritized`
         */
        public var allocationStrategy: kotlin.String? = null
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see [Ensure Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
         */
        public var clientToken: kotlin.String? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * The date and time at which the Capacity Reservation Fleet expires. When the Capacity Reservation Fleet expires, its state changes to `expired` and all of the Capacity Reservations in the Fleet expire.
         *
         * The Capacity Reservation Fleet expires within an hour after the specified time. For example, if you specify `5/31/2019`, `13:30:55`, the Capacity Reservation Fleet is guaranteed to expire between `13:30:55` and `14:30:55` on `5/31/2019`.
         */
        public var endDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates the type of instance launches that the Capacity Reservation Fleet accepts. All Capacity Reservations in the Fleet inherit this instance matching criteria.
         *
         * Currently, Capacity Reservation Fleets support `open` instance matching criteria only. This means that instances that have matching attributes (instance type, platform, and Availability Zone) run in the Capacity Reservations automatically. Instances do not need to explicitly target a Capacity Reservation Fleet to use its reserved capacity.
         */
        public var instanceMatchCriteria: aws.sdk.kotlin.services.ec2.model.FleetInstanceMatchCriteria? = null
        /**
         * Information about the instance types for which to reserve the capacity.
         */
        public var instanceTypeSpecifications: List<ReservationFleetInstanceSpecification>? = null
        /**
         * The tags to assign to the Capacity Reservation Fleet. The tags are automatically assigned to the Capacity Reservations in the Fleet.
         */
        public var tagSpecifications: List<TagSpecification>? = null
        /**
         * Indicates the tenancy of the Capacity Reservation Fleet. All Capacity Reservations in the Fleet inherit this tenancy. The Capacity Reservation Fleet can have one of the following tenancy settings:
         * + `default` - The Capacity Reservation Fleet is created on hardware that is shared with other Amazon Web Services accounts.
         * + `dedicated` - The Capacity Reservations are created on single-tenant hardware that is dedicated to a single Amazon Web Services account.
         */
        public var tenancy: aws.sdk.kotlin.services.ec2.model.FleetCapacityReservationTenancy? = null
        /**
         * The total number of capacity units to be reserved by the Capacity Reservation Fleet. This value, together with the instance type weights that you assign to each instance type used by the Fleet determine the number of instances for which the Fleet reserves capacity. Both values are based on units that make sense for your workload. For more information, see [ Total target capacity](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity) in the Amazon EC2 User Guide.
         */
        public var totalTargetCapacity: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.CreateCapacityReservationFleetRequest) : this() {
            this.allocationStrategy = x.allocationStrategy
            this.clientToken = x.clientToken
            this.dryRun = x.dryRun
            this.endDate = x.endDate
            this.instanceMatchCriteria = x.instanceMatchCriteria
            this.instanceTypeSpecifications = x.instanceTypeSpecifications
            this.tagSpecifications = x.tagSpecifications
            this.tenancy = x.tenancy
            this.totalTargetCapacity = x.totalTargetCapacity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.CreateCapacityReservationFleetRequest = CreateCapacityReservationFleetRequest(this)
    }
}
