// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a conversion task.
 */
public class ConversionTask private constructor(builder: Builder) {
    /**
     * The ID of the conversion task.
     */
    public val conversionTaskId: kotlin.String? = builder.conversionTaskId
    /**
     * The time when the task expires. If the upload isn't complete before the expiration time, we automatically cancel the task.
     */
    public val expirationTime: kotlin.String? = builder.expirationTime
    /**
     * If the task is for importing an instance, this contains information about the import instance task.
     */
    public val importInstance: aws.sdk.kotlin.services.ec2.model.ImportInstanceTaskDetails? = builder.importInstance
    /**
     * If the task is for importing a volume, this contains information about the import volume task.
     */
    public val importVolume: aws.sdk.kotlin.services.ec2.model.ImportVolumeTaskDetails? = builder.importVolume
    /**
     * The state of the conversion task.
     */
    public val state: aws.sdk.kotlin.services.ec2.model.ConversionTaskState? = builder.state
    /**
     * The status message related to the conversion task.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * Any tags assigned to the task.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.ConversionTask = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConversionTask(")
        append("conversionTaskId=$conversionTaskId,")
        append("expirationTime=$expirationTime,")
        append("importInstance=$importInstance,")
        append("importVolume=$importVolume,")
        append("state=$state,")
        append("statusMessage=$statusMessage,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = conversionTaskId?.hashCode() ?: 0
        result = 31 * result + (expirationTime?.hashCode() ?: 0)
        result = 31 * result + (importInstance?.hashCode() ?: 0)
        result = 31 * result + (importVolume?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConversionTask

        if (conversionTaskId != other.conversionTaskId) return false
        if (expirationTime != other.expirationTime) return false
        if (importInstance != other.importInstance) return false
        if (importVolume != other.importVolume) return false
        if (state != other.state) return false
        if (statusMessage != other.statusMessage) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.ConversionTask = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the conversion task.
         */
        public var conversionTaskId: kotlin.String? = null
        /**
         * The time when the task expires. If the upload isn't complete before the expiration time, we automatically cancel the task.
         */
        public var expirationTime: kotlin.String? = null
        /**
         * If the task is for importing an instance, this contains information about the import instance task.
         */
        public var importInstance: aws.sdk.kotlin.services.ec2.model.ImportInstanceTaskDetails? = null
        /**
         * If the task is for importing a volume, this contains information about the import volume task.
         */
        public var importVolume: aws.sdk.kotlin.services.ec2.model.ImportVolumeTaskDetails? = null
        /**
         * The state of the conversion task.
         */
        public var state: aws.sdk.kotlin.services.ec2.model.ConversionTaskState? = null
        /**
         * The status message related to the conversion task.
         */
        public var statusMessage: kotlin.String? = null
        /**
         * Any tags assigned to the task.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.ConversionTask) : this() {
            this.conversionTaskId = x.conversionTaskId
            this.expirationTime = x.expirationTime
            this.importInstance = x.importInstance
            this.importVolume = x.importVolume
            this.state = x.state
            this.statusMessage = x.statusMessage
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.ConversionTask = ConversionTask(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ImportInstanceTaskDetails] inside the given [block]
         */
        public fun importInstance(block: aws.sdk.kotlin.services.ec2.model.ImportInstanceTaskDetails.Builder.() -> kotlin.Unit) {
            this.importInstance = aws.sdk.kotlin.services.ec2.model.ImportInstanceTaskDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ImportVolumeTaskDetails] inside the given [block]
         */
        public fun importVolume(block: aws.sdk.kotlin.services.ec2.model.ImportVolumeTaskDetails.Builder.() -> kotlin.Unit) {
            this.importVolume = aws.sdk.kotlin.services.ec2.model.ImportVolumeTaskDetails.invoke(block)
        }
    }
}
