// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a Capacity Reservation.
 */
public class CapacityReservation private constructor(builder: Builder) {
    /**
     * The Availability Zone in which the capacity is reserved.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The Availability Zone ID of the Capacity Reservation.
     */
    public val availabilityZoneId: kotlin.String? = builder.availabilityZoneId
    /**
     * The remaining capacity. Indicates the number of instances that can be launched in the Capacity Reservation.
     */
    public val availableInstanceCount: kotlin.Int? = builder.availableInstanceCount
    /**
     * Information about instance capacity usage.
     */
    public val capacityAllocations: List<CapacityAllocation>? = builder.capacityAllocations
    /**
     * The Amazon Resource Name (ARN) of the Capacity Reservation.
     */
    public val capacityReservationArn: kotlin.String? = builder.capacityReservationArn
    /**
     * The ID of the Capacity Reservation Fleet to which the Capacity Reservation belongs. Only valid for Capacity Reservations that were created by a Capacity Reservation Fleet.
     */
    public val capacityReservationFleetId: kotlin.String? = builder.capacityReservationFleetId
    /**
     * The ID of the Capacity Reservation.
     */
    public val capacityReservationId: kotlin.String? = builder.capacityReservationId
    /**
     * The date and time at which the Capacity Reservation was created.
     */
    public val createDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createDate
    /**
     * Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS- optimized instance.
     */
    public val ebsOptimized: kotlin.Boolean? = builder.ebsOptimized
    /**
     * The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to `expired` when it reaches its end date and time.
     */
    public val endDate: aws.smithy.kotlin.runtime.time.Instant? = builder.endDate
    /**
     * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:
     * + `unlimited` - The Capacity Reservation remains active until you explicitly cancel it.
     * + `limited` - The Capacity Reservation expires automatically at a specified date and time.
     */
    public val endDateType: aws.sdk.kotlin.services.ec2.model.EndDateType? = builder.endDateType
    /**
     * *Deprecated.*
     */
    public val ephemeralStorage: kotlin.Boolean? = builder.ephemeralStorage
    /**
     * Indicates the type of instance launches that the Capacity Reservation accepts. The options include:
     * + `open` - The Capacity Reservation accepts all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes launch into the Capacity Reservation automatically without specifying any additional parameters.
     * + `targeted` - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity.
     */
    public val instanceMatchCriteria: aws.sdk.kotlin.services.ec2.model.InstanceMatchCriteria? = builder.instanceMatchCriteria
    /**
     * The type of operating system for which the Capacity Reservation reserves capacity.
     */
    public val instancePlatform: aws.sdk.kotlin.services.ec2.model.CapacityReservationInstancePlatform? = builder.instancePlatform
    /**
     * The type of instance for which the Capacity Reservation reserves capacity.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * The Amazon Resource Name (ARN) of the Outpost on which the Capacity Reservation was created.
     */
    public val outpostArn: kotlin.String? = builder.outpostArn
    /**
     * The ID of the Amazon Web Services account that owns the Capacity Reservation.
     */
    public val ownerId: kotlin.String? = builder.ownerId
    /**
     * The Amazon Resource Name (ARN) of the cluster placement group in which the Capacity Reservation was created. For more information, see [ Capacity Reservations for cluster placement groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-cpg.html) in the *Amazon EC2 User Guide*.
     */
    public val placementGroupArn: kotlin.String? = builder.placementGroupArn
    /**
     * The date and time at which the Capacity Reservation was started.
     */
    public val startDate: aws.smithy.kotlin.runtime.time.Instant? = builder.startDate
    /**
     * The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:
     * + `active` - The Capacity Reservation is active and the capacity is available for your use.
     * + `expired` - The Capacity Reservation expired automatically at the date and time specified in your request. The reserved capacity is no longer available for your use.
     * + `cancelled` - The Capacity Reservation was cancelled. The reserved capacity is no longer available for your use.
     * + `pending` - The Capacity Reservation request was successful but the capacity provisioning is still pending.
     * + `failed` - The Capacity Reservation request has failed. A request might fail due to invalid request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.
     */
    public val state: aws.sdk.kotlin.services.ec2.model.CapacityReservationState? = builder.state
    /**
     * Any tags assigned to the Capacity Reservation.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:
     * + `default` - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.
     * + `dedicated` - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.
     */
    public val tenancy: aws.sdk.kotlin.services.ec2.model.CapacityReservationTenancy? = builder.tenancy
    /**
     * The total number of instances for which the Capacity Reservation reserves capacity.
     */
    public val totalInstanceCount: kotlin.Int? = builder.totalInstanceCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.CapacityReservation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CapacityReservation(")
        append("availabilityZone=$availabilityZone,")
        append("availabilityZoneId=$availabilityZoneId,")
        append("availableInstanceCount=$availableInstanceCount,")
        append("capacityAllocations=$capacityAllocations,")
        append("capacityReservationArn=$capacityReservationArn,")
        append("capacityReservationFleetId=$capacityReservationFleetId,")
        append("capacityReservationId=$capacityReservationId,")
        append("createDate=$createDate,")
        append("ebsOptimized=$ebsOptimized,")
        append("endDate=$endDate,")
        append("endDateType=$endDateType,")
        append("ephemeralStorage=$ephemeralStorage,")
        append("instanceMatchCriteria=$instanceMatchCriteria,")
        append("instancePlatform=$instancePlatform,")
        append("instanceType=$instanceType,")
        append("outpostArn=$outpostArn,")
        append("ownerId=$ownerId,")
        append("placementGroupArn=$placementGroupArn,")
        append("startDate=$startDate,")
        append("state=$state,")
        append("tags=$tags,")
        append("tenancy=$tenancy,")
        append("totalInstanceCount=$totalInstanceCount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (availabilityZoneId?.hashCode() ?: 0)
        result = 31 * result + (availableInstanceCount ?: 0)
        result = 31 * result + (capacityAllocations?.hashCode() ?: 0)
        result = 31 * result + (capacityReservationArn?.hashCode() ?: 0)
        result = 31 * result + (capacityReservationFleetId?.hashCode() ?: 0)
        result = 31 * result + (capacityReservationId?.hashCode() ?: 0)
        result = 31 * result + (createDate?.hashCode() ?: 0)
        result = 31 * result + (ebsOptimized?.hashCode() ?: 0)
        result = 31 * result + (endDate?.hashCode() ?: 0)
        result = 31 * result + (endDateType?.hashCode() ?: 0)
        result = 31 * result + (ephemeralStorage?.hashCode() ?: 0)
        result = 31 * result + (instanceMatchCriteria?.hashCode() ?: 0)
        result = 31 * result + (instancePlatform?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (placementGroupArn?.hashCode() ?: 0)
        result = 31 * result + (startDate?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tenancy?.hashCode() ?: 0)
        result = 31 * result + (totalInstanceCount ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CapacityReservation

        if (availabilityZone != other.availabilityZone) return false
        if (availabilityZoneId != other.availabilityZoneId) return false
        if (availableInstanceCount != other.availableInstanceCount) return false
        if (capacityAllocations != other.capacityAllocations) return false
        if (capacityReservationArn != other.capacityReservationArn) return false
        if (capacityReservationFleetId != other.capacityReservationFleetId) return false
        if (capacityReservationId != other.capacityReservationId) return false
        if (createDate != other.createDate) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (endDate != other.endDate) return false
        if (endDateType != other.endDateType) return false
        if (ephemeralStorage != other.ephemeralStorage) return false
        if (instanceMatchCriteria != other.instanceMatchCriteria) return false
        if (instancePlatform != other.instancePlatform) return false
        if (instanceType != other.instanceType) return false
        if (outpostArn != other.outpostArn) return false
        if (ownerId != other.ownerId) return false
        if (placementGroupArn != other.placementGroupArn) return false
        if (startDate != other.startDate) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (tenancy != other.tenancy) return false
        if (totalInstanceCount != other.totalInstanceCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.CapacityReservation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Availability Zone in which the capacity is reserved.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The Availability Zone ID of the Capacity Reservation.
         */
        public var availabilityZoneId: kotlin.String? = null
        /**
         * The remaining capacity. Indicates the number of instances that can be launched in the Capacity Reservation.
         */
        public var availableInstanceCount: kotlin.Int? = null
        /**
         * Information about instance capacity usage.
         */
        public var capacityAllocations: List<CapacityAllocation>? = null
        /**
         * The Amazon Resource Name (ARN) of the Capacity Reservation.
         */
        public var capacityReservationArn: kotlin.String? = null
        /**
         * The ID of the Capacity Reservation Fleet to which the Capacity Reservation belongs. Only valid for Capacity Reservations that were created by a Capacity Reservation Fleet.
         */
        public var capacityReservationFleetId: kotlin.String? = null
        /**
         * The ID of the Capacity Reservation.
         */
        public var capacityReservationId: kotlin.String? = null
        /**
         * The date and time at which the Capacity Reservation was created.
         */
        public var createDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS- optimized instance.
         */
        public var ebsOptimized: kotlin.Boolean? = null
        /**
         * The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to `expired` when it reaches its end date and time.
         */
        public var endDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:
         * + `unlimited` - The Capacity Reservation remains active until you explicitly cancel it.
         * + `limited` - The Capacity Reservation expires automatically at a specified date and time.
         */
        public var endDateType: aws.sdk.kotlin.services.ec2.model.EndDateType? = null
        /**
         * *Deprecated.*
         */
        public var ephemeralStorage: kotlin.Boolean? = null
        /**
         * Indicates the type of instance launches that the Capacity Reservation accepts. The options include:
         * + `open` - The Capacity Reservation accepts all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes launch into the Capacity Reservation automatically without specifying any additional parameters.
         * + `targeted` - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity.
         */
        public var instanceMatchCriteria: aws.sdk.kotlin.services.ec2.model.InstanceMatchCriteria? = null
        /**
         * The type of operating system for which the Capacity Reservation reserves capacity.
         */
        public var instancePlatform: aws.sdk.kotlin.services.ec2.model.CapacityReservationInstancePlatform? = null
        /**
         * The type of instance for which the Capacity Reservation reserves capacity.
         */
        public var instanceType: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Outpost on which the Capacity Reservation was created.
         */
        public var outpostArn: kotlin.String? = null
        /**
         * The ID of the Amazon Web Services account that owns the Capacity Reservation.
         */
        public var ownerId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the cluster placement group in which the Capacity Reservation was created. For more information, see [ Capacity Reservations for cluster placement groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-cpg.html) in the *Amazon EC2 User Guide*.
         */
        public var placementGroupArn: kotlin.String? = null
        /**
         * The date and time at which the Capacity Reservation was started.
         */
        public var startDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:
         * + `active` - The Capacity Reservation is active and the capacity is available for your use.
         * + `expired` - The Capacity Reservation expired automatically at the date and time specified in your request. The reserved capacity is no longer available for your use.
         * + `cancelled` - The Capacity Reservation was cancelled. The reserved capacity is no longer available for your use.
         * + `pending` - The Capacity Reservation request was successful but the capacity provisioning is still pending.
         * + `failed` - The Capacity Reservation request has failed. A request might fail due to invalid request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.
         */
        public var state: aws.sdk.kotlin.services.ec2.model.CapacityReservationState? = null
        /**
         * Any tags assigned to the Capacity Reservation.
         */
        public var tags: List<Tag>? = null
        /**
         * Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:
         * + `default` - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.
         * + `dedicated` - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.
         */
        public var tenancy: aws.sdk.kotlin.services.ec2.model.CapacityReservationTenancy? = null
        /**
         * The total number of instances for which the Capacity Reservation reserves capacity.
         */
        public var totalInstanceCount: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.CapacityReservation) : this() {
            this.availabilityZone = x.availabilityZone
            this.availabilityZoneId = x.availabilityZoneId
            this.availableInstanceCount = x.availableInstanceCount
            this.capacityAllocations = x.capacityAllocations
            this.capacityReservationArn = x.capacityReservationArn
            this.capacityReservationFleetId = x.capacityReservationFleetId
            this.capacityReservationId = x.capacityReservationId
            this.createDate = x.createDate
            this.ebsOptimized = x.ebsOptimized
            this.endDate = x.endDate
            this.endDateType = x.endDateType
            this.ephemeralStorage = x.ephemeralStorage
            this.instanceMatchCriteria = x.instanceMatchCriteria
            this.instancePlatform = x.instancePlatform
            this.instanceType = x.instanceType
            this.outpostArn = x.outpostArn
            this.ownerId = x.ownerId
            this.placementGroupArn = x.placementGroupArn
            this.startDate = x.startDate
            this.state = x.state
            this.tags = x.tags
            this.tenancy = x.tenancy
            this.totalInstanceCount = x.totalInstanceCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.CapacityReservation = CapacityReservation(this)
    }
}
