// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes Availability Zones, Local Zones, and Wavelength Zones.
 */
public class AvailabilityZone private constructor(builder: Builder) {
    /**
     * For Availability Zones, this parameter has the same value as the Region name.
     *
     * For Local Zones, the name of the associated group, for example `us-west-2-lax-1`.
     *
     * For Wavelength Zones, the name of the associated group, for example `us-east-1-wl1-bos-wlz-1`.
     */
    public val groupName: kotlin.String? = builder.groupName
    /**
     * Any messages about the Availability Zone, Local Zone, or Wavelength Zone.
     */
    public val messages: List<AvailabilityZoneMessage>? = builder.messages
    /**
     * The name of the network border group.
     */
    public val networkBorderGroup: kotlin.String? = builder.networkBorderGroup
    /**
     * For Availability Zones, this parameter always has the value of `opt-in-not-required`.
     *
     * For Local Zones and Wavelength Zones, this parameter is the opt-in status. The possible values are `opted-in`, and `not-opted-in`.
     */
    public val optInStatus: aws.sdk.kotlin.services.ec2.model.AvailabilityZoneOptInStatus? = builder.optInStatus
    /**
     * The ID of the zone that handles some of the Local Zone or Wavelength Zone control plane operations, such as API calls.
     */
    public val parentZoneId: kotlin.String? = builder.parentZoneId
    /**
     * The name of the zone that handles some of the Local Zone or Wavelength Zone control plane operations, such as API calls.
     */
    public val parentZoneName: kotlin.String? = builder.parentZoneName
    /**
     * The name of the Region.
     */
    public val regionName: kotlin.String? = builder.regionName
    /**
     * The state of the Availability Zone, Local Zone, or Wavelength Zone. This value is always `available`.
     */
    public val state: aws.sdk.kotlin.services.ec2.model.AvailabilityZoneState? = builder.state
    /**
     * The ID of the Availability Zone, Local Zone, or Wavelength Zone.
     */
    public val zoneId: kotlin.String? = builder.zoneId
    /**
     * The name of the Availability Zone, Local Zone, or Wavelength Zone.
     */
    public val zoneName: kotlin.String? = builder.zoneName
    /**
     * The type of zone. The valid values are `availability-zone`, `local-zone`, and `wavelength-zone`.
     */
    public val zoneType: kotlin.String? = builder.zoneType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.AvailabilityZone = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AvailabilityZone(")
        append("groupName=$groupName,")
        append("messages=$messages,")
        append("networkBorderGroup=$networkBorderGroup,")
        append("optInStatus=$optInStatus,")
        append("parentZoneId=$parentZoneId,")
        append("parentZoneName=$parentZoneName,")
        append("regionName=$regionName,")
        append("state=$state,")
        append("zoneId=$zoneId,")
        append("zoneName=$zoneName,")
        append("zoneType=$zoneType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = groupName?.hashCode() ?: 0
        result = 31 * result + (messages?.hashCode() ?: 0)
        result = 31 * result + (networkBorderGroup?.hashCode() ?: 0)
        result = 31 * result + (optInStatus?.hashCode() ?: 0)
        result = 31 * result + (parentZoneId?.hashCode() ?: 0)
        result = 31 * result + (parentZoneName?.hashCode() ?: 0)
        result = 31 * result + (regionName?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (zoneId?.hashCode() ?: 0)
        result = 31 * result + (zoneName?.hashCode() ?: 0)
        result = 31 * result + (zoneType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AvailabilityZone

        if (groupName != other.groupName) return false
        if (messages != other.messages) return false
        if (networkBorderGroup != other.networkBorderGroup) return false
        if (optInStatus != other.optInStatus) return false
        if (parentZoneId != other.parentZoneId) return false
        if (parentZoneName != other.parentZoneName) return false
        if (regionName != other.regionName) return false
        if (state != other.state) return false
        if (zoneId != other.zoneId) return false
        if (zoneName != other.zoneName) return false
        if (zoneType != other.zoneType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.AvailabilityZone = Builder(this).apply(block).build()

    public class Builder {
        /**
         * For Availability Zones, this parameter has the same value as the Region name.
         *
         * For Local Zones, the name of the associated group, for example `us-west-2-lax-1`.
         *
         * For Wavelength Zones, the name of the associated group, for example `us-east-1-wl1-bos-wlz-1`.
         */
        public var groupName: kotlin.String? = null
        /**
         * Any messages about the Availability Zone, Local Zone, or Wavelength Zone.
         */
        public var messages: List<AvailabilityZoneMessage>? = null
        /**
         * The name of the network border group.
         */
        public var networkBorderGroup: kotlin.String? = null
        /**
         * For Availability Zones, this parameter always has the value of `opt-in-not-required`.
         *
         * For Local Zones and Wavelength Zones, this parameter is the opt-in status. The possible values are `opted-in`, and `not-opted-in`.
         */
        public var optInStatus: aws.sdk.kotlin.services.ec2.model.AvailabilityZoneOptInStatus? = null
        /**
         * The ID of the zone that handles some of the Local Zone or Wavelength Zone control plane operations, such as API calls.
         */
        public var parentZoneId: kotlin.String? = null
        /**
         * The name of the zone that handles some of the Local Zone or Wavelength Zone control plane operations, such as API calls.
         */
        public var parentZoneName: kotlin.String? = null
        /**
         * The name of the Region.
         */
        public var regionName: kotlin.String? = null
        /**
         * The state of the Availability Zone, Local Zone, or Wavelength Zone. This value is always `available`.
         */
        public var state: aws.sdk.kotlin.services.ec2.model.AvailabilityZoneState? = null
        /**
         * The ID of the Availability Zone, Local Zone, or Wavelength Zone.
         */
        public var zoneId: kotlin.String? = null
        /**
         * The name of the Availability Zone, Local Zone, or Wavelength Zone.
         */
        public var zoneName: kotlin.String? = null
        /**
         * The type of zone. The valid values are `availability-zone`, `local-zone`, and `wavelength-zone`.
         */
        public var zoneType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.AvailabilityZone) : this() {
            this.groupName = x.groupName
            this.messages = x.messages
            this.networkBorderGroup = x.networkBorderGroup
            this.optInStatus = x.optInStatus
            this.parentZoneId = x.parentZoneId
            this.parentZoneName = x.parentZoneName
            this.regionName = x.regionName
            this.state = x.state
            this.zoneId = x.zoneId
            this.zoneName = x.zoneName
            this.zoneType = x.zoneType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.AvailabilityZone = AvailabilityZone(this)
    }
}
