// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodbstreams.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.dynamodbstreams.model.DynamoDbStreamsException
import aws.sdk.kotlin.services.dynamodbstreams.model.GetShardIteratorResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetShardIteratorOperationDeserializer: HttpDeserialize<GetShardIteratorResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetShardIteratorResponse {
        if (!response.status.isSuccess()) {
            throwGetShardIteratorError(context, response)
        }
        val builder = GetShardIteratorResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetShardIteratorOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeGetShardIteratorOperationBody(builder: GetShardIteratorResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SHARDITERATOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ShardIterator"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SHARDITERATOR_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SHARDITERATOR_DESCRIPTOR.index -> builder.shardIterator = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwGetShardIteratorError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_0 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "TrimmedDataAccessException" -> TrimmedDataAccessExceptionDeserializer()
        else -> throw DynamoDbStreamsException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
