// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodbstreams.model



/**
 * Represents a single element of a key schema. A key schema specifies
 * the attributes that make up the primary key of a table, or the key attributes of an
 * index.
 * A KeySchemaElement represents exactly one attribute of the primary key. For
 * example, a simple primary key would be represented by one KeySchemaElement
 * (for the partition key). A composite primary key would require one
 * KeySchemaElement for the partition key, and another
 * KeySchemaElement for the sort key.
 * A KeySchemaElement must be a scalar, top-level attribute (not a nested
 * attribute). The data type must be one of String, Number, or Binary. The attribute cannot
 * be nested within a List or a Map.
 */
class KeySchemaElement private constructor(builder: Builder) {
    /**
     * The name of a key attribute.
     */
    val attributeName: kotlin.String? = builder.attributeName
    /**
     * The role that this key attribute will assume:
     * HASH - partition key
     * RANGE - sort key
     * The partition key of an item is also known as its hash
     * attribute. The term "hash attribute" derives from DynamoDB's usage of
     * an internal hash function to evenly distribute data items across partitions, based
     * on their partition key values.
     * The sort key of an item is also known as its range
     * attribute. The term "range attribute" derives from the way DynamoDB
     * stores items with the same partition key physically close together, in sorted order
     * by the sort key value.
     */
    val keyType: aws.sdk.kotlin.services.dynamodbstreams.model.KeyType? = builder.keyType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodbstreams.model.KeySchemaElement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KeySchemaElement(")
        append("attributeName=$attributeName,")
        append("keyType=$keyType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeName?.hashCode() ?: 0
        result = 31 * result + (keyType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as KeySchemaElement

        if (attributeName != other.attributeName) return false
        if (keyType != other.keyType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodbstreams.model.KeySchemaElement = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of a key attribute.
         */
        var attributeName: kotlin.String? = null
        /**
         * The role that this key attribute will assume:
         * HASH - partition key
         * RANGE - sort key
         * The partition key of an item is also known as its hash
         * attribute. The term "hash attribute" derives from DynamoDB's usage of
         * an internal hash function to evenly distribute data items across partitions, based
         * on their partition key values.
         * The sort key of an item is also known as its range
         * attribute. The term "range attribute" derives from the way DynamoDB
         * stores items with the same partition key physically close together, in sorted order
         * by the sort key value.
         */
        var keyType: aws.sdk.kotlin.services.dynamodbstreams.model.KeyType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodbstreams.model.KeySchemaElement) : this() {
            this.attributeName = x.attributeName
            this.keyType = x.keyType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodbstreams.model.KeySchemaElement = KeySchemaElement(this)
    }
}
